/**********************************************************
     file name : reform.c
	                      Coded by Shigeru HITOMI
			               Keisuke TAKEBE
***********************************************************/
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

typedef short boolean;

int
main()
{
  int dim, dim2, len1, len2;
  int idx[MAX_INDEX], idx2[MAX_INDEX], idx3[MAX_INDEX];
  Buffer *x, *y, *xx, *yy, *newidx, *max;
  
  read_syscom();
  if (( x = GetSeries(0,&dim,idx) ) == NULL )
    exit(4);

  if (( newidx = GetSeries(1, &dim2, idx2) ) == NULL ) {
    dim2 = 1;
    idx2[0] = 1;
    newidx = AllocBuffer( 1 );
    newidx[0]  = GetScalar(1);
  }

  {
    register int i;
    for ( i = 0; i < idx2[0]; i++ )
      idx3[i] = (int)newidx[i];
    len1 = IndexSize( dim , idx  );
    len2 = IndexSize( idx2[0], idx3 );

    if ( len2 == 0 ) 
      exit(7);

    if ( len1 < len2 ) {
      if ( ( y = AllocBuffer( len2 ) ) == NULL )
	exit(8);

      max = x +len1;
      for ( xx = x, yy = y; xx < max; xx++, yy++ )
	(*yy) = (*xx);
      max = y +len2;
      for ( yy = y+len1; yy < max; yy++ )
	(*yy) = 0.0;

      ReturnSeries( y, idx2[0], idx3 );
      FreeBuffer(y);
    } else 
      ReturnSeries( x, idx2[0], idx3);

    FreeBuffer(x);
    FreeBuffer( newidx );
  }
  return 0;
}
