/*******************************
* Visual Process Command Lib.  *
*       ( n-D Version )        *
*        Presented By K.Takebe *
********************************
********************************
*  Prog. Name : rotate         *
*    ( Ver 1.0 : 1993/03/17 )  *
*    ( Ver 1.1 : 1993/04/14 )  *
*    ( Ver 2.0 : 1993/08/25 )  *
*******************************/

#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

int
main()
{
  Buffer *x, *y, *z, *xx, *zz, *m1, *m2, *max;
  int    idx[MAX_INDEX],idx2[MAX_INDEX], idx3[MAX_INDEX];
  int    dpt1, dim, dim2, dim_const;
  int    diff, pos[MAX_INDEX];
  int    i, l, m, max_size;

  read_syscom();
  if (( x = GetSeries( 0, &dim, idx ) ) == NULL )
    exit(4);
  if (( y = GetSeries( 1, &dim2, idx2 ) ) == NULL ) {
    y = AllocBuffer(1);
    y[0] = GetScalar(1);
    idx2[0] = 1;
  }
  if ( dim != idx2[0] )
    exit(24);

  for ( i = 0; i < dim; i++ ) {
    if ( abs( idx3[i] = (int)y[i] ) >= idx[i] )
      exit(7);
    if ( idx3[i] < 0 )
      idx3[i] += idx[i];
  }

  dim_const = dim-1;
  l = idx [dim_const];
  m = idx3[dim_const];
  diff = l - m;

  max_size = IndexSize( dim, idx );
  if (( z = AllocBuffer( max_size ) ) == NULL )
    exit(8);
  
  if ( dim == 1 ) {
    m1 = x + m;
    m2 = x + l;
    for ( zz = z, xx = m1; xx < m2; xx++, zz++ )
      (*zz) = (*xx);
    for ( zz = z+diff, xx = x; xx < m1; xx++, zz++ )
      (*zz) = (*xx);
  } else {
    for ( i = 0; i < dim; i++ ) {
      pos[i] = idx3[i];
    }
    max = z+max_size;
    for ( zz = z; zz < max; ) {
      dpt1 = Index( pos, dim, idx );
      m1 = x + dpt1;
      m2 = x + dpt1+diff;
      for ( xx = x+dpt1; xx < m2; xx++, zz++ )
	(*zz) = (*xx);
      for ( xx = x+dpt1-m; xx < m1; xx++, zz++ )
	(*zz) = (*xx);

      if ( dim > 1 ) {
	i = dim_const-1;
	pos[i]++;
	pos[i] %= idx[i];
	for ( i = dim_const-1; i > 0 && pos[i] == idx3[i]; i-- ) {
	  pos[i-1]++;
	  pos[i-1] %= idx[i-1];
	}
      }
    }
  }
  ReturnSeries( z, dim, idx );
  FreeBuffer( z );
  FreeBuffer( x );
  FreeBuffer( y );
  return 0;
}
