/*******************************
* Visual Process Command Lib.  *
* ( Extra Dimension Version )  *
*        Presented By K.Takebe *
********************************
********************************
*  Prog. Name : zero           *
*    ( Ver 1.0 : 1993/04/14 )  *
*******************************/
#include <stdio.h>
#include <math.h>

#include "SL_macro.h"
#include "SL_cmd.h"

int
main()
{
  int idx [MAX_INDEX], idx2[MAX_INDEX], idx3[MAX_INDEX];
  int idx4[MAX_INDEX], idx5[MAX_INDEX];
  int pos[MAX_INDEX];
  int dim, dim2, dim3, m, i, dpt;
  Buffer  *x, *y, *z;

  read_syscom();
  if (( x = GetSeries( 0, &dim, idx ) ) == NULL )
    exit(4);
  if (( y = GetSeries( 1, &dim2, idx2 ) ) == NULL ) {
    y = AllocBuffer(1);
    y[0] = GetScalar(1);
    idx2[0] = 1;
  }
  if (( z = GetSeries( 2, &dim3, idx3 ) ) == NULL ) {
    z = AllocBuffer(1);
    z[0] = GetScalar(2);
    idx3[0] = 1;
  }

  if ( idx2[0] != dim || idx3[0] != idx2[0] )
    exit(16);

  for ( i = 0; i < dim; i++ ) {
    if ( (int)z[i] < (int)y[i] || idx[i] <= (int)z[i] )
      exit(7);
    idx4[i] = (int)y[i];
    idx5[i] = (int)z[i]-(int)y[i]+1;
  }

  if ( dim == 1 ) {
    m = idx4[0]+idx5[0];
    for ( i = idx4[0]; i < m; i++ )
      x[ i ] = 0.0;
  } else {
    for ( i = 0; i < dim; i++ )
      pos [i] = idx4[i];
    do {
      dpt = Index( pos, dim, idx );
      m = dpt + idx5[dim-1];
      for ( i = dpt; i < m; i++ )
	x[ i ] = 0.0;

      pos [dim-2]++;
      for ( i = dim-2; i > 0; i-- )
	if ( pos[i] > z[i] ) {
	  pos [i-1]++;
	  pos [i] = y[i];
	}
    } while ( pos[0] <= z[0] );
  }
  ReturnSeries( x, dim, idx );
  FreeBuffer( x );
  FreeBuffer( y );
  FreeBuffer( z );
  return 0;
}
