#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <SL_macro.h>
#include <SL_cmd.h>


char* ChkParam(format, fmt, type )
    char *format, *fmt;
    int *type;
{
  register int	i = 0;
  char	*p;
  p = format;

  while ( *p != '%' && *p != '\0' )
    fmt[i++] = *p++;
  if ( *p != '\0' ) {
    fmt[i++] = *p++;	/* % */
    if(*p == '-')
      fmt[i++] = *p++;
    while(isdigit(*p) || *p == '.')
      fmt[i++] = *p++;
    switch(*p){
    case 'l':
      fmt[i++] = *p++; /* break through*/
    case 'e':
    case 'f':
    case 'g':
    case 'd':
    case 's':
    case 'c':
    case 'x':
      *type = 0;
      if ( *p == 's' || *p == 'c' )
	*type = 1;
      else if ( *p == 'x' || *p == 'd' )
	*type = 2;
      fmt[i++] = *p++;
      break;
    default:
      fmt[i++] = *p++;
    }
    while ( *p != '%' && *p != '\0' )
      fmt[i++] = *p++;
    fmt[i] = '\0';
  }
  return p;
}

int main()
{
  int i, max_arg, dim, index[MAX_INDEX], type;
  int dat;
  char   *format, *p, fmt[128], *string, res[256], plate[1024];
  Buffer param, *temp;

  read_syscom();

  max_arg = syscom.narg;
  p = format = GetString(0);

  plate[0] = '\0';
  for ( i = 1; i < max_arg; i++ ) {
    p = ChkParam( p, fmt, &type );
    switch( type ) {
    case 0:
    case 2:
      if (( temp = GetSeries(i,&dim,index)) != NULL ) {
	param = temp[0];
      } else {
	param = GetScalar(i);
      }
      if ( type == 2 ) {
	dat = (int)param;
	sprintf( res, fmt, dat );
      } else {
	sprintf( res, fmt, param );
      }
      break;
    case 1:
      string = GetString(i);
      sprintf( res, fmt, string );
      break;
    }
    strcat( plate, res );
  }
  ReturnString( plate );
  return 0;
}

