#include "isop_all.h"
#define cutW 100

static Widget w_cut_sepa, w_cut_start_label, w_cut_end_label;
static Widget w_init_cut_button, w_cut_ok_button;
static Widget w_cut_grid_label, w_cut_grid, w_cut_g_unit;

static Widget Lbar     = NULL;
static Widget Rbar     = NULL;
static Widget movement = NULL;
static int Lbar_x = 0;
static int Rbar_x = 0;
static Dimension width_base;
static int cutDpt;

static int cut_grid = 1;


void cutdt_func( w , tag , callback_data )
     Widget  w;
     int    *tag;
     XmAnyCallbackStruct *callback_data;
{
  Arg arg[10];
  int n;

  if ( execMode == NOTHING ) {

    execMode      = CUTDT;

    normal_mode = G_TIME;
    g1_mode     = G_TIME;
    g1_x_scale  = G_LINER;
    g1_y_scale  = G_LINER;
    g1_opt      = G_NORM;

    g2_mode     = G_TIME;
    g2_x_scale  = G_LINER;
    g2_y_scale  = G_LINER;
    g2_opt      = G_NORM;

    option_set( NULL , NULL , NULL );
    writeLabel( g1_canvas, 0.0 , 0.0 , 0.0 , 0.0 );
    writeLabel( g2_canvas, 0.0 , 0.0 , 0.0 , 0.0 );

    modified_flag = 0;
    made_data     = 0;

    show_buff1  = NULL;
    show_buff2  = NULL;

    setLabel( widget_array[ com_name ] , "CUT OUT DATA" );

    if ( Lbar == NULL ) {
      Lbar = XmCreateForm(widget_array[g1_canvas], "left_bar",NULL,0);
      XtManageChild(Lbar);
    }
    if ( Rbar == NULL ) {
      Rbar = XmCreateForm(widget_array[g1_canvas], "right_bar",NULL,0);
      XtManageChild(Rbar);
    }

    n = 0;
    XtSetArg( arg[n] , XmNwidth , &width_base );n++;
    XtGetValues( widget_array[ g1_canvas ] , arg , n );

    /* CutDataForm */
    widget_array[cutdt] = XmCreateForm(isopmain,
				       "cutdt_base_form", NULL, 0);
    widget_array[writ_button] =
      XmCreatePushButton(widget_array[cutdt],"cut_write_button",NULL,0);
    widget_array[exit_button] =
      XmCreatePushButton(widget_array[cutdt],"cut_exit_button",NULL,0);
    w_cut_sepa       =XmCreateSeparator(widget_array[cutdt],"cut_sepa",NULL,0);
    
    XtManageChild(widget_array[writ_button]);
    XtManageChild(widget_array[exit_button]);
    XtManageChild(w_cut_sepa);
    
    widget_array[cut_start] = XmCreateTextField(widget_array[cutdt],
						"cut_start",NULL,0);
    widget_array[cut_end] = XmCreateTextField(widget_array[cutdt],
					      "cut_end",NULL,0);
    widget_array[cut_st_u]=XmCreateLabel(widget_array[cutdt],
					 "cut_s_unit",NULL,0);
    widget_array[cut_ed_u]=XmCreateLabel(widget_array[cutdt],
					 "cut_e_unit",NULL,0);
    w_cut_start_label=XmCreateLabel(widget_array[cutdt],
				    "cut_start_label",NULL,0);
    w_cut_end_label=XmCreateLabel(widget_array[cutdt],
				  "cut_end_label", NULL, 0);
    w_cut_grid = XmCreateTextField(widget_array[cutdt], "cut_grid",NULL,0);
    w_cut_g_unit = XmCreateLabel(widget_array[cutdt],
					 "cut_g_unit",NULL,0);
    w_cut_grid_label = XmCreateLabel(widget_array[cutdt],
				     "cut_grid_label",NULL,0);

    w_cut_ok_button=XmCreatePushButton(widget_array[cutdt],
				       "cut_ok_button", NULL, 0);
    w_init_cut_button=XmCreatePushButton(widget_array[cutdt],
					 "init_cut_button", NULL, 0);

    XtManageChild(widget_array[cut_start]);
    XtManageChild(widget_array[cut_end]);
    XtManageChild(widget_array[cut_st_u]);
    XtManageChild(widget_array[cut_ed_u]);
    XtManageChild(w_cut_start_label);
    XtManageChild(w_cut_end_label);
    XtManageChild(w_cut_grid_label);
    XtManageChild(w_cut_grid);
    XtManageChild(w_cut_g_unit);
    XtManageChild(w_cut_ok_button);
    XtManageChild(w_init_cut_button);
    XtManageChild(widget_array[cutdt]);

    XtAddCallback( widget_array[exit_button], XmNactivateCallback ,
		  (XtCallbackProc)exit_cutdt, NULL );
    XtAddCallback( widget_array[writ_button], XmNactivateCallback ,
		  (XtCallbackProc)writeCutData, NULL );

    XtAddCallback( widget_array[inpu_num], XmNvalueChangedCallback ,
		  (XtCallbackProc)in_cut_data, NULL );
    XtAddCallback( widget_array[g1_canvas], XmNresizeCallback ,
		  (XtCallbackProc)resize_bar, NULL );
    XtAddCallback( widget_array[cut_start], XmNactivateCallback ,
		  (XtCallbackProc)cut_set, NULL);
    XtAddCallback( widget_array[cut_end], XmNactivateCallback ,
		  (XtCallbackProc)cut_set, NULL);

    XtAddCallback( w_cut_grid, XmNactivateCallback,
		  (XtCallbackProc)grid_set, NULL);

    XtAddCallback( w_init_cut_button, XmNactivateCallback ,
		  (XtCallbackProc)cut_init, NULL);
    XtAddCallback( w_cut_ok_button, XmNactivateCallback ,
		  (XtCallbackProc)cut_out, NULL);

    XtAddCallback( widget_array[opt_set], XmNactivateCallback ,
		  (XtCallbackProc)cutRewriteValueAll , NULL );

    XtAddEventHandler( widget_array[g1_canvas] , Button1MotionMask,
		      FALSE, (XtEventHandler)cut_point_move , NULL );
    XtAddEventHandler( widget_array[g1_canvas] , ButtonPressMask,
		      FALSE, (XtEventHandler)cut_point_set , NULL );
    XtAddEventHandler( widget_array[g1_canvas] , ButtonPressMask,
		      FALSE, (XtEventHandler)cut_point_other , NULL );

    grid_set(NULL,NULL,NULL);
    cut_init();
  }
}


void exit_cutdt( w , tag , callback_data )
     Widget  w;
     int    *tag;
     XmAnyCallbackStruct *callback_data;
{
  if ( made_data == 1 ) {
    if ( widget_array[exit_dlg] == NULL ) {
      Widget helpbutton;
      widget_array[exit_dlg] = XmCreateWarningDialog(isopmain,"exit_dlg",
						     NULL,0);
      helpbutton = XmMessageBoxGetChild(widget_array[exit_dlg],
					XmDIALOG_HELP_BUTTON);
      XtUnmanageChild(helpbutton);
      XtManageChild(widget_array[exit_dlg]);
      
      if ( widget_array[exit_dlg] != NULL ) {
	XtAddCallback( widget_array[exit_dlg] , XmNokCallback ,
		      (XtCallbackProc)writeCutData , NULL );
	XtAddCallback( widget_array[exit_dlg] , XmNcancelCallback ,
		      (XtCallbackProc)exitCutdtOK , NULL );
      }
    } else
      XtManageChild( widget_array[exit_dlg]);
  } else
    exitCutdtOK( NULL , NULL , NULL );
}

void exitCutdtOK( w , tag , callback_data )
     Widget  w;
     int    *tag;
     XmAnyCallbackStruct *callback_data;
{
  quit_all(NULL,NULL,NULL);
}

void writeCutData( w , tag , callback_data )
     Widget  w;
     int    *tag;
     XmAnyCallbackStruct *callback_data;
{
  int    index2[5];
  int    dim2;

  if ( strlen(output_file_name) < 1 ) {
    fprintf(stderr, "Output file name is not specified.\n");
  } else {
    dim2 = get_index( output_file_name , index2 );
    if ( dim2 >= 1 && index2[0] != 0 ) {
      
      if ( widget_array[write_dlg] == NULL ) {
	Widget helpbutton;
	widget_array[write_dlg] =
	  XmCreateWarningDialog(isopmain, "write_dlg", NULL, 0);
	helpbutton = XmMessageBoxGetChild(widget_array[write_dlg],
					  XmDIALOG_HELP_BUTTON);
	XtUnmanageChild(helpbutton);
	XtManageChild(widget_array[write_dlg]);
	
	if ( widget_array[write_dlg] != NULL )
	  XtAddCallback( widget_array[write_dlg] , XmNokCallback ,
			(XtCallbackProc)writeCutdtOK , NULL );
      } else
	XtManageChild(widget_array[write_dlg]);
    } else
      writeCutdtOK( NULL , NULL , NULL );
  }
}

void writeCutdtOK( w , tag1, tag2 )
     Widget w;
     caddr_t  tag1, tag2;
{
  int dpt = 0, i;

  if ( show_buff2 != NULL && buff_len2 > 0 ) {
    WriteDataFile( output_file_name, obuf_num, buff_len2,
		  show_buff2, obuf_format, obuf_type, obuf_byte );

    if ( !strcmp(input_file_name, output_file_name) && ibuf_num == obuf_num ) {
      free(show_buff1);
      if ((show_buff1 = AllocBuffer(buff_len2)) ==  NULL) {
	buff_len1 = dpt = 0;
	fprintf(stderr,"cannot allocate memory!\n");
      } else {
	for ( i = 0; i < buff_len2; i++ )
	  show_buff1[i] = show_buff2[i];
	dpt = buff_len1 = buff_len2;
      }
    }
  }
  if ( dpt > 0 ) {
    cutDpt = buff_len1 = dpt;
    drawGraph( g1_canvas , show_buff1, buff_len1 ); 
  }

  made_data = 0;
}

void in_cut_data( w , tag , callback_data )
     Widget w;
     caddr_t tag, callback_data;
{
  int dim, dpt, index[5];
  char gname1[ONE_LINE];
  char *sp;
  
  if ( input_file_name != NULL && ibuf_num >= 0 ) {
    dim = get_index( input_file_name , index );
    if ( dim > 0 ) {
      dpt = index[1];
      ibuf_num_max = (index[0] > 0 ) ? index[0]-1: 0;
    } else {
      dpt = 0;
      ibuf_num_max = 0;
    }
    if ( dim == 2 && dpt > 0 ) {
      if ( show_buff1 != NULL )
	free(show_buff1);

      if ((show_buff1 = ReadDataFile(input_file_name, ibuf_num, &dpt))==NULL) {
	fprintf(stderr,"cannot allocate memory!\n");
	dpt = 0;
      }
      buff_len1 = dpt;

      if ( cut_grid > dpt ) {
	cut_grid = 1;
	setValue(w_cut_grid, "1");
      }

      if ( show_buff1 != NULL && dpt > 0 )
	syscom.buff_leng = dpt;
      set_dpt( dpt );
      cutDpt = dpt;

      for ( sp = input_file_name+strlen(input_file_name);
	   sp > input_file_name; sp-- )
	if ( *(sp-1) == '/' )
	  break;

      sprintf( gname1, "Input Data (%s, record: %d)",
	      sp, ibuf_num );
      setLabel( widget_array[g1_title], gname1 );

      if ( dpt > 1 && show_buff1 != NULL )
	drawGraph( g1_canvas , show_buff1, buff_len1 );
      else
	myerase(g1_canvas);

    } else {
      setLabel( widget_array[g1_title]  , "Input Data" );
      myerase( g1_canvas );
    }
  } 
}

void cut_init()
{
  int dpt;
  Arg arg[4];
  int n;
  char *sp;
  char gname1[ONE_LINE],gname2[ONE_LINE];
  Dimension height;
  
  sprintf( gname2, "Output Data");
  setLabel( widget_array[g2_title]  , gname2 );
  
  
  if ( show_buff1 != NULL ) {
    dpt = buff_len1;
    if ( dpt > 0 ) {
      for ( sp = input_file_name+strlen(input_file_name);
	   sp > input_file_name; sp-- )
	if ( *(sp-1) == '/' )
	  break;
      sprintf( gname1, "Input Data (%s, record: %d)",
	      sp, ibuf_num );
      setLabel( widget_array[g1_title]  , gname1 );
      set_dpt( dpt );
      cutDpt = dpt;
      drawGraph( g1_canvas , show_buff1, dpt );
    } else {
      if ( input_file_name != NULL && ibuf_num >= 0 )
	in_cut_data(NULL,NULL,NULL);
      else {
	sprintf( gname1, "Input Data");
	setLabel( widget_array[g1_title]  , gname1 );
      }
    }
  }
  
  if ( show_buff2 != NULL ) {
    dpt = buff_len2;
    if ( dpt > 0 && made_data != 0 )
      drawGraph( g2_canvas , show_buff2, dpt );
  }
  
  cutRewriteValue( Lbar );
  cutRewriteValue( Rbar );
  
  n = 0;
  XtSetArg( arg[n] , XmNheight , &height );n++;
  XtGetValues( widget_array[ g1_canvas ] , arg , n );
  
  n = 0;
  XtSetArg( arg[n] , XmNx , Lbar_x );n++;
  XtSetArg( arg[n] , XmNheight , height -1 );n++;
  XtSetValues( Lbar , arg , n );
  
  n = 0;
  XtSetArg( arg[n] , XmNx , Rbar_x );n++;
  XtSetArg( arg[n] , XmNheight , height - 1 );n++;
  XtSetValues( Rbar , arg , n );
  
  XtUnmapWidget(Lbar);
  XtUnmapWidget(Rbar);
  
  modified_flag = 0;
}

void resize_bar()
{
  Arg arg[5];
  int n;
  Dimension height, width;
  double width_ratio;
  
  n = 0;
  XtSetArg( arg[n] , XmNwidth , &width );n++;
  XtSetArg( arg[n] , XmNheight , &height );n++;
  XtGetValues( widget_array[ g1_canvas ] , arg , n );
  
  width_ratio = (double)(width+1) / (double)(width_base+1);
  width_base = width;
  
  Lbar_x = (int)( width_ratio * (double)Lbar_x );
  Rbar_x = (int)( width_ratio * (double)Rbar_x );

  n = 0;
  XtSetArg( arg[n] , XmNheight , height - 1 );n++;
  XtSetArg( arg[n] , XmNx , Lbar_x );n++;
  XtSetValues( Lbar , arg , n );
  
  n = 0;
  XtSetArg( arg[n] , XmNheight , height - 1 );n++;
  XtSetArg( arg[n] , XmNx , Rbar_x );n++;
  XtSetValues( Rbar , arg , n );
  
}

void cut_set( w , tag , callback_data )
     Widget w;
     int    *tag;
     caddr_t callback_data;
{
  char *startC,*endC;
  float start, end;
  
  startC = getValue( widget_array[cut_start] );
  endC   = getValue( widget_array[cut_end]   );
  
  sscanf( startC, "%f" , &start );
  sscanf( endC ,  "%f" , &end );
  
  free(startC);
  free(endC);
  
  
  if ( modified_flag == 0 ) {
    XtMapWidget( Lbar );
    modified_flag = 1;
  } else {
    XtMapWidget( Rbar );
    modified_flag = 2;
  }
  cutValueToPosition( (double)start , (double)end );
}

void cut_point_set( w , client_data , event )
     Widget w;
     XtPointer client_data;
     XEvent *event;
{
  Widget bar;
  Arg arg[3];
  int n;
  int x, distL, distR, dist = 0;
  
  if ( event->xbutton.button == 1 ) {
    
    x = event->xbutton.x;

    if ( modified_flag < 2 ){
      if ( modified_flag == 0 ) {
	Lbar_x = x;
	movement = Lbar;
      } else {
	Rbar_x = x;
	movement = Rbar;
      }
      XtMapWidget( movement );
      cutRewriteValue( movement );
      n = 0;
      XtSetArg( arg[n] , XmNx , x );n++;
      XtSetValues( movement , arg , n );
      
      modified_flag++;
    } else {
      distL = abs( x - Lbar_x );
      distR = abs( x - Rbar_x );
      if ( distL < distR ) {
	bar = Lbar;
	dist = distL;
      } else {
	bar = Rbar;
	dist = distR;
      }
      movement = ( dist < 10 ) ? bar : NULL;
    }
  }
}

void cut_point_move( w , client_data , event )
     Widget w;
     XtPointer client_data;
     XEvent *event;
{
  Arg arg[3];
  int n;
  int x;
  int tmp_x;
  
  if ( movement != NULL &&  event->xmotion.state == 0x100 ) {
    
    x = event->xmotion.x; 

    if ( x >= 0 && x < width_base )
      tmp_x = x;
    else
      tmp_x = ( x < 0 ) ? 0 : width_base -1;

    if ( movement == Lbar ) Lbar_x = tmp_x;
    else                    Rbar_x = tmp_x;
    
    n = 0;
    XtSetArg( arg[n] , XmNx , (Dimension)tmp_x );n++;
    XtSetValues( movement , arg , n );
    
    cutRewriteValue( movement );
  }
}

void cut_point_other( w , client_data , event )
     Widget w;
     XtPointer client_data;
     XEvent *event;
{
  if ( event->xbutton.button == 3 ) {
    switch ( modified_flag ){
    case 2:
      XtUnmapWidget( Rbar );
      modified_flag--;
      Rbar_x = 0;
      cutRewriteValue( Rbar );
      break;
    case 1:
      XtUnmapWidget( Lbar );
      modified_flag--;
      Lbar_x = 0;
      cutRewriteValue( Lbar );
      break;
    }
  } else if ( event->xbutton.button == 2 )
    cut_out();
}

void cut_out()
{
  int startP, endP , tmp;
  int i, j, dpt = 0;
  
  if ( show_buff1 != NULL )
    dpt = buff_len1;

  if ( dpt > 0 ) {
    startP = ((int)((double)Lbar_x*(double)dpt/(double)width_base + 0.5)
	      /cut_grid)*cut_grid;
    endP   = ((int)((double)Rbar_x*(double)dpt/(double)width_base + 0.5)
	      /cut_grid)*cut_grid;

    if ( startP > endP ) {
      tmp = endP;
      endP = startP;
      startP = tmp;
    }

    syscom.buff_leng = dpt = endP - startP +1;

    if ( show_buff2 != NULL )
      free(show_buff2);

    if ((show_buff2 = AllocBuffer(dpt)) == NULL ) {
      fprintf(stderr, "cannot allocate memory!\n");
      dpt = buff_len2 = 0;
    }

    if ( dpt > 0 ) {
      for ( i = startP, j = 0; i <= endP ; i++, j++ )
	show_buff2[j] = show_buff1[i];
    
      buff_len2 = dpt;
      drawGraph( g2_canvas , show_buff2, dpt );

      set_dpt(dpt);
      cutRewriteValue(Lbar);
      cutRewriteValue(Rbar);
    
      syscom.buff_leng = data_points;
      made_data = 1;
    }
  }
}

void cutRewriteValue( w )
     Widget w;
{
  int unitW,valueW;
  int datP , x ;
  double datT;
  char unit[20];
  char datC[20];
  
  if ( w == Lbar ) {
    valueW = cut_start;
    unitW  = cut_st_u;
    x = Lbar_x;
  } else {
    valueW = cut_end;
    unitW  = cut_ed_u;
    x = Rbar_x;
  }
  
  if ( g1_opt == G_NORM ) {
    
    if ( g1_x_scale == G_LINER ) {
      
      datP = ((int)((double)x*(double)(cutDpt-1)/(double)(width_base-1.0))
	      /cut_grid)*cut_grid;
      
      switch ( g1_mode ) {
      case G_TIME:
	datT = ((double)datP)/ (double)syscom.sam_freq;
	sprintf( unit ,"sec" );
	sprintf( datC , "%.3f" , datT );
	break;
      case G_DATA:
	sprintf( unit ,"pt." );
	sprintf( datC , "%d" , datP+1 );
	break;
      }
      
      setValue( widget_array[ valueW ] , datC );
      setLabel( widget_array[ unitW  ] , unit   );
    }
  }
}

void cutRewriteValueAll( w )
     Widget w;
{
  cutRewriteValue( Lbar );
  cutRewriteValue( Rbar );
  
}


void cutValueToPosition( start , end )
     double start, end;
{
  int startP = 0, endP = 0;
  Arg arg[3];
  int n;
  
  if ( g1_opt == G_NORM ) {
    
    if ( g1_x_scale == G_LINER ) {
      
      switch ( g1_mode ) {
      case G_TIME:
	startP = (int)( start * (double)syscom.sam_freq );
	endP   = (int)( end   * (double)syscom.sam_freq );
	break;
      case G_DATA:
	startP = (int)start;
	endP   = (int)end;
	break;
      }
      Lbar_x = startP * width_base / cutDpt;
      Rbar_x = endP   * width_base / cutDpt;

      n = 0;
      XtSetArg( arg[n] , XmNx , Lbar_x );n++;
      XtSetValues( Lbar , arg , n );
      
      n = 0;
      XtSetArg( arg[n] , XmNx , Rbar_x );n++;
      XtSetValues( Rbar , arg , n );
      
    }
  }
}

void grid_set(w, tag, callback_data)
     Widget  w;
     int    *tag;
     caddr_t callback_data;
{
  char *gridC;
  int   grid;
  
  gridC  = getValue( w_cut_grid );
  
  sscanf( gridC, "%d" , &grid );
  
  free(gridC);
  if ( grid > 0 )
    cut_grid = grid;

  
  cutRewriteValueAll(NULL);
}     

void cut_outbuf_disp()
{
  int dpt = buff_len2;
  
  if ( show_buff2 != NULL ) {
    if ( dpt > 0 && made_data != 0 )
      drawGraph( g2_canvas , show_buff2, buff_len2 );
  }
}
