#include <stdio.h>
#include "config.h"
#include "SL_macro.h"
#include "SL_cmd.h"
#ifdef HAVE_UNISTD_H
#include "unistd.h"
#endif
#ifdef HAVE_STDLIB_H
#include "stdlib.h"
#endif
#ifdef HAVE_MALLOC_H
#include "malloc.h"
#endif

/*************  CPU type  **************
 BigEndian    - 680x0 or SPARC (EWS)
 LittleEndian - Intel 80x86 or DEC Alpha
****************************************/
#define OLD_FORMAT	0
#define NEW_FORMAT	1

static int     FileFormat = NEW_FORMAT;
static int     DataType   = BigEndian;
static int     aDataSize  = 4;


void write_type(format, type, byte)
    char           *format, *type;
    int		byte;
{
  if (equal(format, "new"))
    FileFormat = NEW_FORMAT;
  else if (equal(format, "old"))
    FileFormat = OLD_FORMAT;
  
  if(equal(format, "new") || equal(format, "old")) {
    if (equal(type, "BigEndian") || equal(type, "ws"))
      DataType = ChangeDataType(BigEndian);
    else if (equal(type, "LittleEndian") || equal(type, "pc"))
      DataType = ChangeDataType(LittleEndian);
    else
      fprintf(stderr,"write_type() : illegal byte-order type \n");
    if(byte == 2 || byte == 4 || byte == 8)
      aDataSize = ChangeDataSize(byte);
    else
      fprintf(stderr,"write_type() : illegal size of 'a data'\n");
  }
}


static char *read_old_file(fname, numb, length)
    char           *fname;	/* data file name  */
    int             numb;	/* number of block */
    int            *length;	/* data point      */
{
  int             dpt, size, before;
  h_type          head;	/* old header type */
  float          *fdata;
  
  load_header(fname, &head);
  *length = head.data_num;
  
  size = head.rec_leng * REC_SIZE;
  fdata = (float *) emalloc(size);
  
  before = syscom.buff_leng;
  syscom.buff_leng = size;
  
  dpt = load_data(fdata, fname, numb+1);

  if (dpt == -1)
    fprintf(stderr,"read_old_file() : data file read error : %s\n", fname);
  if (dpt == -2)
    fprintf(stderr,"read_old_file() : data point too large : %s\n", fname);
  
  syscom.buff_leng = before;
  
  return (char *) fdata;
}

static char   *read_old_file2(fname, dim, length)
    char   *fname;	/* data file name  */
    int    *dim;
    int    *length;	/* data point      */
{
  int    numb, max;
  int    dpt, size, before;
  h_type head;	/* old header type */
  float  *fdata, *tmp;
  
  load_header(fname, &head);

  max = *dim = head.rec_num;
  size = head.data_num;

  if ( max == 1 ) {
    *length = head.data_num;
    *dim = 1;
  } else {
    *length = head.rec_num;
    *(length+1) = head.data_num;
    *dim = 2;
  }

  fdata = (float *) emalloc( head.rec_leng * max * REC_SIZE );
  
  before = syscom.buff_leng;
  syscom.buff_leng = head.data_num;

  for ( numb = 0, tmp = fdata; numb < max; numb++, tmp += size ) {
    dpt = load_data( tmp, fname, numb+1);

    if (dpt == -1)
      fprintf(stderr,"read_old_file2() : data file read error : %s\n", fname);
    if (dpt == -2)
      fprintf(stderr,"read_old_file2() : data point too large : %s\n", fname);
  }    
  syscom.buff_leng = before;
  
  return (char *) fdata;
}

int
write_old_file(buf, fname, numb, length)
    Buffer         *buf;	/* write data        */
    char           *fname;	/* data file name    */
    int             numb;	/* number of blocks  */
    int             length;	/* data points       */
{
  register int    i;
  int             dpt, siz;
  float          *fdata;

  if (access(fname, 0) != 0) {
    m_file(fname);
    stor_init(fname, 1 ); /* type = 1 : MS-DOS format */
  }

  siz = (length % 64 == 0) ? length : (length / 64 + 1) * 64;
  fdata = (float *) calloc(siz, sizeof(float));
  for (i = 0; i < length; i++)
    fdata[i] = (float) buf[i];
  dpt = stor_data(fdata, length, fname, numb+1);
  if ( fdata != NULL )
    free(fdata);

  if (dpt == -1)
    fprintf(stderr,"write_old_file() : data file write error : %s\n", fname);
  if (dpt == -2)
    fprintf(stderr,"write_old_file() : data size mismatch : %s\n", fname);

  return 0;
}

int
write_old_file2( buf, fname, numb, length )
    Buffer         *buf;	/* write data        */
    char           *fname;	/* data file name    */
    int             numb;	/* number of blocks  */
    int             length;	/* data points       */
{
  int i;
  Buffer *tmp;

  for ( i = 0, tmp = buf; i < numb ; i++, tmp+=length )
    write_old_file( tmp, fname, i, length );
  return 0;
}

static char   *inv_cast(buf, elsize, length)
    Buffer         *buf;	/* charactor type bufffer */
    int             elsize;	/* size of a data element [byte] */
    int             length;	/* total number of data   */
{
  register int    i;
  char           *data = NULL;
  
  if ( buf != NULL ) {
    switch (elsize) {
    case 2 /* [byte] */ :
      data = (char *) emalloc(length * sizeof(short));
      for (i = 0; i < length; i++)
	((short *) data)[i] = (short) buf[i];
      break;
    case 4 /* [byte] */ :
      data = (char *) emalloc(length * sizeof(float));
      for (i = 0; i < length; i++)
	((float *) data)[i] = (float) buf[i];
      break;
    case 8 /* [byte] */ :
      data = (char *) emalloc(length * sizeof(double));
      for (i = 0; i < length; i++)
	((double *) data)[i] = (double) buf[i];
      break;
    default:
      fprintf(stderr,"inv_cast() : unknown data size\n");
      break;
    }
  }
  return (char *) data;
}

static Buffer *casting(buf, elsize, length)
    char           *buf;	/* charactor type bufffer */
    int             elsize;	/* size of a data element [byte] */
    int             length;	/* total number of data   */
{
  register int    i;
  short          *short_data;
  float          *float_data;
  double         *double_data;
  Buffer         *data = NULL;
  
  if ( buf != NULL ) {
    switch (elsize) {
    case 2 /* [byte] */ :
      short_data = (short *) buf;
      data = (Buffer *) AllocBuffer(length);
      for (i = 0; i < length; i++)
	data[i] = (Buffer) short_data[i];
      break;
    case 4 /* [byte] */ :
      float_data = (float *) buf;
      data = (Buffer *) AllocBuffer(length);
      for (i = 0; i < length; i++)
	data[i] = (Buffer) float_data[i];
      break;
    case 8 /* [byte] */ :
      double_data = (double *) buf;
      data = (Buffer *) AllocBuffer(length);
      for (i = 0; i < length; i++)
	data[i] = (Buffer) double_data[i];
      break;
    default:
      fprintf(stderr,"casting() : unknown data size\n");
      break;
    }
  }
  return data;
}


Buffer *loading_data(fname, numb, head, exist_index)
    char           *fname;	/* data file name      */
    int             numb;	/* number of blocks    */
    Header         *head;
    int             exist_index;	/* exist flag of index */
{
  char           *buf = NULL;
  Buffer         *data;
  int             length, old_dim;
  
  if (access(fname, 0) != 0) {
    fprintf(stderr,"loading_data() : not exist file %s\n", fname);
    return NULL;
  }
  
  if (LoadHeader(fname, head) == -1) {
    fprintf(stderr,"loading_data() : failed to read header %s\n", fname);
    return NULL;
  }
  
  switch (head->type_flag) {
  case 0:
  case 1:
    if (!exist_index) {
      buf = (char *) read_old_file2(fname, &old_dim, head->index);
      head->dim = old_dim;
    } else {
      buf = (char *) read_old_file(fname, numb, head->index);
      head->dim = 1;
    }
    head->data_size = sizeof(float);
    break;
    
  case BigEndian:
  case LittleEndian:
    if (exist_index) {
      LoadHeader(fname, head);
      if ( head->dim == 1 || (head->dim == 2 && head->index[1] == 1 ) ) {
	buf = (char *) ReadFile(fname, head);
	head->dim = 2;
	head->index[1] = head->index[0];
	head->index[0] = 1;
      } else
	buf = (char *) LoadData(fname, numb, head);

      if (buf == NULL)
	fprintf(stderr,"loading_data() : failed to evaluate %s\n", fname);
      --head->dim;
      CopyIndex(head->index,SubIndex(head->index),head->dim);
    } else {
      buf = (char *) ReadFile(fname, head);
      if (buf == NULL)
	fprintf(stderr,"loading_data() : failed to evaluate %s\n", fname);
    }
    break;
  default:
    fprintf(stderr,"loading_data() : unknown file %s\n", fname);
  }
  length = IndexSize(head->dim, head->index);
  data = (Buffer *) casting(buf, head->data_size, length);
  if ( buf != NULL )
    free(buf);
  return data;
}

int saving_data(fname, numb, dim, index, buf, exist_index)
    char           *fname;	/* data file name      */
    int             numb;	/* number of blocks    */
    int             dim;	/* dimension of data   */
    int            *index;	/* index-size of data  */
    Buffer         *buf;	/* saving data         */
    int             exist_index;	/* exist flag of index */
{
  int             length, status;
  char           *data;

  switch (FileFormat) {
  case NEW_FORMAT:
    data = inv_cast(buf, aDataSize, IndexSize(dim, index));
    if (exist_index)
      status = StoreData(fname, numb, dim, index, data);
    else
      status = WriteFile(fname, dim, index, data);
    efree(data);
    break;
  case OLD_FORMAT:
    if ( exist_index ) {
      length = IndexSize(dim, index);
      write_old_file(buf, fname, numb, length);
    } else {
      if ( dim > 1 ) {
	numb = index[0];
	length = IndexSize( dim-1, index+1 );
	write_old_file2(buf, fname, numb, length);
      } else {
	numb = 0;
	length = index[0];
	write_old_file(buf, fname, 0, length);
      }
    }
    break;
  }
  return 0;
}

int get_index( fname, index )
    char *fname;
    int  *index;
{
  int dim, i;
  Header head;
  h_type old_head;
  
  if (access(fname, 0) != 0)
    return -1;
  
  if (LoadHeader(fname, &head) == -1)
    return -2;
  
  switch (head.type_flag) {
  case 0:
  case 1:
    load_header(fname, &old_head);
    dim   = 2;
    index[0] = old_head.rec_num;
    index[1] = old_head.rec_leng;
    break;
  case BigEndian:
  case LittleEndian:
    dim   = head.dim;
    for ( i = 0; i < dim; i++ )
      index[i] = head.index[i];

    if (dim == 2 && index[1] == 1 ) {
      dim = 2;
      index[1] = index[0];
      index[0] = 1;
    }
    break;
  default:
    return 0;
  }
  return dim;
}  


Buffer *ReadDataFile( fname, num, leng )
    char *fname;
    int  num;
    int  *leng;
{
  Header head;
  Buffer *data;

  data = loading_data(fname, num, &head, 1);

  if ( data != NULL && head.dim == 1 ) {
    *leng = head.index[0];

    return data;
  }
  return NULL;
}

int WriteDataFile( fname, num, leng, data, format, type, byte )
    char   *fname;
    int     num, leng;
    Buffer *data;
    char   *format, *type;
    int     byte;
{

  /*
    , ǡĹΥå򤷤, ǡĹä, û, 
    եĹä, ǡղä
    */

  write_type(format, type, byte);
  saving_data( fname, num, 1, &leng, data, 1 );

  return 0;
}

