#include "isop_all.h"
#include <X11/cursorfont.h>

#define MaxWidth 32768
static void power _ANSI_ARGS_((Buffer x[], Buffer y[], int l));
static void mygraph _ANSI_ARGS_((Widget w, Buffer *data, int dataNumber,
				 int cutFrom, int cutTo,
				 char *color1, char *color2,
				 Buffer *max, Buffer *min,
				 Buffer *left, Buffer *right));
static void
mygraph(w, data, dataNumber, cutFrom, cutTo, color1, color2 ,
	max , min , left , right )
    Widget w;
    Buffer  *data;
    int    dataNumber;
    int    cutFrom;
    int    cutTo;
    char   *color1;
    char   *color2;
    Buffer  *min;
    Buffer  *max;
    Buffer  *left;
    Buffer  *right;
{
    Arg		args[10];
    Cardinal	n;
    Dimension	width, height;

    XColor	exact, col1, col2;
    XSetWindowAttributes atr;

    Display    *display	 = XtDisplay(w);
    Window	window   = XtWindow(w);
    int		screen   = DefaultScreen(display);
    Colormap	colormap = DefaultColormap( display, screen );
    GC		gc	 = XCreateGC( display, window, 0, NULL);
    static char dash[]   = { 3,3 };
    static char dash2[]  = { 1,4 };
    static char dash3[]  = { 1,3 };

    Cursor	curs1	 = XCreateFontCursor(display, XC_crosshair);
    Cursor	curs2	 = XCreateFontCursor(display, XC_left_ptr);

    int         scale_x, scale_y, mode, option;

    int		i, j, x, y, bx, by, leftX = 0;
    Buffer	deltaX = 1.0, deltaX2,stepX;
    Buffer	deltaY,stepY,maxScaleOrigin, coef = 10.0, tmpy;

    Buffer	left1 = 0.0, right1 = 0.0;
    Buffer	originY;


    atr.backing_store = Always;
    XChangeWindowAttributes(display, window, CWBackingStore, &atr);

    n = 0;
    XtSetArg(args[n], XmNwidth,  &width );	n ++;
    XtSetArg(args[n], XmNheight, &height);	n ++;
    XtGetValues(w, args, n);

    if ( XAllocNamedColor(display, colormap, color1, &exact, &col1) == 0 )
	col1.pixel = WhitePixel( display, screen );

    if ( XAllocNamedColor(display, colormap, color2, &exact, &col2) == 0 )
	col2.pixel = WhitePixel( display, screen );

    if ( w == widget_array[g1_canvas] ){
	XDefineCursor(display, window, curs1);
	scale_x = g1_x_scale;
	scale_y = g1_y_scale;
	mode    = g1_mode;
	option  = g1_opt;
    } else {
	XDefineCursor(display, window, curs2);
	scale_x = g2_x_scale;
	scale_y = g2_y_scale;
	mode    = g2_mode;
	option  = g2_opt;
    }

    if ( scale_y == G_LOG ) {
      coef = ( option == G_PFTC ) ? 10.0 : 20.0;
    }

    *max = *data;
    *min = *data;
    for ( i = 1; i < dataNumber; i++ ) {
	if ( *max < *(data + i) ) *max = *(data + i);
	if ( *min > *(data + i) ) *min = *(data + i);
    }

    if ( scale_y == G_LOG ) {
      *max = ( *max != 0.0 ) ? coef*log10(fabs(*max)): -500.0;
      *min = ( *min != 0.0 ) ? coef*log10(fabs(*min)): -500.0;
    }

    if (*max != *min ) {
      deltaY = ((Buffer) ( height - 1 ) / (*max - *min));
      originY = deltaY * *max;
    } else {
      if ( fabs(*max) > 0.0 ) {
	deltaY = (Buffer) (height -1)/ fabs(*max);
	originY = deltaY * *max;
	if ( *max > 0.0 ) *min = 0;
	else *max = 0.0;
      } else {
	deltaY = 1.0;
	originY = height / 2;
      }
    }

    if ( scale_x == G_LINER ) {
	switch ( mode ) {
	case G_TIME:
	    *left  = (Buffer)cutFrom / (Buffer)syscom.sam_freq;
	    *right = (Buffer)cutTo   / (Buffer)syscom.sam_freq;
	    break;
	case G_FREQ:
	    *left  = (Buffer)cutFrom /(((Buffer)dataNumber-1.0)*2.0)
		* (Buffer)syscom.sam_freq;
	    *right = (Buffer)cutTo   /(((Buffer)dataNumber-1.0)*2.0)
		* (Buffer)syscom.sam_freq;
	    break;
	case G_DATA:
	    *left  = (Buffer)cutFrom+1.0;
	    *right = (Buffer)cutTo+1.0;
	    break;
	}

	deltaX = ((Buffer) width / (Buffer) (dataNumber - 1));

	XSetForeground(display, gc, col2.pixel);

	
	if ( scale_y == G_LOG ) {
	  bx = 0;
	  tmpy = *(data+cutFrom);
	  tmpy = (tmpy != 0.0 ) ? coef*log10(fabs(tmpy)): -500.0;
	  by = (int)( originY -  deltaY * tmpy );
	  
	  for ( i = cutFrom+1; i <= cutTo; i++ ) {
	    
	    x = (int) ( deltaX * (Buffer)i );

	    tmpy = *(data+i);
	    tmpy = (tmpy != 0.0 ) ? coef*log10(fabs(tmpy)): -500.0;
	    y = (int) ( originY - deltaY * tmpy);
	    
	    XDrawLine(display, window, gc, bx, by, x, y);
	    
	    bx = x;
	    by = y;
	  }
	} else {
	  bx = 0;
	  by = (int)( originY -  deltaY * *(data+cutFrom) );
	  
	  for ( i = cutFrom+1; i <= cutTo; i++ ) {
	    
	    x = (int) ( deltaX * (Buffer)i );
	    y = (int) ( originY - deltaY * *(data + i));
	    
	    XDrawLine(display, window, gc, bx, by, x, y);

	    bx = x;
	    by = y;
	  }
	}

	right1 = *right;
	left1  = *left;

    } else {

	XSetForeground(display, gc, col2.pixel);

	switch ( mode ) {
	case G_TIME:
	    *left  = ((Buffer)cutFrom+1.0) / (Buffer)syscom.sam_freq;
	    *right = (Buffer)cutTo / (Buffer)syscom.sam_freq;
	    deltaX = 1.0 / (Buffer)syscom.sam_freq;
	    left1  = log10( ((double)cutFrom+1.0) * (double)deltaX );
	    right1 = log10( ((double)cutTo ) * (double)deltaX );
	    break;
	case G_FREQ:
	    *left  = ((Buffer)cutFrom+1.0) /(((Buffer)dataNumber-1.0)*2.0)
		* (Buffer)syscom.sam_freq;
	    *right = (Buffer)cutTo /(((Buffer)dataNumber-1.0)*2.0)
		* (Buffer)syscom.sam_freq;
	    deltaX = (Buffer)syscom.sam_freq /
	      ((Buffer)(dataNumber - 1.0 )*2.0);
	    left1  = log10( ((double)cutFrom+1.0)*(double)deltaX );
	    right1 = log10( ((double)cutTo)*(double)deltaX );
	    break;
	case G_DATA:
	    *left  = (Buffer)cutFrom+1.0;
	    *right = (Buffer)cutTo;
	    deltaX = 1.0;
	    left1 =  log10((double)cutFrom+1.0);
	    right1 = log10((double)cutTo);
	    break;
	}
	deltaX2 = (width-1.0)/(right1 - left1);

	leftX = - (int)(left1 * deltaX2 );

	if ( scale_y == G_LOG ) {
	  bx = 0;
	  tmpy = *(data+cutFrom+1);
	  tmpy = (tmpy != 0.0 ) ? coef*log10(fabs(tmpy)): -500.0;
	  by = (int)( originY - deltaY * tmpy );
	  
	  for ( i = cutFrom +2 ; i <= cutTo; i++ ) {
	    x=(int)(leftX + log10((double)i*(double)deltaX)*deltaX2);
	    tmpy = *(data+i);
	    tmpy = (tmpy != 0.0 ) ? coef*log10(fabs(tmpy)): -500.0;
	    y = (int)( originY - deltaY * tmpy);
	    
	    XDrawLine(display, window, gc, bx, by, x, y);
	    
	    bx = x;
	    by = y;
	  }
	} else {
	  bx = 0;
	  by = (int)( originY - deltaY * *(data+cutFrom+1) );
	  
	  for ( i = cutFrom +2 ; i <= cutTo; i++ ) {
	    x=(int)(leftX + log10((double)i*(double)deltaX)*deltaX2);
	    y = (int)( originY - deltaY * *(data + i));
	    
	    XDrawLine(display, window, gc, bx, by, x, y);
	    
	    bx = x;
	    by = y;
	  }
	}
    }

    XSetForeground(display, gc, col1.pixel);

    XSetLineAttributes( display, gc, 0, LineOnOffDash, CapButt, JoinMiter);
    XSetDashes( display, gc, 0, dash3, 2 );

    deltaX  = (Buffer)width/(right1-left1);

    if ( scale_x == G_LINER ) {

	stepX = (Buffer)((int)log10( (double)( *right - *left) * 100.0 ));
	stepX = pow( 10.0 , (double)stepX -2.0 );

	j = (int)((int)(*right/stepX*1000.0) - (int)(*left/stepX*1000.0))/1000;

	if ( j < 4 ) {
	    stepX /= 2.0;
	    j = (int)((int)(*right/stepX*1000.0)
		      - (int)(*left/stepX*1000.0))/1000;
	    if ( j < 4 ) {
		stepX /= 2.5;
		j = (int)((int)(*right/stepX*1000.0)
			  - (int)(*left/stepX*1000.0))/1000;
	    }
	} else if ( j > 7 ) {
	    stepX *= 2.0;
	    j = (int)((int)(*right/stepX*1000.0)
		      - (int)(*left/stepX*1000.0))/1000;
	}
	maxScaleOrigin = -(Buffer)((int)(*left/stepX));

	for ( i = 0; i <= j ; i++ ) {
	    x = -(int)maxScaleOrigin + (int)( deltaX * stepX * (float)i );
	    XDrawLine( display, window, gc, x , 0, x , height-1);
	}

    } else {
	for ( i = (int)left1; i <=(int)right1; i++ ) {
	    x=(int)(leftX + (float)i*deltaX);
	    XDrawLine( display, window, gc, x , 0, x , height-1);
	}
	for ( i = (int)left1-1 ; i <= (int)right1; i++ ) {
	    x=(int)(leftX + ((Buffer)i+0.69897)*deltaX);
	    if ( x >= 0 && x < width )
		XDrawLine( display, window, gc, x , 0, x , height-1);
	}
    }

    XSetLineAttributes( display, gc, 0, LineOnOffDash, CapButt, JoinMiter);
    XSetDashes( display, gc, 0, dash2, 2 );

    if ( *max - *min != 0.0 ) {
	stepY = (Buffer)((int)log10( (double)(*max - *min) * 100.0 ));
	stepY = pow( 10.0 , (double)stepY -2.0 );
	j = ((int)(*max/stepY*1000.0) - (int)(*min/stepY*1000.0))/1000;
    } else {
	stepY = 1.0;
	j     = 1;
    }

    if ( j < 4 ) {
	stepY /= 2.0;
	j = ((int)(*max/stepY*1000.0) - (int)(*min/stepY*1000.0))/1000;
	if ( j < 4 ) {
	    stepY /= 2.5;
	    j = ((int)(*max/stepY*1000.0) - (int)(*min/stepY*1000.0))/1000;
	}
    } else if ( j > 7 ) {
	stepY *= 2.0;
	j = (int)(*max/stepY) - (int)(*min/stepY);
    }

    maxScaleOrigin = originY-(deltaY*stepY)*(float)((int)(*max/stepY));

    if ( j < 20 ) {
	for ( i = 0; i <= j ; i++ ) {
	    y = (int)( maxScaleOrigin + deltaY * stepY *(double)i );
	    if ( abs((int)originY-y) > 2 )
		XDrawLine( display, window, gc, 0, y, width-1, y );
	}
    }    
    if ( *min <= 0.0 && *max > 0.0 ) {
	XSetLineAttributes( display, gc, 0, LineOnOffDash, CapButt, JoinMiter);
	XSetDashes( display, gc, 0, dash, 2 );
	XDrawLine(display,window,gc,0,(int)originY,width-1,(int)originY);
    }

    XFlush(display);
    XFreeGC(display, gc);
}

void writeLabel( canvas , max , min , left , right )
    int canvas;
    double max, min, left, right;
{
    char        cmax[20], cmin[20], cleft[20], cright[20], title[20];
    int mode;

    mode = ( canvas == g1_canvas ) ? g1_mode : g2_mode;

    if ( min != max ) {
	sprintf( cmax   , "%g" , max   );
	sprintf( cmin   , "%g" , min   );
    } else {
	sprintf( cmax   , "%g", max );
	sprintf( cmin   , " "  );
    }
    sprintf( cleft  , "%g" , left  );
    sprintf( cright , "%g" , right );

    switch ( mode ) {
    case G_TIME: strcpy( title , "Time [sec]" );     break;
    case G_FREQ: strcpy( title , "Frequency [Hz]" ); break;
    case G_DATA: strcpy( title , "DataPoints" );     break;
    }

    if ( canvas == g1_canvas ) {
	setLabel( widget_array[g1_max    ] , cmax   );
	setLabel( widget_array[g1_min    ] , cmin   );
	setLabel( widget_array[g1_left   ] , cleft  );
	setLabel( widget_array[g1_right  ] , cright );
	setLabel( widget_array[g1_x_title] , title  );
    } else {
	setLabel( widget_array[g2_max    ] , cmax   );
	setLabel( widget_array[g2_min    ] , cmin   );
	setLabel( widget_array[g2_left   ] , cleft  );
	setLabel( widget_array[g2_right  ] , cright );
	setLabel( widget_array[g2_x_title] , title  );
    }
}

void myerase( canvas )
    int canvas;
{
  if ( canvas == g1_canvas || canvas == g2_canvas ) {
    if ( widget_array[canvas] != NULL ) {
      XClearWindow( XtDisplay( widget_array[canvas] ),
		   XtWindow( widget_array[canvas] ) );
      XFlush( XtDisplay(widget_array[canvas]) );
    }
  }
}

void
zoom_in( w , tag , callback_data )
     Widget w;
     int    *tag;
     caddr_t callback_data;
{
  Arg arg[3];
  int n;
  Dimension width;
  Dimension b_width;

  n = 0;
  XtSetArg( arg[n] , XmNwidth , &width );n++;
  XtGetValues( widget_array[ *tag ] , arg , n );

  b_width = width;

  if ( width*2 < MaxWidth )
    width *= 2;
  else
    width = MaxWidth;

  if ( width != b_width ) {
    n = 0;
    XtSetArg( arg[n] , XmNwidth , width );n++;
    XtSetValues( widget_array[ *tag ] , arg , n );
      
    if ( *tag == g1_canvas && show_buff1 != NULL )
      drawGraph( g1_canvas, show_buff1, buff_len1);
      
    if ( *tag == g2_canvas && show_buff2 != NULL )
      drawGraph( g2_canvas, show_buff2, buff_len2);
  }
}

void
zoom_out( w , tag , callback_data )
     Widget w;
     int    *tag;
     caddr_t callback_data;
{
  Arg arg[3];
  int n;
  Dimension width,width_base;
  Dimension b_width;

  n = 0;
  XtSetArg( arg[n] , XmNwidth , &width );n++;
  XtGetValues( widget_array[ *tag ] , arg , n );

  b_width = width;

  if ( *tag == g1_canvas ) {
    n = 0;
    XtSetArg( arg[n] , XmNwidth , &width_base );n++;
    XtGetValues( widget_array[g1_clip] , arg , n );
  }else {
    n = 0;
    XtSetArg( arg[n] , XmNwidth , &width_base );n++;
    XtGetValues( widget_array[g2_clip] , arg , n );
  }

  if ( width/2 > width_base )
    width /= 2;
  else
    width = width_base;


  if ( width != b_width ) {
    n = 0;
    XtSetArg( arg[n] , XmNwidth , width );n++;
    XtSetValues( widget_array[ *tag ] , arg , n );
    
    if ( *tag == g1_canvas && show_buff1 != NULL )
      drawGraph( g1_canvas, show_buff1, buff_len1 );
    
    if ( *tag == g2_canvas && show_buff2 != NULL )
      drawGraph( g2_canvas, show_buff2, buff_len2 );
  }
}

void redraw_proc( w ,tag , callback_data )
    Widget w;
    int    *tag;
    caddr_t callback_data;
{
  if ( tag == NULL ) {
    drawGraph( g1_canvas, show_buff1, buff_len1);
    drawGraph( g2_canvas, show_buff2, buff_len2);
  } else {
    if ( *tag == g1_canvas )
      drawGraph( g1_canvas, show_buff1, buff_len1);
    else if ( *tag == g2_canvas )
      drawGraph( g2_canvas, show_buff2, buff_len2);
  }
}

void drawGraph( canvas , showbuf, buflen) /* drawing graph from buffer data */
     int canvas;
     Buffer *showbuf;
     int buflen;
{
  Arg arg[3];
  int n , i, l;
  Dimension height,height_base;
  Widget win;
  Buffer max, min, left, right;
  int    dpt, option, mode;
  Buffer *tmp1, *tmp2;
  
  if ( canvas == g1_canvas ) {
    option = g1_opt;
    mode  = g1_mode;
    win = widget_array[g1_clip];
  } else{
    option = g2_opt;
    mode   = g2_mode;
    win = widget_array[g2_clip];
  }
  n = 0;
  XtSetArg( arg[n] , XmNheight , &height_base );n++;
  XtGetValues( win , arg , n );
  
  height = height_base;

  n = 0;
  XtSetArg( arg[n] , XmNheight , height ); n++;
  XtSetValues( widget_array[ canvas ] , arg , n );
  
  if ( showbuf != NULL ) {
    dpt = syscom.buff_leng = buflen;
    set_dpt(dpt);

    if ( option == G_NORM || (mode = G_FREQ && option != G_PFTC) ) {
      myerase( canvas );
      mygraph( widget_array[ canvas ] , showbuf, dpt,
	      0 , dpt-1 , "White" , "Green" ,
	      &max , &min , &left , &right );
      writeLabel( canvas , max, min, left, right );
    } else {
      
      l = (int)ceil(log((double)dpt)/log(2.0));
      syscom.buff_leng = 1 << l;
      tmp1 = AllocBuffer(syscom.buff_leng);
      tmp2 = CAllocBuffer(syscom.buff_leng);
      
      for ( i = 0; i < dpt; i++ )
	tmp1[i] = showbuf[i];
      for ( i = dpt; i < syscom.buff_leng; i++ )
	tmp1[i] = 0.0;
      
      power( tmp1, tmp2 , l );
      
      syscom.buff_leng /= 2;
      
      myerase( canvas );
      mygraph( widget_array[ canvas ] , tmp1, syscom.buff_leng,
	      0 , syscom.buff_leng-1 , "White" , "Green" ,
	      &max , &min , &left , &right );
      writeLabel( canvas , max, min, left, right );
      FreeBuffer( tmp1 );
      FreeBuffer( tmp2 );
    }
    syscom.buff_leng = data_points;
  }
}

static void power( x, y, l )
    Buffer x[], y[];
    int l;
{
    int dpt,i;

    fft2( x , y , l , -1.0 );

    dpt = 1 << l;

    for ( i = 0; i < dpt/2+1; i++ )
	x[i]= 2.0*(x[i]*x[i]+y[i]*y[i])/((double)syscom.sam_freq*dpt);

}

void resize_proc( w , tag , callback_data )
    Widget w;
    int *tag;
    caddr_t callback_data;
{
  Arg arg[3];
  int n;
  Dimension height,height_base, width, width_base;

  n = 0;
  XtSetArg( arg[n] , XmNheight , &height_base );n++;
  XtSetArg( arg[n] , XmNwidth  , &width_base  );n++;
  XtGetValues( widget_array[g1_clip] , arg , n );

  n = 0;
  XtSetArg( arg[n] , XmNwidth  , &width );n++;
  XtSetArg( arg[n] , XmNheight , &height );n++;
  XtGetValues( widget_array[ g1_canvas ] , arg , n );

/*  height_base -= 1;*/

  n = 0;
  if ( width < width_base ){
    XtSetArg( arg[n] , XmNwidth , width_base );n++;
  }
  if ( height != height_base ) {
    XtSetArg( arg[n] , XmNheight , height_base ); n++;
  }
  if ( n > 0 )
    XtSetValues( widget_array[g1_canvas] , arg , n );

  n = 0;
  XtSetArg( arg[n] , XmNheight , &height_base );n++;
  XtSetArg( arg[n] , XmNwidth  , &width_base  );n++;
  XtGetValues( widget_array[g2_clip] , arg , n );

  n = 0;
  XtSetArg( arg[n] , XmNwidth  , &width );n++;
  XtSetArg( arg[n] , XmNheight , &height );n++;
  XtGetValues( widget_array[ g2_canvas ] , arg , n );

/*  height_base -= 1;*/

  n = 0;
  if ( width < width_base ){
    XtSetArg( arg[n] , XmNwidth , width_base );n++;
  }
  if ( height != height_base ) {
    XtSetArg( arg[n] , XmNheight , height_base );n++;
  }
  if ( n > 0 )
    XtSetValues( widget_array[ g2_canvas ] , arg , n );

  if ( w != NULL ) {
    if ( show_buff1 == 0 ) myerase(g1_canvas);
    if ( show_buff2 == 0 ) myerase(g2_canvas);
  }
  XFlush(XtDisplay(widget_array[g1_canvas]));
}

