#ifdef REV_INFO
#ifndef lint
  static char SCCSID[] = "OSF/Motif: @(#)isop.c	1.15.1.2 92/09/21";
#endif /* lint */
#endif /* REV_INFO */

#define MAIN 

#include "isop_all.h"
#include "isop_resource.h"

static Widget w_menu_buttons, w_graphical_form, w_sepa2, w_buffers_form;
static Widget w_quit_button, w_status_button, w_option_button;
static Widget w_figure, w_com_name, w_sepa1;
static Widget w_cmd_label, w_sam_label, w_dpt_label;
static Widget w_graph_sepa, w_graph1_form, w_graph2_form;
static Widget w_zoom1_label, w_zoom1_in_button, w_zoom1_out_button;
static Widget w_zoom2_label, w_zoom2_in_button, w_zoom2_out_button;
static Widget w_buff_label, w_sepa3;
static Widget w_inpu_sepa, w_outp_sepa;
static Widget w_outp_menu1, w_outp_menu2;
static Widget w_outp_fmtnew, w_outp_fmtold;
static Widget w_outp_type4, w_outp_type2, w_outp_type8;
static Widget w_verbar;

static int k_g1_canvas = g1_canvas;
static int k_g2_canvas = g2_canvas;
static int f_sel1 = 1;
static int f_sel2 = 2;
static int fmt_new = 1, fmt_old = 2, type_4 = 3, type_2 = 4, type_8 = 5;

/*
 *  Main program
 */
int main(argc, argv)
     int    argc;
     char **argv;
{
  /*
   *  Declare the variables to contain the two widget ids
   */
  Arg arglist[10] ;
  int n;

  Widget toplevel;
  int    i;

  int    pid;

  static char envname[] = "SYS_COMMON";

  if ( getenv(envname) != NULL ) {
    read_syscom();
  } else {
    syscom.sam_freq    = 1000.0;
    syscom.buff_leng   = 1024;
  }

  signal(SIGSTOP,  (RETSIGTYPE (*)()) quit_all);
  signal(SIGINT,   (RETSIGTYPE (*)()) quit_all);
  signal(SIGILL,   (RETSIGTYPE (*)()) quit_all);
  signal(SIGTERM,  (RETSIGTYPE (*)()) quit_all);
  signal(SIGQUIT,  (RETSIGTYPE (*)()) quit_all);
  signal(SIGHUP,   (RETSIGTYPE (*)()) quit_all);
  signal(SIGBUS,   (RETSIGTYPE (*)()) quit_all);
  signal(SIGSEGV,  (RETSIGTYPE (*)()) quit_all);
  signal(SIGFPE,   (RETSIGTYPE (*)()) quit_all);

  /* initalize */
  widget_array =(Widget*) calloc( MAX_WIDGET, sizeof( Widget ) );
  
  execMode = NOTHING;
  ibuf_num_max = ibuf_num = 0;
  obuf_num = 0;
  
  input_file_name[0]  = '\0';
  output_file_name[0] = '\0';

  show_buff1 = NULL;
  show_buff2 = NULL;
  buff_len1 = 0;
  buff_len2 = 0;

  for ( i = 0; i < MAX_WIDGET ; i++ )
    widget_array[i] = NULL;
  
  /*
   *  Set SATELITE's system common status
   */

  sampling_frequency = syscom.sam_freq;
  before_sam         = syscom.sam_freq;
  data_points        = syscom.buff_leng;
  before_dpt         = syscom.buff_leng;
  
  strcpy(obuf_format,"new");
  strcpy(ibuf_format,"new");
  strcpy(obuf_type,"BigEndian");
  strcpy(ibuf_type,"BigEndian");
  obuf_byte = ibuf_byte = 4;
  

  /* X Window Setup */
  XtSetLanguageProc(NULL,NULL,NULL);

  n = 0;
  XtSetArg(arglist[n], XmNallowShellResize, False);  n++;
  XtSetArg(arglist[n], XmNminHeight, MAIN_WINDOW_HEIGHT ); n++;
  XtSetArg(arglist[n], XmNminWidth,  MAIN_WINDOW_WIDTH ); n++;
  XtSetArg(arglist[n], XmNtitle, "xcut (ISPP OPERATOR-Lite)"); n++;
  toplevel = XtAppInitialize(&app_context, "XCUT",
			     NULL, 0, &argc, argv, resources, arglist, n);
  n = 0;
  XtSetArg(arglist[n], XmNheight, MAIN_WINDOW_HEIGHT ); n++;
  XtSetArg(arglist[n], XmNwidth,  MAIN_WINDOW_WIDTH ); n++;
  isopmain = XmCreateForm( toplevel, "isopmain", arglist, n);

  w_menu_buttons    = XmCreateMenuBar(isopmain,   "menu_buttons",NULL, 0);

  w_quit_button   = XmCreateCascadeButton(w_menu_buttons,"quit_button",NULL,0);
  w_status_button = XmCreateCascadeButton(w_menu_buttons,"status_button",
					  NULL,0);
  w_option_button = XmCreateCascadeButton(w_menu_buttons,"option_button",
					  NULL,0);
  XtManageChild(w_status_button);
  XtManageChild(w_option_button);
  XtManageChild(w_quit_button);
  XtManageChild(w_menu_buttons);

  /* BuffersForm */
  w_buffers_form = widget_array[buffer_form] =
    XmCreateForm(isopmain, "buffers_form", NULL, 0);
  w_buff_label = XmCreateLabel(w_buffers_form, "buff_label", NULL, 0);
  w_sepa3      = XmCreateSeparator(w_buffers_form, "sepa3", NULL, 0);

  XtManageChild(w_buffers_form);
  XtManageChild(w_buff_label);
  XtManageChild(w_sepa3);

  /* InputFiles */
  widget_array[inpu_label] = XmCreateLabel(w_buffers_form, "inpu_label",
					   NULL, 0);
  widget_array[inpu_file]=XmCreatePushButton(w_buffers_form, "inpu_select",
					     NULL, 0);
  widget_array[inpu_dec]=XmCreateArrowButton(w_buffers_form,
					     "inpu_dec_button",NULL,0);
  widget_array[inpu_inc]=XmCreateArrowButton(w_buffers_form,
					     "inpu_inc_button",NULL,0);
  widget_array[inpu_num]=XmCreateTextField(w_buffers_form,"inpu_num",NULL,0);
  XtManageChild(widget_array[inpu_label]);
  XtManageChild(widget_array[inpu_file]);
  XtManageChild(widget_array[inpu_dec]);
  XtManageChild(widget_array[inpu_inc]);
  XtManageChild(widget_array[inpu_num]);

  /* Separator */
  w_inpu_sepa = XmCreateSeparator(w_buffers_form, "inpu_sepa", NULL, 0);
  XtManageChild(w_inpu_sepa);

  /* OutputFiles */
  widget_array[outp_label]=XmCreateLabel(w_buffers_form, "outp_label",
					   NULL, 0);
  widget_array[outp_file]=XmCreatePushButton(w_buffers_form, "outp_select",
					     NULL, 0);
  widget_array[outp_dec]=XmCreateArrowButton(w_buffers_form,
					     "outp_dec_button",NULL,0);
  widget_array[outp_inc]=XmCreateArrowButton(w_buffers_form,
					     "outp_inc_button",NULL,0);
  widget_array[outp_num]=XmCreateTextField(w_buffers_form,"outp_num",NULL,0);
  XtManageChild(widget_array[outp_label]);
  XtManageChild(widget_array[outp_file]);
  XtManageChild(widget_array[outp_dec]);
  XtManageChild(widget_array[outp_inc]);
  XtManageChild(widget_array[outp_num]);

  w_outp_menu2 = XmCreatePulldownMenu(w_buffers_form,"outp_pulldown2",NULL,0);
  w_outp_type4 = XmCreatePushButton(w_outp_menu2, "fourByte", NULL, 0);
  w_outp_type2 = XmCreatePushButton(w_outp_menu2, "twoByte", NULL, 0);
  w_outp_type8 = XmCreatePushButton(w_outp_menu2, "eightByte", NULL, 0);
  n = 0;
  XtSetArg(arglist[n], XmNsubMenuId, w_outp_menu2);  n++;
  widget_array[outp_write_type] =
    XmCreateOptionMenu(w_buffers_form, "outp_write_byte", arglist, n);

  w_outp_menu1  = XmCreatePulldownMenu(w_buffers_form,"outp_pulldown1",NULL,0);
  w_outp_fmtnew = XmCreatePushButton(w_outp_menu1, "new", NULL, 0);
  w_outp_fmtold = XmCreatePushButton(w_outp_menu1, "old", NULL, 0);

  n = 0;
  XtSetArg(arglist[n], XmNsubMenuId, w_outp_menu1);  n++;
  widget_array[outp_write_format] =
    XmCreateOptionMenu(w_buffers_form, "outp_write_format", arglist, n);

  XtManageChild(w_outp_fmtnew);
  XtManageChild(w_outp_fmtold);
  XtManageChild(w_outp_type4);
  XtManageChild(w_outp_type2);
  XtManageChild(w_outp_type8);
  XtManageChild(widget_array[outp_write_format]);
  XtManageChild(widget_array[outp_write_type]);

  /* Separator */
  w_outp_sepa = XmCreateSeparator(w_buffers_form, "outp_sepa", NULL, 0);
  XtManageChild(w_outp_sepa);

  /* Separator */
  w_sepa2           = XmCreateSeparator(isopmain, "sepa2", NULL, 0);
  XtManageChild(w_sepa2);

  /* GraphicalForm */
  w_graphical_form  = XmCreateForm(isopmain, "graphical_form", NULL, 0);
  XtManageChild(w_graphical_form);

  /* CommandInformation */
  w_com_name              = XmCreateForm(w_graphical_form,"com_name",NULL,0);
  w_cmd_label             = XmCreateLabel(w_com_name,"cmd_label",    NULL,0);
  widget_array[com_name]  = XmCreateLabel(w_com_name,"command_name", NULL,0);
  widget_array[sam_rate]  = XmCreateLabel(w_com_name,"sampling",     NULL,0);
  w_sam_label             = XmCreateLabel(w_com_name,"sam_label",    NULL,0);
  widget_array[dat_point] = XmCreateLabel(w_com_name,"dpoint",       NULL,0);
  w_dpt_label             = XmCreateLabel(w_com_name,"dpt_label",    NULL,0);

  XtManageChild(w_com_name);
  XtManageChild(w_cmd_label);
  XtManageChild(w_sam_label);
  XtManageChild(w_dpt_label);
  XtManageChild(widget_array[com_name]);
  XtManageChild(widget_array[sam_rate]);
  XtManageChild(widget_array[dat_point]);
  
  w_sepa1    = XmCreateSeparator(w_graphical_form, "sepa1", NULL, 0);
  XtManageChild(w_sepa1);

  /* FigureSpace */
  w_figure   = XmCreateForm(w_graphical_form, "figure", NULL, 0);
  XtManageChild(w_figure);

  /* Separator */
  w_graph_sepa  = XmCreateSeparator(w_figure, "graph_sepa", NULL, 0);
  XtManageChild(w_graph_sepa);

  /* Graph1Form */
  w_graph1_form = XmCreateForm(w_figure, "graph1_form", NULL, 0);
  XtManageChild(w_graph1_form);

  widget_array[g1_title] = XmCreateLabel(w_graph1_form, "title1", NULL, 0);
  w_zoom1_out_button = XmCreateArrowButton(w_graph1_form,"zoom1_out_button",
					   NULL, 0);
  w_zoom1_in_button  = XmCreateArrowButton(w_graph1_form,"zoom1_in_button",
					   NULL, 0);
  w_zoom1_label      = XmCreateLabel(w_graph1_form,"zoom1_label",    NULL,0);

  XtManageChild(widget_array[g1_title]);
  XtManageChild(w_zoom1_out_button);
  XtManageChild(w_zoom1_in_button);
  XtManageChild(w_zoom1_label);

  widget_array[g1_left]  =XmCreateLabel(w_graph1_form,"g1_left_label",NULL,0);
  widget_array[g1_right] =XmCreateLabel(w_graph1_form,"g1_right_label",NULL,0);
  widget_array[g1_x_title] = XmCreateLabel(w_graph1_form,"g1_label",NULL,0);
  widget_array[g1_max] = XmCreateLabel(w_graph1_form,"g1_max_label",NULL,0);
  widget_array[g1_min] = XmCreateLabel(w_graph1_form,"g1_min_label",NULL,0);

  XtManageChild(widget_array[g1_left]);
  XtManageChild(widget_array[g1_right]);
  XtManageChild(widget_array[g1_x_title]);
  XtManageChild(widget_array[g1_max]);
  XtManageChild(widget_array[g1_min]);

  /* Graph1 Window */
  widget_array[g1_win] = XmCreateScrolledWindow(w_graph1_form,"g1_window",
						NULL, 0);
  widget_array[g1_canvas] = XmCreateDrawingArea(widget_array[g1_win],
						"g1_canvas", NULL, 0);
  XmScrolledWindowSetAreas(widget_array[g1_win], NULL, NULL,
			   widget_array[g1_canvas]);
  XtManageChild(widget_array[g1_canvas]);

  n = 0;
  XtSetArg( arglist[n] , XmNclipWindow , &widget_array[g1_clip]);n++;
  XtSetArg( arglist[n] , XmNverticalScrollBar , &w_verbar);n++;
  XtGetValues(widget_array[g1_win], arglist, n);
  XtUnmanageChild(w_verbar);
  XtManageChild(widget_array[g1_win]);

  /* Graph2Form */
  w_graph2_form = XmCreateForm(w_figure, "graph2_form", NULL, 0);
  XtManageChild(w_graph2_form);

  widget_array[g2_title] = XmCreateLabel(w_graph2_form, "title2", NULL, 0);
  w_zoom2_out_button = XmCreateArrowButton(w_graph2_form,"zoom2_out_button",
					   NULL, 0);
  w_zoom2_in_button  = XmCreateArrowButton(w_graph2_form,"zoom2_in_button",
					   NULL, 0);
  w_zoom2_label      = XmCreateLabel(w_graph2_form,"zoom2_label",    NULL,0);

  XtManageChild(widget_array[g2_title]);
  XtManageChild(w_zoom2_out_button);
  XtManageChild(w_zoom2_in_button);
  XtManageChild(w_zoom2_label);

  widget_array[g2_left]  =XmCreateLabel(w_graph2_form,"g2_left_label",NULL,0);
  widget_array[g2_right] =XmCreateLabel(w_graph2_form,"g2_right_label",NULL,0);
  widget_array[g2_x_title] = XmCreateLabel(w_graph2_form,"g2_label",NULL,0);
  widget_array[g2_max] = XmCreateLabel(w_graph2_form,"g2_max_label",NULL,0);
  widget_array[g2_min] = XmCreateLabel(w_graph2_form,"g2_min_label",NULL,0);

  XtManageChild(widget_array[g2_left]);
  XtManageChild(widget_array[g2_right]);
  XtManageChild(widget_array[g2_x_title]);
  XtManageChild(widget_array[g2_max]);
  XtManageChild(widget_array[g2_min]);

  /* Graph2 Window */
  widget_array[g2_win] = XmCreateScrolledWindow(w_graph2_form,"g2_window",
						NULL, 0);
  widget_array[g2_canvas] = XmCreateDrawingArea(widget_array[g2_win],
						"g2_canvas", NULL, 0);
  XmScrolledWindowSetAreas(widget_array[g2_win], NULL, NULL,
			   widget_array[g2_canvas]);
  XtManageChild(widget_array[g2_canvas]);

  n = 0;
  XtSetArg( arglist[n] , XmNclipWindow , &widget_array[g2_clip]);n++;
  XtSetArg( arglist[n] , XmNverticalScrollBar , &w_verbar);n++;
  XtGetValues(widget_array[g2_win], arglist, n);
  XtUnmanageChild(w_verbar);
  XtManageChild(widget_array[g2_win]);


  XtManageChild(isopmain);
  XtRealizeWidget(toplevel);

  /* Add CallBacks */

  /* MenuButtons */
  XtAddCallback(w_quit_button, XmNactivateCallback,
		(XtCallbackProc)quit_proc, NULL);
  XtAddCallback(w_status_button, XmNactivateCallback,
		(XtCallbackProc)creat_status_box, NULL);
  XtAddCallback(w_option_button, XmNactivateCallback,
		(XtCallbackProc)creat_option_box, NULL);

  /* BuffersAreas */
  XtAddCallback(widget_array[inpu_file], XmNactivateCallback,
		(XtCallbackProc)file_select, (XtPointer)&f_sel1);

  XtAddCallback(widget_array[inpu_dec], XmNactivateCallback,
		(XtCallbackProc)ibuf_set, NULL);
  XtAddCallback(widget_array[inpu_num], XmNactivateCallback,
		(XtCallbackProc)ibuf_set, NULL);
  XtAddCallback(widget_array[inpu_inc], XmNactivateCallback,
		(XtCallbackProc)ibuf_set, NULL);

  XtAddCallback(widget_array[outp_file], XmNactivateCallback,
		(XtCallbackProc)file_select, (XtPointer)&f_sel2);

  XtAddCallback(widget_array[outp_dec], XmNactivateCallback,
		(XtCallbackProc)obuf_set, NULL);
  XtAddCallback(widget_array[outp_num], XmNactivateCallback,
		(XtCallbackProc)obuf_set, NULL);
  XtAddCallback(widget_array[outp_inc], XmNactivateCallback,
		(XtCallbackProc)obuf_set, NULL);

  XtAddCallback(w_outp_fmtnew, XmNactivateCallback,
		(XtCallbackProc)set_write_type, (XtPointer)&fmt_new);
  XtAddCallback(w_outp_fmtold, XmNactivateCallback,
		(XtCallbackProc)set_write_type, (XtPointer)&fmt_old);
  XtAddCallback(w_outp_type4, XmNactivateCallback,
		(XtCallbackProc)set_write_type, (XtPointer)&type_4);
  XtAddCallback(w_outp_type2, XmNactivateCallback,
		(XtCallbackProc)set_write_type, (XtPointer)&type_2);
  XtAddCallback(w_outp_type8, XmNactivateCallback,
		(XtCallbackProc)set_write_type, (XtPointer)&type_8);

  /* DrawingAreas */
  XtAddCallback(w_zoom1_in_button,  XmNactivateCallback,
		(XtCallbackProc)zoom_in,  (XtPointer)&k_g1_canvas);
  XtAddCallback(w_zoom1_out_button, XmNactivateCallback,
		(XtCallbackProc)zoom_out, (XtPointer)&k_g1_canvas);
  XtAddCallback(w_zoom2_in_button,  XmNactivateCallback,
		(XtCallbackProc)zoom_in,  (XtPointer)&k_g2_canvas);
  XtAddCallback(w_zoom2_out_button, XmNactivateCallback,
		(XtCallbackProc)zoom_out, (XtPointer)&k_g2_canvas);

  resize_proc(NULL,NULL,NULL);


  /* Label Set */
  writeLabel( g1_canvas, 0.0 , 0.0 , 0.0 , 0.0 );
  writeLabel( g2_canvas, 0.0 , 0.0 , 0.0 , 0.0 );

  setLabel(widget_array[inpu_file], "Select..." );
  setLabel(widget_array[outp_file], "Select..." );
  setValue(widget_array[inpu_num], "0000" );
  setValue(widget_array[outp_num], "0000" );
  set_dpt( syscom.buff_leng );
  set_freq();


  /* Resize and Expose Callback */
  /* Should be placed after XtRealizeWidget(toplevel) */
  XtAddCallback(widget_array[g1_clip], XmNexposeCallback,
		(XtCallbackProc)redraw_proc, NULL);
  XtAddCallback(widget_array[g2_clip], XmNresizeCallback,
		(XtCallbackProc)resize_proc, NULL);

  creat_status_box( NULL, NULL, NULL);
  creat_option_box( NULL, NULL, NULL);

  cutdt_func(NULL,NULL,NULL);

  switch (pid = fork()) {
    case -1:
      perror("Can't create new process.\n");
      exit(0);
    case 0:
      break;
    default:
      exit(0);
  }

  XtAppMainLoop(app_context);
  return 0;
}

