#ifndef _ISOP_ALL_H_
#define _ISOP_ALL_H_

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <signal.h>
#include <stdio.h>

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#else
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif /* HAVE_STDLIB_H */
#endif /* HAVE_MALLOC_H */

#include <math.h>

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>

#include <Xm/Xm.h>          /* Motif Toolkit */

#include <Mrm/MrmPublic.h>   /* Mrm */

#include <Xm/MessageB.h>
#include <Xm/ScrolledW.h>
#include <Xm/Separator.h>
#include <Xm/RowColumn.h>
#include <Xm/CascadeB.h>
#include <Xm/ArrowB.h>
#include <Xm/PushB.h>
#include <Xm/DrawingA.h>
#include <Xm/Form.h>
#include <Xm/ToggleB.h>
#include <Xm/Label.h>
#include <Xm/TextF.h>
#include <Xm/Text.h>
#include <Xm/FileSB.h>

#include "SL_macro.h"
#include "SL_cmd.h"

#define MAIN_WINDOW_WIDTH  700
#define MAIN_WINDOW_HEIGHT 450

#define PAI  3.14159265358979323846
#define PAI2 (PAI*2.0)

/* graphic mode constant ( for g1_mode and g2_mode )*/
#define G_TIME  0
#define G_FREQ  1
#define G_DATA  2
/* graphic mode constant ( for g1_scale and g2_scale )*/
#define G_LINER 0
#define G_LOG   1
/* graphic mode constant ( for g1_opt and g2_opt )*/
#define G_NORM  0
#define G_PFTC  1

/* command number */
#define NOTHING      0
#define CUTDT        5

/* Widget Array */

#define graph_form     1
#define com_name       2
#define dat_point      3
#define sam_rate       4

#define g1_title       5
#define g1_max         6
#define g1_min         7
#define g1_left        8
#define g1_right       9
#define g1_x_title    10
#define g1_canvas     11
#define g1_win        12

#define g2_title      13
#define g2_max        14
#define g2_min        15
#define g2_left       16
#define g2_right      17
#define g2_x_title    18
#define g2_canvas     19
#define g2_win        20

#define buffer_form   21

#define inpu_label    23
#define inpu_dec      24
#define inpu_num      25
#define inpu_inc      26

#define outp_label    27
#define outp_dec      28
#define outp_num      29
#define outp_inc      30

#define writ_button   31
#define write_dlg     32
#define exit_button   33
#define exit_dlg      34

#define stat_form     35
#define stat_sam      36
#define stat_dpt      37
#define stat_set      38
#define stat_can      39

#define opt_form      40
#define opt_set       41
#define opt_can       42

#define g1_x_power    43
#define g1_x_norm     44
#define g1_x_data     45

#define g2_x_power    46
#define g2_x_norm     47
#define g2_x_data     48

#define g1_x_liner    49
#define g1_x_log      50
#define g1_y_liner    51
#define g1_y_log      52

#define g2_x_liner    53
#define g2_x_log      54
#define g2_y_liner    55
#define g2_y_log      56

#define cutdt         57
#define cut_start     58
#define cut_end       59
#define cut_st_u      60
#define cut_ed_u      61

#define quit_dlg      62

#define inpu_file     63
#define outp_file     64

#define outp_write_format 65
#define outp_write_type   66

#define g1_clip 67
#define g2_clip 68

#define MAX_WIDGET    69


#ifndef MAIN
#define WHERE extern
#else
#define WHERE
#endif

/* isop external arguments */

WHERE int   execMode;
WHERE float sampling_frequency , before_sam;
WHERE int   data_points, before_dpt;
WHERE int   g1_x_scale, g1_y_scale, g1_mode, g1_opt;
WHERE int   g2_x_scale, g2_y_scale, g2_mode, g2_opt;
WHERE int   g1_x_scale1, g1_y_scale1;
WHERE int   g2_x_scale1, g2_y_scale1;
WHERE int   g1_x_scale2, g1_y_scale2;
WHERE int   g2_x_scale2, g2_y_scale2;
WHERE int   normal_mode;
WHERE int   ibuf_num, obuf_num;
WHERE int   ibuf_num_max;
WHERE int   modified_flag, made_data;
WHERE Buffer *tmp_buff1, *tmp_buff2, *tmp_buff3;
WHERE Dimension canvas_width, canvas_height;

WHERE char input_file_name[FILE_LENGTH+1];
WHERE char output_file_name[FILE_LENGTH+1];

WHERE char obuf_format[10], ibuf_format[10];
WHERE char obuf_type[20], ibuf_type[20];
WHERE int  obuf_byte, ibuf_byte;

WHERE Buffer  *show_buff1, *show_buff2;
WHERE int      buff_len1, buff_len2;

WHERE Widget       *widget_array;

WHERE Display      *display;
WHERE XtAppContext app_context;
WHERE Widget       isopmain;

typedef struct {
    int x;
    int y;
    double xx;
    double yy;
} Shape;


#include "isop_proto.h"

#endif /* _ISOP_ALL_H_ */
