#include "isop_all.h"
#include "string.h"

static int  b_pftc1, b_normal1, b_x1liner, b_y1liner;
static int  b_pftc2, b_normal2, b_x2liner, b_y2liner;

void
set_dpt( dpt )
     int dpt;
{
  char  d_point[10];
    
  sprintf( d_point ,"%d", dpt );
  setLabel( widget_array[dat_point] , d_point );
}

void
set_freq()
{
  char  ex[4];
  char  samfre[20];
  float sample;
  int   expo;
    
  sample = syscom.sam_freq;
  for ( expo = 0 ; sample > 1000.0; expo+=3 ) 
    sample /= 1000.0;

  switch ( expo ) {
  case 0:  strcpy( ex , "Hz" ); break;
  case 3:  strcpy( ex , "kHz" ); break;
  case 6:  strcpy( ex , "MHz" ); break;
  case 9:  strcpy( ex , "GHz" ); break;
  case 12: strcpy( ex , "THz" ); break;
  }

  sprintf( samfre , "%g %s", sample , ex ); 
  setLabel( widget_array[sam_rate] , samfre );
}

void quit_by_error(sig)
     int sig;
{
  int             code = 0;
  static char    *sigmsg[] = {
    "",
    "Hangup",
    "Interrupt",
    "Quit",
    "Illegal instruction",
    "Trace trap",
    "IOT instruction",
    "EMT instruction",
    "Floating point exception",
    "Kill",
    "Bus error",
    "Segmentation violation",
    "Bad arg to system call",
    "Write on pipe",
    "Alarm clock",
    "Terminate signal",
    "User signal 1",
    "User signal 2",
    "Death of child",
    "Power fail"
  };
  if (sig != 0) {
    if ((code = (sig & 0177)) <= 19)
      fprintf(stderr, "%s.\n", sigmsg[sig]);
  }
  exit(sig);
}    

void
quit_all( widget, tag, callback_data )
     Widget widget;
     char   *tag;
     XmAnyCallbackStruct *callback_data;
{
  exit(0);
}

void creat_status_box( widget, tag , callback_data )
     Widget widget;
     int   *tag;
     XmAnyCallbackStruct *callback_data;
{
  static Widget w_status_sam, w_status_dpt, w_herts_label, w_dpoint_label;
  static int s_set = 1, s_can = 0, s_freq = 2, s_dpt = 3;
  char  freq[20];
  char  point[10];

  if ( widget_array[stat_form] == NULL ) {
    widget_array[stat_form] = 
      XmCreateFormDialog(isopmain,"status_set_form",NULL,0);

    w_status_sam =XmCreateLabel(widget_array[stat_form], "status_sam",NULL,0);
    w_status_dpt =XmCreateLabel(widget_array[stat_form], "status_dpt",NULL,0);
    w_herts_label=XmCreateLabel(widget_array[stat_form], "herts_label",NULL,0);
    w_dpoint_label=XmCreateLabel(widget_array[stat_form],
				 "dpoint_label",NULL,0);
    widget_array[stat_sam] = XmCreateTextField(widget_array[stat_form],
					       "sam_freq_input",NULL,0);
    widget_array[stat_dpt] = XmCreateTextField(widget_array[stat_form],
					       "dat_point_input",NULL,0);
    widget_array[stat_set] =
      XmCreatePushButton(widget_array[stat_form],
			 "status_set_button",NULL,0);
    widget_array[stat_can] =
      XmCreatePushButton(widget_array[stat_form],
			 "status_cancel_button",NULL,0);

    XtManageChild(w_status_sam);
    XtManageChild(w_status_dpt);
    XtManageChild(w_herts_label);
    XtManageChild(w_dpoint_label);
    XtManageChild(widget_array[stat_sam]);
    XtManageChild(widget_array[stat_dpt]);
    XtManageChild(widget_array[stat_set]);
    XtManageChild(widget_array[stat_can]);

    XtAddCallback(widget_array[stat_sam], XmNactivateCallback,
		  (XtCallbackProc)status_set, (XtPointer)&s_freq);
    XtAddCallback(widget_array[stat_dpt], XmNactivateCallback,
		  (XtCallbackProc)status_set, (XtPointer)&s_dpt);
    XtAddCallback(widget_array[stat_set], XmNactivateCallback,
		  (XtCallbackProc)status_set, (XtPointer)&s_set);
    XtAddCallback(widget_array[stat_can], XmNactivateCallback,
		  (XtCallbackProc)status_set, (XtPointer)&s_can);
  }

  if ( widget != NULL )
    XtManageChild( widget_array[stat_form] );

  sprintf( freq , "%.3f" ,sampling_frequency );
  sprintf( point , "%d" , data_points );

  setValue( widget_array[stat_sam] , freq );
  setValue( widget_array[stat_dpt] , point );
}


void status_set( w , tag , callback_data )
     Widget w;
     int   *tag;
     XmAnyCallbackStruct *callback_data;
{
  char  *freq;
  char  *point;

  if ( *tag >= 1 ) {

    freq =  getValue( widget_array[stat_sam] );
    point = getValue( widget_array[stat_dpt] );

    sscanf( freq  , "%g" , &sampling_frequency );
    sscanf( point , "%d" , &data_points        );

    free(freq);
    free(point);

    if ( sampling_frequency <= 0.0 ) sampling_frequency = syscom.sam_freq;
    if ( data_points        <= 0   ) data_points        = syscom.buff_leng;

  }

  syscom.sam_freq = sampling_frequency;
  syscom.buff_leng = data_points; 

  if ( *tag == 1 ) {
    before_sam = sampling_frequency;
    before_dpt = data_points;
  } else if ( *tag == 0 ) {
    sampling_frequency = before_sam;
    data_points        = before_dpt;
  }

  syscom.sam_freq    = sampling_frequency;
  syscom.buff_leng   = data_points;

  set_freq();
  set_dpt( syscom.buff_leng );

  if ( *tag < 2 )
    XtUnmanageChild( widget_array[stat_form] );
}

void ibuf_set( w , tag , callback_data )
     Widget  w;
     int    *tag;
     XmAnyCallbackStruct *callback_data;
{
  char *param = NULL;
  char value[20];

  int b_ibuf_num = ibuf_num;

  if ( w != NULL ) {
    if        ( w == widget_array[inpu_dec] ) {
      if ( ibuf_num > 0 )
	ibuf_num--;
    } else if ( w == widget_array[inpu_num] ) {
      param = getValue( widget_array[ inpu_num ] );
      sscanf( param , "%d" , &ibuf_num );
      free(param);
      if ( ibuf_num > ibuf_num_max )
	ibuf_num = ibuf_num_max;
    } else if ( w == widget_array[inpu_inc] ) {
      if ( ibuf_num < ibuf_num_max )
	ibuf_num++;
    }
    
    if ( ibuf_num != b_ibuf_num ) {
      sprintf( value , "%04d" , ibuf_num );
      setValue( widget_array[ inpu_num ] , value );
    }
  }
}

void obuf_set( w , tag , callback_data )
     Widget  w;
     int    *tag;
     XmAnyCallbackStruct *callback_data;
{
  char *param;
  char value[20];

  if ( w != NULL ) {
    if        ( w == widget_array[outp_dec] ) {
      if ( obuf_num > 0 )
	obuf_num--;
    } else if ( w == widget_array[outp_num] ) {
      param = getValue( widget_array[ outp_num ] );
      sscanf( param , "%d" , &obuf_num );
      free(param);
    } else if ( w == widget_array[outp_inc] ) {
      obuf_num++;
    }

    sprintf( value , "%04d" , obuf_num );
    setValue( widget_array[ outp_num ] , value );
  }
}

void creat_option_box( widget, tag , callback_data )
     Widget widget;
     int   *tag;
     XmAnyCallbackStruct *callback_data;
{
  static int o_set = 1, o_can = 0;

  static Widget w_opt_g1_form,   w_opt_g2_form;
  static Widget w_opt_sepa_vert, w_opt_sepa_horiz;
  static Widget w_opt_g1_label, w_opt_g1_x_mode;
  static Widget w_opt_g1_xscale_label, w_opt_g1_x_scale;
  static Widget w_opt_g1_yscale_label, w_opt_g1_y_scale;
  static Widget w_opt_g2_label, w_opt_g2_x_mode;
  static Widget w_opt_g2_xscale_label, w_opt_g2_x_scale;
  static Widget w_opt_g2_yscale_label, w_opt_g2_y_scale;

  if ( widget_array[opt_form] == NULL ) {
    widget_array[opt_form] =
      XmCreateFormDialog(isopmain, "option_set_form", NULL,0);

    w_opt_g1_form = XmCreateForm(widget_array[opt_form],"opt_g1_form",NULL,0);
    w_opt_sepa_horiz=XmCreateSeparator(widget_array[opt_form],"opt_sepa_horiz",
				       NULL,0);
    w_opt_sepa_vert=XmCreateSeparator(widget_array[opt_form],"opt_sepa_vert",
				       NULL,0);
    w_opt_g2_form = XmCreateForm(widget_array[opt_form],"opt_g2_form",NULL,0);
    widget_array[opt_set]=
      XmCreatePushButton(widget_array[opt_form],"option_set_button",NULL,0);
    widget_array[opt_can]=
      XmCreatePushButton(widget_array[opt_form],"option_cancel_button",NULL,0);

    XtManageChild(w_opt_g1_form);
    XtManageChild(w_opt_g2_form);
    XtManageChild(w_opt_sepa_vert);
    XtManageChild(w_opt_sepa_horiz);
    XtManageChild(widget_array[opt_set]);
    XtManageChild(widget_array[opt_can]);

    /* Graph1 */
    w_opt_g1_label  = XmCreateLabel(w_opt_g1_form,"opt_g1_label",NULL,0);
    w_opt_g1_x_mode = XmCreateRadioBox(w_opt_g1_form,"opt_g1_x_mode",NULL,0);
    widget_array[g1_x_power] = XmCreateToggleButton(w_opt_g1_x_mode,
						    "g1_x_power", NULL,0);
    widget_array[g1_x_norm] = XmCreateToggleButton(w_opt_g1_x_mode,
						    "g1_x_norm", NULL,0);
    widget_array[g1_x_data] = XmCreateToggleButton(w_opt_g1_x_mode,
						    "g1_x_data", NULL,0);

    w_opt_g1_xscale_label =
      XmCreateLabel(w_opt_g1_form,"opt_g1_xscale_label",NULL,0);
    w_opt_g1_x_scale = XmCreateRadioBox(w_opt_g1_form,"opt_g1_x_scale",NULL,0);

    widget_array[g1_x_liner] = XmCreateToggleButton(w_opt_g1_x_scale,
						    "g1_x_liner", NULL,0);
    widget_array[g1_x_log]   = XmCreateToggleButton(w_opt_g1_x_scale,
						    "g1_x_log", NULL,0);
    w_opt_g1_yscale_label =
      XmCreateLabel(w_opt_g1_form,"opt_g1_yscale_label",NULL,0);
    w_opt_g1_y_scale = XmCreateRadioBox(w_opt_g1_form,"opt_g1_y_scale",NULL,0);

    widget_array[g1_y_liner] = XmCreateToggleButton(w_opt_g1_y_scale,
						    "g1_y_liner", NULL,0);
    widget_array[g1_y_log]   = XmCreateToggleButton(w_opt_g1_y_scale,
						    "g1_y_log", NULL,0);

    XtManageChild(w_opt_g1_label);
    XtManageChild(w_opt_g1_x_mode);
    XtManageChild(widget_array[g1_x_power]);
    XtManageChild(widget_array[g1_x_norm]);
    XtManageChild(widget_array[g1_x_data]);
    XtManageChild(w_opt_g1_xscale_label);
    XtManageChild(w_opt_g1_x_scale);
    XtManageChild(widget_array[g1_x_liner]);
    XtManageChild(widget_array[g1_x_log]);
    XtManageChild(w_opt_g1_yscale_label);
    XtManageChild(w_opt_g1_y_scale);
    XtManageChild(widget_array[g1_y_liner]);
    XtManageChild(widget_array[g1_y_log]);

    /* Graph2 */
    w_opt_g2_label  = XmCreateLabel(w_opt_g2_form,"opt_g2_label",NULL,0);
    w_opt_g2_x_mode = XmCreateRadioBox(w_opt_g2_form,"opt_g2_x_mode",NULL,0);
    widget_array[g2_x_power] = XmCreateToggleButton(w_opt_g2_x_mode,
						    "g2_x_power", NULL,0);
    widget_array[g2_x_norm] = XmCreateToggleButton(w_opt_g2_x_mode,
						    "g2_x_norm", NULL,0);
    widget_array[g2_x_data] = XmCreateToggleButton(w_opt_g2_x_mode,
						    "g2_x_data", NULL,0);

    w_opt_g2_xscale_label =
      XmCreateLabel(w_opt_g2_form,"opt_g2_xscale_label",NULL,0);
    w_opt_g2_x_scale = XmCreateRadioBox(w_opt_g2_form,"opt_g2_x_scale",NULL,0);

    widget_array[g2_x_liner] = XmCreateToggleButton(w_opt_g2_x_scale,
						    "g2_x_liner", NULL,0);
    widget_array[g2_x_log]   = XmCreateToggleButton(w_opt_g2_x_scale,
						    "g2_x_log", NULL,0);
    w_opt_g2_yscale_label =
      XmCreateLabel(w_opt_g2_form,"opt_g2_yscale_label",NULL,0);
    w_opt_g2_y_scale = XmCreateRadioBox(w_opt_g2_form,"opt_g2_y_scale",NULL,0);

    widget_array[g2_y_liner] = XmCreateToggleButton(w_opt_g2_y_scale,
						    "g2_y_liner", NULL,0);
    widget_array[g2_y_log]   = XmCreateToggleButton(w_opt_g2_y_scale,
						    "g2_y_log", NULL,0);

    XtManageChild(w_opt_g2_label);
    XtManageChild(w_opt_g2_x_mode);
    XtManageChild(widget_array[g2_x_power]);
    XtManageChild(widget_array[g2_x_norm]);
    XtManageChild(widget_array[g2_x_data]);
    XtManageChild(w_opt_g2_xscale_label);
    XtManageChild(w_opt_g2_x_scale);
    XtManageChild(widget_array[g2_x_liner]);
    XtManageChild(widget_array[g2_x_log]);
    XtManageChild(w_opt_g2_yscale_label);
    XtManageChild(w_opt_g2_y_scale);
    XtManageChild(widget_array[g2_y_liner]);
    XtManageChild(widget_array[g2_y_log]);

    /* Callbacks */
    XtAddCallback(widget_array[opt_set], XmNactivateCallback,
		  (XtCallbackProc)option_set, (XtPointer)&o_set);
    XtAddCallback(widget_array[opt_can], XmNactivateCallback,
		  (XtCallbackProc)option_set, (XtPointer)&o_can);
  }
  if ( widget != NULL ) {
    XtManageChild( widget_array[opt_form] );

    b_pftc1   = getState( widget_array[g1_x_power] );
    b_normal1 = getState( widget_array[g1_x_norm]  );
    b_x1liner = getState( widget_array[g1_x_liner] );
    b_y1liner = getState( widget_array[g1_y_liner] );
    b_pftc2   = getState( widget_array[g2_x_power] );
    b_normal2 = getState( widget_array[g2_x_norm]  );
    b_x2liner = getState( widget_array[g2_x_liner] );
    b_y2liner = getState( widget_array[g2_y_liner] );
  }
}

void option_set( w , tag , callback_data )
     Widget w;
     int   *tag;
     XmAnyCallbackStruct *callback_data;
{
  int flag1, flag2;
  int pftc1,pftc2,normal1,normal2,point1,point2;
  int x1liner,x2liner,x1log,x2log,y1liner, y2liner, y1log,y2log;
  int canvas;

  if ( w!=NULL &&(w==widget_array[ opt_set ] || w==widget_array[ opt_can ] ))
    XtUnmanageChild( widget_array[opt_form] );

  if ( w != NULL && w == widget_array[ opt_set ] ) {
    pftc1   = getState( widget_array[g1_x_power] );
    normal1 = getState( widget_array[g1_x_norm]  );
    x1liner = getState( widget_array[g1_x_liner] );
    y1liner = getState( widget_array[g1_y_liner] );
    pftc2   = getState( widget_array[g2_x_power] );
    normal2 = getState( widget_array[g2_x_norm]  );
    x2liner = getState( widget_array[g2_x_liner] );
    y2liner = getState( widget_array[g2_y_liner] );

    g1_x_scale = ( x1liner == TRUE ) ? G_LINER : G_LOG;
    g1_y_scale = ( y1liner == TRUE ) ? G_LINER : G_LOG;
    g2_x_scale = ( x2liner == TRUE ) ? G_LINER : G_LOG;
    g2_y_scale = ( y2liner == TRUE ) ? G_LINER : G_LOG;

    if ( pftc1   == TRUE && normal_mode == G_TIME ) {
      g1_mode = G_FREQ;
      g1_opt  = G_PFTC;
    } else {
      g1_opt  = G_NORM;
      if ( normal1 == TRUE || pftc1 == TRUE )
	g1_mode = normal_mode;
      else
	g1_mode = G_DATA;
    }

    if ( pftc2   == TRUE && normal_mode == G_TIME ) {
      g2_mode = G_FREQ;
      g2_opt  = G_PFTC;
    } else {
      g2_opt  = G_NORM;
      if ( normal2 == TRUE || pftc2 == TRUE )
	g2_mode = normal_mode;
      else
	g2_mode = G_DATA;
    }
  }

  if ( g1_opt == G_PFTC && normal_mode == G_FREQ ) {
    g1_opt = G_NORM;
    g1_mode = normal_mode;
  }
  if ( g2_opt == G_PFTC && normal_mode == G_FREQ ) {
    g2_opt = G_NORM;
    g2_mode = normal_mode;
  }

  pftc1   = ( g1_opt == G_PFTC && normal_mode != G_FREQ ) ? TRUE : FALSE;
  pftc2   = ( g2_opt == G_PFTC && normal_mode != G_FREQ ) ? TRUE : FALSE;
  normal1 = ( g1_opt == G_NORM && g1_mode != G_DATA ) 
    ? TRUE : FALSE;
  normal2 = ( g2_opt == G_NORM && g2_mode != G_DATA )
    ? TRUE : FALSE;
  point1  = ( g1_mode == G_DATA ) ? TRUE : FALSE;
  point2  = ( g2_mode == G_DATA ) ? TRUE : FALSE;
  x1liner = ( g1_x_scale == G_LINER ) ? TRUE : FALSE ;
  y1liner = ( g1_y_scale == G_LINER ) ? TRUE : FALSE ;
  x1log   = ( g1_x_scale == G_LOG   ) ? TRUE : FALSE ;
  y1log   = ( g1_y_scale == G_LOG   ) ? TRUE : FALSE ;
  x2liner = ( g2_x_scale == G_LINER ) ? TRUE : FALSE ;
  y2liner = ( g2_y_scale == G_LINER ) ? TRUE : FALSE ;
  x2log   = ( g2_x_scale == G_LOG   ) ? TRUE : FALSE ;
  y2log   = ( g2_y_scale == G_LOG   ) ? TRUE : FALSE ;

  setState( widget_array[ g1_x_power ] , pftc1   );
  setState( widget_array[ g1_x_norm  ] , normal1 );
  setState( widget_array[ g1_x_data  ] , point1  );
  setState( widget_array[ g1_x_liner ] , x1liner );
  setState( widget_array[ g1_x_log   ] , x1log   );
  setState( widget_array[ g1_y_liner ] , y1liner );
  setState( widget_array[ g1_y_log   ] , y1log   );

  setState( widget_array[ g2_x_power ] , pftc2   );
  setState( widget_array[ g2_x_norm  ] , normal2 );
  setState( widget_array[ g2_x_data  ] , point2  );
  setState( widget_array[ g2_x_liner ] , x2liner );
  setState( widget_array[ g2_x_log   ] , x2log   );
  setState( widget_array[ g2_y_liner ] , y2liner );
  setState( widget_array[ g2_y_log   ] , y2log   );

  flag1 = (b_pftc1 != pftc1 || b_normal1 != normal1 ||
	   b_x1liner != x1liner || b_y1liner != y1liner );
  flag2 = (b_pftc2 != pftc2 || b_normal2 != normal2 ||
	   b_x2liner != x2liner || b_y2liner != y2liner );

  b_pftc1   = pftc1;
  b_normal1 = normal1;
  b_x1liner = x1liner;
  b_y1liner = y1liner;
  b_pftc2   = pftc2;
  b_normal2 = normal2;
  b_x2liner = x2liner;
  b_y2liner = y2liner;

  if ( w != NULL && w == widget_array[ opt_set ] ) {
    if ( flag1 ) {
      canvas = g1_canvas;
      redraw_proc( widget_array[ g1_canvas ] , &canvas , NULL );
    }
    if ( flag2 ) {
      canvas = g2_canvas;
      redraw_proc( widget_array[ g2_canvas ] , &canvas , NULL );
    }
  }

}

void fft2( x, y, l, ainv )
     int l;
     double x[], y[], ainv;
{
  int li, lmx, lm, lo, lix, j1, j2, j, i, k, nv2, npm2, np;
  double arg, s, c, t1, t2, dm, tmp, w;


  np = 1<<l;
  lmx = np;
  for ( lo =0; lo < l; lo++ ) {
    lix = lmx;
    lmx /= 2;
    w = PAI / (float)lmx;
    for ( lm = 0; lm < lmx; lm++ ) {
      arg = (float)lm * w;
      c = cos(arg);
      s = ainv*sin(arg);
      i = lm - lix;
      for ( li = lix; li <= np; li += lix ) {
	j1 = li + i;
	j2 = j1 + lmx;
	t1 = x[j1] - x[j2];
	t2 = y[j1] - y[j2];
	x[j1] += x[j2];
	y[j1] += y[j2];
	x[j2] = c*t1-s*t2;
	y[j2] = c*t2+s*t1;
      }
    }
  }
  j = 0;
  nv2 = np>>1;
  npm2 = np-2;
  for ( i = 0; i <= npm2; i++ ) {
    if ( i < j ) {
      tmp = x[i]; x[i] = x[j]; x[j] = tmp;
      tmp = y[i]; y[i] = y[j]; y[j] = tmp;
    }
    k = nv2;
    while ( k <= j ) {
      j -= k;
      k /= 2;
    }
    j += k;
  }
  if ( ainv > 0.0 ) {
    dm = np;
    for ( i = 0; i < np; i++ ) {
      x[i] /= dm;
      y[i] /= dm;
    }
  }
}

void quit_proc()
{
  if ( modified_flag > 0 || made_data > 0 ) {
    if ( widget_array[quit_dlg] == NULL ) {
      Widget helpbutton;

      widget_array[quit_dlg] =
	XmCreateQuestionDialog(isopmain, "quit_dlg", NULL, 0);
      helpbutton = XmMessageBoxGetChild(widget_array[quit_dlg],
					XmDIALOG_HELP_BUTTON);
      XtUnmanageChild(helpbutton);

      XtAddCallback(widget_array[quit_dlg], XmNokCallback,
		    (XtCallbackProc)quit_all, NULL);
    }
    XtManageChild(widget_array[quit_dlg]);
  } else
    quit_all(NULL, NULL, NULL);
}

void file_select( w , tag , callback_data )
     Widget w;
     int   *tag;
     XmAnyCallbackStruct *callback_data;
{
  static Widget FileSelectionInput     = NULL;
  static Widget FileSelectionOutput    = NULL;
  static Widget FileSelection          = NULL;
  static Widget FSIB = NULL;
  static Widget FSOB = NULL;
  static Widget FSB  = NULL;
  static Widget Field = NULL;
  static int f_sel4 = 4, f_sel5 = 5;

  XmString label;
  Arg arg[2];
  int n, number;
  char value[40], *str = NULL, fname[80], *tmp_name;

  number = ( tag != NULL ) ? *tag : 0 ;

  if ( *tag > 3 ) {
    if ( w == FileSelectionInput ) {
      number = 1;
      FSB = FSIB;
    } else if ( w == FileSelectionOutput ) {
      number = 2;
      FSB = FSOB;
    }
  } else {
    FSB = w;
  }

  switch( number ) {
  case 1:
    FileSelection = FileSelectionInput;
    strcpy( value, "Input File Selection Box" );
    break;
  case 2:
    FileSelection = FileSelectionOutput;
    strcpy( value, "Output File Selection Box" );
    break;
  }

  if ( *tag < 4 ) {
    if ( FileSelection == NULL ) {
      n = 0;
      label = XmStringCreate( value , XmSTRING_DEFAULT_CHARSET );
      XtSetArg( arg[n] , XmNdialogTitle , label ); n++;

      FileSelection =
	XmCreateFileSelectionDialog(isopmain, "file_select_window", arg, n);
      XmStringFree( label );

      XtAddCallback(FileSelection, XmNokCallback,
		    (XtCallbackProc)file_select, (XtPointer)&f_sel4);
      XtAddCallback(FileSelection, XmNcancelCallback,
		    (XtCallbackProc)file_select, (XtPointer)&f_sel5);

      switch( number ) {
      case 1:
	FileSelectionInput = FileSelection;
	FSIB = w;
	break;
      case 2:
	FileSelectionOutput = FileSelection;
	FSOB = w;
	break;
      }
    }
    XtManageChild(FileSelection);
  } else {
    if ( *tag == 4 ) {
      Field = XmFileSelectionBoxGetChild( FileSelection, XmDIALOG_TEXT );
      str = XmTextGetString( Field );
    }

    XtUnmanageChild( FileSelection );

    if ( *tag == 4 ) {
      if ( str != NULL ) {
	switch( number ) {
	case 1:
	  strcpy( input_file_name, str );
	  break;
	case 2:
	  strcpy( output_file_name, str );
	  break;
	}
	tmp_name = strtok( str, "/" );
	if ( tmp_name != NULL )
	  strcpy(fname,tmp_name);
	while( ( tmp_name = strtok( NULL, "/" ) ) != NULL ) {
	  strcpy(fname,tmp_name);
	}
	setLabel( FSB, fname );
	XtFree( str );

	fs_exec_list(number);
      }
    }
  }
}

int fs_exec_list(number)
     int number;
{
  extern int execMode;

  switch(execMode) {
  case CUTDT:
    switch(number) {
    case 1:
      in_cut_data(NULL, NULL, NULL);
      break;
    case 2:
      cut_outbuf_disp();
      break;
    }
    break;
  }
  return 0;
}

void set_write_type( w , tag , callback_data )
     Widget w;
     int   *tag;
     XmAnyCallbackStruct *callback_data;
{
  switch ( *tag ) {
  case 1:
    strcpy( obuf_format, "new" );
    break;
  case 2:
    strcpy( obuf_format, "old" );
    break;
  case 3:
    obuf_byte = 4;
    break;
  case 4:
    obuf_byte = 2;
    break;
  case 5:
    obuf_byte = 8;
    break;
  }    
  write_type(obuf_format, "BigEndian", obuf_byte);
} 
