#ifndef _ISOP_RESOURCE_H_
#define _ISOP_RESOURCE_H_

static String resources[] = {
  "XCUT*foreground:                black",
  "XCUT*background:                #ddddff",
  "XCUT*XmTextField.foreground:    black",
  "XCUT*XmTextField.background:    #ccccee",
  "XCUT*XmArrowButton.foreground:  #eeeeff",
  "XCUT*menu_buttons*foreground:   black",
  "XCUT*menu_buttons*background:   #ccccff",
  "XCUT*XmPushButton.foreground:   black",
  "XCUT*XmPushButton.background:   #bbbbdd",

  "*inputMethod: none",
  "*fontList: -adobe-helvetica-medium-r-*--14-*-*-*-*-*;-*--14-*-*:",
  "*XmTextField.fontList: -*-fixed-medium-*--14-*-*-*:",
  "*title1.fontList: -adobe-times-bold-r-*--14-*-*-*;-*-medium-*--14-*:",
  "*title2.fontList: -adobe-times-bold-r-*--14-*-*-*;-*-medium-*--14-*:",

/*  sepa2 : XmSeparator */
  "*sepa2.orientation:       XmVERTICAL",
  "*sepa2.topAttachment:     XmATTACH_WIDGET",
  "*sepa2.topWidget:         menu_buttons",
  "*sepa2.rightAttachment:   XmATTACH_WIDGET",
  "*sepa2.rightWidget:       buffers_form",
  "*sepa2.bottomAttachment:  XmATTACH_FORM",
  "*sepa2.bottomOffset:      0",

/* graphical_form : XmForm (k_graph_form) */
  "*graphical_form.topAttachment:    XmATTACH_WIDGET",
  "*graphical_form.topWidget:        menu_buttons",
  "*graphical_form.bottomAttachment: XmATTACH_FORM",
  "*graphical_form.bottomOffset:     0",
  "*graphical_form.leftAttachment:   XmATTACH_FORM",
  "*graphical_form.leftOffset:       0",
  "*graphical_form.rightAttachment:  XmATTACH_FORM",
  "*graphical_form.rightOffset:      200",

/* sepa1 : XmSeparator (child of graphical_form) */
  "*sepa1.topAttachment:     XmATTACH_WIDGET",
  "*sepa1.topWidget:         com_name",
  "*sepa1.leftAttachment:    XmATTACH_FORM",
  "*sepa1.leftOffset:        0",
  "*sepa1.rightAttachment:   XmATTACH_FORM",
  "*sepa1.rightOffset:       0",

/* figure : XmForm (child of graphical_form,
   and parent of graph1_form, graph_sepa, and graph2_form */
  "*figure.topAttachment:     XmATTACH_WIDGET",
  "*figure.topWidget:         sepa1",
  "*figure.leftAttachment:    XmATTACH_FORM",
  "*figure.leftOffset:        0",
  "*figure.rightAttachment:   XmATTACH_FORM",
  "*figure.rightOffset:       0",
  "*figure.bottomAttachment:  XmATTACH_FORM",
  "*figure.bottomOffset:      0",

/* graph_sepa : XmSeparator (child of figure) */
  "*graph_sepa.orientation:      XmHORIZONTAL",
  "*graph_sepa.topAttachment:    XmATTACH_POSITION",
  "*graph_sepa.topPosition:      50",
  "*graph_sepa.leftAttachment:   XmATTACH_FORM",
  "*graph_sepa.leftOffset:       0",
  "*graph_sepa.rightAttachment:  XmATTACH_FORM",
  "*graph_sepa.rightOffset:      0",

/* menu_buttons : XmMenuBar */
/* parent of edit_button, status_button, option_button, and quit_button */
  "*menu_buttons.leftAttachment:   XmATTACH_FORM",
  "*menu_buttons.leftOffset:       0",
  "*menu_buttons.rightAttachment:  XmATTACH_POSITION",
  "*menu_buttons.rightPosition:    100",
  "*menu_buttons.borderWidth:      0",
  "*menu_buttons.orientation:      XmHORIZONTAL",
  "*menu_buttons.packing:          XmPACK_COLUMN",
  "*menu_buttons.spacing:          10",
  "*menu_buttons.entryAlignment:   XmALIGNMENT_CENTER",

/* status_button : XmCascadeButton */
  "*status_button.labelString:     Status",
  "*status_button.mnemonic:        S",

/* option_button : XmCascadeButton */
  "*option_button.labelString:     Option",
  "*option_button.mnemonic:        O",

/* quit_button : XmCascadeButton */
  "*quit_button.labelString:       Quit",
  "*quit_button.mnemonic:          Q",

/* com_name : XmForm */
/* child of graphical_form */
/* parent of cmd_label, command_name, dpt_label, dpoint, sam_label,
   and sampling */
  "*com_name.topAttachment:        XmATTACH_FORM",
  "*com_name.topOffset:            0",
  "*com_name.leftAttachment:       XmATTACH_FORM",
  "*com_name.leftOffset:           0",
  "*com_name.rightAttachment:      XmATTACH_FORM",
  "*com_name.rightOffset:          0",
  "*com_name*marginWidth:          5",

/* cmd_label : XmLabel */
  "*cmd_label.labelString:          Command:",
  "*cmd_label.leftAttachment:       XmATTACH_FORM",
  "*cmd_label.leftOffset:           0",

/* command_name : XmLabel */
  "*command_name.leftAttachment:   XmATTACH_WIDGET",
  "*command_name.leftWidget:       cmd_label",
  "*command_name.labelString:      Nothing",

/* dpt_label : XmLabel */
  "*dpt_label.rightAttachment:     XmATTACH_WIDGET",
  "*dpt_label.rightWidget:         dpoint",
  "*dpt_label.labelString:         DPT:",

/* dpoint : XmLabel */
  "*dpoint.rightAttachment:        XmATTACH_WIDGET",
  "*dpoint.rightWidget:            sam_label",
  "*dpoint.labelString:            1024",

/* sam_label : XmLabel */
  "*sam_label.rightAttachment:     XmATTACH_WIDGET",
  "*sam_label.rightWidget:         sampling",
  "*sam_label.labelString:         SF:",

/* sampling : XmLabel */
  "*sampling.rightAttachment:      XmATTACH_FORM",
  "*sampling.rightOffset:          0",
  "*sampling.labelString:          0.0000",

/* quit_dlg : XmWarningDialog */
  "*quit_dlg.messageString:        Quit ISPP OPERATOR, OK?",
  "*quit_dlg.okLabelString:        Yes",
  "*quit_dlg.cancelLabelString:    No",
  "*quit_dlg.helpLabelString:",
  "*quit_dlg.dialogTitle:          WARNING",
  "*quit_dlg.noResize:             true",

/* exit_dlg : XmWarningDialog */
  "*exit_dlg.messageString:        Data was modified.\\nWrite data, or exit ?",
  "*exit_dlg.okLabelString:        Write",
  "*exit_dlg.cancelLabelString:    Exit",
  "*exit_dlg.helpLabelString:      ",
  "*exit_dlg.dialogTitle:          WARNING",
  "*exit_dlg.noResize:             true",

/* write_dlg : XmWarningDialog */
  "*write_dlg.messageString: Output File is already exist.\\nOver-write OK ?",
  "*write_dlg.okLabelString:       Yes",
  "*write_dlg.cacelLabelString:    No",
  "*write_dlg.helpLabelString:     ",
  "*write_dlg.dialogTitle:         WARNING",
  "*write_dlg.noResize:            true",

/* status_set_form : XmFormDialog */
/* parent of status_sam, sam_freq_input, hertz_label, status_dpt,
   dat_point_input, dpoint_label, status_set_button, status_cancel_button */
  "*status_set_form.noResize:      true",
  "*status_set_form.width:         300",
  "*status_set_form.dialogTitle:   Status Dialog",

/* status_sam : XmLabel */
  "*status_sam.height:             30",
  "*status_sam.topAttachment:      XmATTACH_FORM",
  "*status_sam.topOffset:          0",
  "*status_sam.leftAttachment:     XmATTACH_FORM",
  "*status_sam.leftOffset:         0",
  "*status_sam.rightAttachment:    XmATTACH_POSITION",
  "*status_sam.rightPosition:      50",
  "*status_sam.labelString:        Sampling Frequency",

/* sam_freq_input : XmTextField */
  "*sam_freq_input.height:           30",
  "*sam_freq_input.topAttachment:    XmATTACH_FORM",
  "*sam_freq_input.topOffset:        0",
  "*sam_freq_input.leftAttachment:   XmATTACH_POSITION",
  "*sam_freq_input.leftPosition:     50",
  "*sam_freq_input.rightAttachment:  XmATTACH_POSITION",
  "*sam_freq_input.rightPosition:    85",
  "*sam_freq_input.marginHeight:     0",
  "*sam_freq_input.value:            0.000",

/* hertz_label : XmLabel */
  "*herts_label.height:              30",
  "*herts_label.topAttachment:       XmATTACH_FORM",
  "*herts_label.topOffset:           0",
  "*herts_label.leftAttachment:      XmATTACH_POSITION",
  "*herts_label.leftPosition:        85",
  "*herts_label.rightAttachment:     XmATTACH_FORM",
  "*herts_label.rightOffset:         0",
  "*herts_label.labelString:         Hz",

/* status_dpt : XmLabel */
  "*status_dpt.height:               30",
  "*status_dpt.topAttachment:        XmATTACH_FORM",
  "*status_dpt.topOffset:            30",
  "*status_dpt.leftAttachment:       XmATTACH_FORM",
  "*status_dpt.leftOffset:           0",
  "*status_dpt.rightAttachment:      XmATTACH_POSITION",
  "*status_dpt.rightPosition:        50",
  "*status_dpt.labelString:          Data Points",

/* dat_point_input : XmTextField */
  "*dat_point_input.height:            30",
  "*dat_point_input.topAttachment:     XmATTACH_FORM",
  "*dat_point_input.topOffset:         30",
  "*dat_point_input.leftAttachment:    XmATTACH_POSITION",
  "*dat_point_input.leftPosition:      50",
  "*dat_point_input.rightAttachment:   XmATTACH_POSITION",
  "*dat_point_input.rightPosition:     85",
  "*dat_point_input.marginHeight:      0",
  "*dat_point_input.value:             0",

/* dpoint_label : XmLabel */
  "*dpoint_label.height:                30",
  "*dpoint_label.topAttachment:         XmATTACH_FORM",
  "*dpoint_label.topOffset:             30",
  "*dpoint_label.leftAttachment:        XmATTACH_POSITION",
  "*dpoint_label.leftPosition:          85",
  "*dpoint_label.rightAttachment:       XmATTACH_FORM",
  "*dpoint_label.rightOffset:           0",
  "*dpoint_label.labelString:           pts",

/* status_set_button : XmPushButton */
  "*status_set_button.topAttachment:    XmATTACH_FORM",
  "*status_set_button.topOffset:        60",
  "*status_set_button.bottomAttachment: XmATTACH_FORM",
  "*status_set_button.bottomOffset:     0",
  "*status_set_button.leftAttachment:   XmATTACH_POSITION",
  "*status_set_button.leftPosition:     50",
  "*status_set_button.rightAttachment:  XmATTACH_POSITION",
  "*status_set_button.rightPosition:    75",
  "*status_set_button.labelString:      OK.",

/* status_cancel_button : XmPushButton */
  "*status_cancel_button.topAttachment:    XmATTACH_FORM",
  "*status_cancel_button.topOffset:        60",
  "*status_cancel_button.bottomAttachment: XmATTACH_FORM",
  "*status_cancel_button.bottomOffset:     0",
  "*status_cancel_button.leftAttachment:   XmATTACH_POSITION",
  "*status_cancel_button.leftPosition:     75",
  "*status_cancel_button.rightAttachment:  XmATTACH_FORM",
  "*status_cancel_button.rightOffset:      0",
  "*status_cancel_button.labelString:      Cancel",

/* option_set_form : XmFormDialog */
/* parent of opt_g1_form, opt_sepa_vert, opt_g2_form, opt_sepa_horiz,
   option_set_button, and option_cancel_button */
  "*option_set_form.noResize:              true",
  "*option_set_form.dialogTitle:           Option Dialog",

/* opt_g1_form : XmForm */
/* parent of opt_g1_label, opt_g1_xscale_label, opt_g1_yscale_label,
   opt_g1_x_mode, opt_g1_x_scale, and opt_g1_y_scale */
  "*opt_g1_form.topAttachment:             XmATTACH_FORM",
  "*opt_g1_form.topOffset:                 0",
  "*opt_g1_form.leftAttachment:            XmATTACH_FORM",
  "*opt_g1_form.leftOffset:                0",
  "*opt_g1_form.rightAttachment:           XmATTACH_POSITION",
  "*opt_g1_form.rightPosition:             50",

/* opt_sepa_vert : XmSeparator */
  "*opt_sepa_vert.topAttachment:           XmATTACH_FORM",
  "*opt_sepa_vert.topOffset:               0",
  "*opt_sepa_vert.leftAttachment:          XmATTACH_WIDGET",
  "*opt_sepa_vert.leftWidget:              opt_g1_form",
  "*opt_sepa_vert.bottomAttachment:        XmATTACH_WIDGET",
  "*opt_sepa_vert.bottomWidget:            opt_sepa_horiz",
  "*opt_sepa_vert.orientation:             XmVERTICAL",

/* opt_g2_form : XmForm */
/* parent of opt_g2_label, opt_g2_xscale_label, opt_g2_yscale_label,
   opt_g2_x_mode, opt_g2_x_scale, and opt_g2_y_scale */
  "*opt_g2_form.topAttachment:             XmATTACH_FORM",
  "*opt_g2_form.topOffset:                 0",
  "*opt_g2_form.leftAttachment:            XmATTACH_POSITION",
  "*opt_g2_form.leftPosition:              50",
  "*opt_g2_form.rightAttachment:           XmATTACH_FORM",
  "*opt_g2_form.rightOffset:               0",

/* opt_sepa_horiz : XmSeparator */
  "*opt_sepa_horiz.topAttachment:          XmATTACH_WIDGET",
  "*opt_sepa_horiz.topWidget:              opt_g1_form",
  "*opt_sepa_horiz.leftAttachment:         XmATTACH_FORM",
  "*opt_sepa_horiz.leftOffset:             0",
  "*opt_sepa_horiz.rightAttachment:        XmATTACH_FORM",
  "*opt_sepa_horiz.rightOffset:            0",
  "*opt_sepa_horiz.orientation:            XmHORIZONTAL",

/* option_set_button : XmPushButton */
  "*option_set_button.width:               50",
  "*option_set_button.height:              30",
  "*option_set_button.topAttachment:       XmATTACH_WIDGET",
  "*option_set_button.topWidget:           opt_sepa_horiz",
  "*option_set_button.leftAttachment:      XmATTACH_FORM",
  "*option_set_button.leftOffset:          0",
  "*option_set_button.rightAttachment:     XmATTACH_POSITION",
  "*option_set_button.rightPosition:       50",
  "*option_set_button.labelString:         OK.",

/* option_cancel_button : XmPushButton */
  "*option_cancel_button.width:            50",
  "*option_cancel_button.height:           30",
  "*option_cancel_button.topAttachment:    XmATTACH_WIDGET",
  "*option_cancel_button.topWidget:        opt_sepa_horiz",
  "*option_cancel_button.leftAttachment:   XmATTACH_POSITION",
  "*option_cancel_button.leftPosition:     50",
  "*option_cancel_button.rightAttachment:  XmATTACH_FORM",
  "*option_cancel_button.rightOffset:      0",
  "*option_cancel_button.labelString:      Cancel",

/* opt_g1_label : XmLabel */
  "*opt_g1_label.width:                    100",
  "*opt_g1_label.topAttachment:            XmATTACH_FORM",
  "*opt_g1_label.topOffset:                0",
  "*opt_g1_label.leftAttachment:           XmATTACH_FORM",
  "*opt_g1_label.leftOffset:               0",
  "*opt_g1_label.labelString:              Graph1\\n DisplayMode",

/* opt_g1_x_mode : XmRadioBox */
/* parent of g1_x_power, g1_x_norm, and g1_x_data */
  "*opt_g1_x_mode.topAttachment:           XmATTACH_WIDGET",
  "*opt_g1_x_mode.topWidget:               opt_g1_label",
  "*opt_g1_x_mode.leftAttachment:          XmATTACH_FORM",
  "*opt_g1_x_mode.leftOffset:              0",

/* g1_x_power : XmToggleButton */
  "*g1_x_power.labelString:                POWER",

/* g1_x_norm : XmToggleButton */
  "*g1_x_norm.labelString:                  Normal",
  "*g1_x_norm.set:                         true",

/* g1_x_data : XmToggleButton */
  "*g1_x_data.labelString:                 DataPoint",

/* opt_g1_xscale_label : XmLabel */
  "*opt_g1_xscale_label.height:          35",
  "*opt_g1_xscale_label.topAttachment:   XmATTACH_WIDGET",
  "*opt_g1_xscale_label.topWidget:       opt_g1_x_mode",
  "*opt_g1_xscale_label.leftAttachment:  XmATTACH_FORM",
  "*opt_g1_xscale_label.leftOffset:      0",
  "*opt_g1_xscale_label.rightAttachment: XmATTACH_FORM",
  "*opt_g1_xscale_label.rightOffset:     0",
  "*opt_g1_xscale_label.labelString:     X-Scale",

/* opt_g1_x_scale : XmRadioBox */
/* parent of g1_x_liner and g1_x_log */
  "*opt_g1_x_scale.topAttachment:        XmATTACH_WIDGET",
  "*opt_g1_x_scale.topWidget:            opt_g1_xscale_label",
  "*opt_g1_x_scale.leftAttachment:       XmATTACH_FORM",
  "*opt_g1_x_scale.leftOffset:           0",

/* g1_x_liner : XmToggleButton */
  "*g1_x_liner.labelString:              Liner",
  "*g1_x_liner.set:                      true",

/* g1_x_log : XmToggleButton */
  "*g1_x_log.labelString:                Log",

/* opt_g1_yscale_label : XmLabel */
  "*opt_g1_yscale_label.height:          35",
  "*opt_g1_yscale_label.topAttachment:   XmATTACH_WIDGET",
  "*opt_g1_yscale_label.topWidget:       opt_g1_x_scale",
  "*opt_g1_yscale_label.leftAttachment:  XmATTACH_FORM",
  "*opt_g1_yscale_label.leftOffset:      0",
  "*opt_g1_yscale_label.rightAttachment: XmATTACH_FORM",
  "*opt_g1_yscale_label.rightOffset:     0",
  "*opt_g1_yscale_label.labelString:     Y-Scale",

/* opt_g1_y_scale : XmRadioBox */
/* parent of g1_y_liner and g1_y_log */
  "*opt_g1_y_scale.topAttachment:         XmATTACH_WIDGET",
  "*opt_g1_y_scale.topWidget:             opt_g1_yscale_label",
  "*opt_g1_y_scale.leftAttachment:        XmATTACH_FORM",
  "*opt_g1_y_scale.leftOffset:            0",

/* g1_y_liner : XmToggleButton */
  "*g1_y_liner.labelString:              Liner",
  "*g1_y_liner.set:                      true",

/* g1_y_log : XmToggleButton */
  "*g1_y_log.labelString:                Log",


/* opt_g2_label : XmLabel */
  "*opt_g2_label.width:                  100",
  "*opt_g2_label.topAttachment:          XmATTACH_FORM",
  "*opt_g2_label.topOffset:              0",
  "*opt_g2_label.leftAttachment:         XmATTACH_FORM",
  "*opt_g2_label.leftOffset:             0",
  "*opt_g2_label.labelString:            Graph2\\nDisplayMode",

/* opt_g2_x_mode : XmRadioBox */
/* parent of g2_x_power, g2_x_norm, and g2_x_data */
  "*opt_g2_x_mode.topAttachment:         XmATTACH_WIDGET",
  "*opt_g2_x_mode.topWidget:             opt_g2_label",
  "*opt_g2_x_mode.leftAttachment:        XmATTACH_FORM",
  "*opt_g2_x_mode.leftOffset:            0",

/* g2_x_power : XmToggleButton */
  "*g2_x_power.labelString:              POWER",

/* g2_x_norm : XmToggleButton */
  "*g2_x_norm.labelString:               Normal",
  "*g2_x_norm.set:                       true",

/* g2_x_data : XmToggleButton */
  "*g2_x_data.labelString:               DataPoint",

/* opt_g2_xscale_label : XmLabel */
  "*opt_g2_xscale_label.height:          35",
  "*opt_g2_xscale_label.topAttachment:   XmATTACH_WIDGET",
  "*opt_g2_xscale_label.topWidget:       opt_g2_x_mode",
  "*opt_g2_xscale_label.leftAttachment:  XmATTACH_FORM",
  "*opt_g2_xscale_label.leftOffset:      0",
  "*opt_g2_xscale_label.rightAttachment: XmATTACH_FORM",
  "*opt_g2_xscale_label.rightOffset:     0",
  "*opt_g2_xscale_label.labelString:     X-Scale",

/* opt_g2_x_scale : XmRadioBox */
/* parent of g2_x_liner and g2_x_log */
  "*opt_g2_x_scale.topAttachment:        XmATTACH_WIDGET",
  "*opt_g2_x_scale.topWidget:            opt_g2_xscale_label",
  "*opt_g2_x_scale.leftAttachment:       XmATTACH_FORM",
  "*opt_g2_x_scale.leftOffset:           0",

/* g2_x_liner : XmToggleButton */
  "*g2_x_liner.labelString:              Liner",
  "*g2_x_liner.set:                      true",


/* g2_x_log : XmToggleButton */
  "*g2_x_log.labelString:                Log",

/* opt_g2_yscale_label : XmLabel */
  "*opt_g2_yscale_label.height:          35",
  "*opt_g2_yscale_label.topAttachment:   XmATTACH_WIDGET",
  "*opt_g2_yscale_label.topWidget:       opt_g2_x_scale",
  "*opt_g2_yscale_label.leftAttachment:  XmATTACH_FORM",
  "*opt_g2_yscale_label.leftOffset:      0",
  "*opt_g2_yscale_label.rightAttachment: XmATTACH_FORM",
  "*opt_g2_yscale_label.rightOffset:     0",
  "*opt_g2_yscale_label.labelString:     Y-Scale",

/* opt_g2_y_scale : XmRadioBox */
/* parent of g2_y_liner and g2_y_log */
  "*opt_g2_y_scale.topAttachment:        XmATTACH_WIDGET",
  "*opt_g2_y_scale.topWidget:            opt_g2_yscale_label",
  "*opt_g2_y_scale.leftAttachment:       XmATTACH_FORM",
  "*opt_g2_y_scale.leftOffset:           0",

/* g2_y_liner : XmToggleButton */
  "*g2_y_liner.labelString:              Liner",
  "*g2_y_liner.set:                      true",

/* g2_y_log : XmToggleButton */
  "*g2_y_log.labelString:                Log",

/* opt_sepa_vert2 : XmSeparator */
  "*opt_sepa_vert2.topAttachment:        XmATTACH_FORM",
  "*opt_sepa_vert2.topOffset:            0",
  "*opt_sepa_vert2.leftAttachment:       XmATTACH_WIDGET",
  "*opt_sepa_vert2.leftWidget:           opt_g2_label",
  "*opt_sepa_vert2.bottomAttachment:     XmATTACH_FORM",
  "*opt_sepa_vert2.bottomOffset:         0",
  "*opt_sepa_vert2.orientation:          XmVERTICAL",

/* opt_sepa_horiz2 : XmSeparator */
  "*opt_sepa_horiz2.topAttachment:       XmATTACH_WIDGET",
  "*opt_sepa_horiz2.topWidget:           option_cancel_button",
  "*opt_sepa_horiz2.leftAttachment:      XmATTACH_FORM",
  "*opt_sepa_horiz2.leftOffset:          0",
  "*opt_sepa_horiz2.rightAttachment:     XmATTACH_FORM",
  "*opt_sepa_horiz2.rightOffset:         0",
  "*opt_sepa_horiz2.orientation:         XmHORIZONTAL",

/* graph1_form : XmForm */
/* child of graphical_form */
/* parent of title1, zoom1_label, zoom1_out_button, zoom1_in_button,
   g1_left_label, g1_right_label, g1_label, g1_max_label, g1_min_label,
   and g1_window */
  "*graph1_form.topAttachment:     XmATTACH_FORM",
  "*graph1_form.topOffset:         0",
  "*graph1_form.leftAttachment:    XmATTACH_FORM",
  "*graph1_form.leftOffset:        0",
  "*graph1_form.rightAttachment:   XmATTACH_FORM",
  "*graph1_form.rightOffset:       0",
  "*graph1_form.bottomAttachment:  XmATTACH_POSITION",
  "*graph1_form.bottomPosition:    50",


/* title1: XmLabel */
  "*title1.height:         25",
  "*title1.topAttachment:  XmATTACH_FORM",
  "*title1.topOffset:      0",
  "*title1.leftAttachment: XmATTACH_FORM",
  "*title1.leftOffset:     0",
  "*title1.labelString:    Graph1 Title",
  "*title1.marginWidth:    5",

/* zoom1_label: XmLabel */
  "*zoom1_label.height:          25",
  "*zoom1_label.topAttachment:   XmATTACH_FORM",
  "*zoom1_label.topOffset:       0",
  "*zoom1_label.rightAttachment: XmATTACH_FORM",
  "*zoom1_label.rightOffset:     115",
  "*zoom1_label.labelString:     Zoom",

/* zoom1_in_button: XmArrowButton */
  "*zoom1_in_button.width:            20",
  "*zoom1_in_button.height:           25",
  "*zoom1_in_button.arrowDirection:   XmARROW_UP",
  "*zoom1_in_button.topAttachment:    XmATTACH_FORM",
  "*zoom1_in_button.topOffset:        0",
  "*zoom1_in_button.rightAttachment:  XmATTACH_FORM",
  "*zoom1_in_button.rightOffset:      95",
  "*zoom1_in_button.shadowThickness:  0",

/* zoom1_out_button: XmArrowButton */
  "*zoom1_out_button.width:            21",
  "*zoom1_out_button.height:           25",
  "*zoom1_out_button.arrowDirection:   XmARROW_DOWN",
  "*zoom1_out_button.topAttachment:    XmATTACH_FORM",
  "*zoom1_out_button.topOffset:        0",
  "*zoom1_out_button.rightAttachment:  XmATTACH_FORM",
  "*zoom1_out_button.rightOffset:      75",
  "*zoom1_out_button.shadowThickness:  0",

/* g1_left_label: XmLabel */
  "*g1_left_label.bottomAttachment: XmATTACH_FORM",
  "*g1_left_label.bottomOffset:     0",
  "*g1_left_label.leftAttachment:   XmATTACH_FORM",
  "*g1_left_label.leftOffset:       0",
  "*g1_left_label.labelString:      0.000",

/* g1_right_label: XmLabel */
  "*g1_right_label.bottomAttachment: XmATTACH_FORM",
  "*g1_right_label.bottomOffset:     0",
  "*g1_right_label.rightAttachment:  XmATTACH_FORM",
  "*g1_right_label.rightOffset:      50",
  "*g1_right_label.labelString:      0.000",

/* g1_label: XmLabel */
  "*g1_label.bottomAttachment: XmATTACH_FORM",
  "*g1_label.bottomOffset:     0",
  "*g1_label.rightAttachment:  XmATTACH_WIDGET",
  "*g1_label.rightWidget:      g1_right_label",
  "*g1_label.leftAttachment:   XmATTACH_WIDGET",
  "*g1_label.leftWidget:       g1_left_label",
  "*g1_label.labelString:      Time[sec]",

/* g1_max_label: XmLabel */
  "*g1_max_label.topAttachment:   XmATTACH_FORM",
  "*g1_max_label.topOffset:       25",
  "*g1_max_label.rightAttachment: XmATTACH_FORM",
  "*g1_max_label.rightOffset:     0",
  "*g1_max_label.width:           70",
  "*g1_max_label.labelString:     000000",
  "*g1_max_label.recomputeSize:   false",

/* g1_min_label: XmLabel */
  "*g1_min_label.bottomAttachment: XmATTACH_FORM",
  "*g1_min_label.bottomOffset:     30",
  "*g1_min_label.rightAttachment:  XmATTACH_FORM",
  "*g1_min_label.rightOffset:      0",
  "*g1_min_label.width:            70",
  "*g1_min_label.labelString:      000000",
  "*g1_min_label.recomputeSize:    false",

/* g1_window: XmScrolledWindow */
/* parent of g1_canvas */
  "*g1_window.bottomAttachment:           XmATTACH_WIDGET",
  "*g1_window.bottomWidget:               g1_left_label",
  "*g1_window.topAttachment:              XmATTACH_WIDGET",
  "*g1_window.topWidget:                  zoom1_in_button",
  "*g1_window.leftAttachment:             XmATTACH_FORM",
  "*g1_window.leftOffset:                 6",
  "*g1_window.rightAttachment:            XmATTACH_WIDGET",
  "*g1_window.rightWidget:                g1_max_label",
  "*g1_window.scrollBarPlacement:         XmBOTTOM_LEFT",
  "*g1_window.scrollBarDisplayPolicy:     XmSTATIC",
  "*g1_window.scrollingPolicy:            XmAUTOMATIC",
  "*g1_window.scrolledWindowMarginWidth:  0",
  "*g1_window.scrolledWindowMarginHeight: 0",
  "*g1_window.visualPolicy:               XmCONSTANT",
  "*g1_window.spacing:                    0",

/* g1_canvas: XmDrawingArea */
  "XCUT*g1_canvas*foreground:    green",
  "XCUT*g1_canvas*background:    black",
  "*g1_canvas.marginHeight:               0",
  "*g1_canvas.marginWidth:                0",
  "*g1_canvas.width:                      365",
  "*g1_canvas.height:                     125",
  "*g1_canvas.resizePolicy:               XmRESIZE_NONE",

/* graph2_form: XmForm */
/* parent of title2, zoom2_label, zoom2_out_button, zoom2_in_button, 
   g2_left_label, g2_right_label, g2_label, g2_max_label, g2_min_label,
   and g2_window */
  "*graph2_form.topAttachment:            XmATTACH_POSITION",
  "*graph2_form.topPosition:              50",
  "*graph2_form.leftAttachment:           XmATTACH_FORM",
  "*graph2_form.leftOffset:               0",
  "*graph2_form.rightAttachment:          XmATTACH_FORM",
  "*graph2_form.rightOffset:              0",
  "*graph2_form.bottomAttachment:         XmATTACH_FORM",
  "*graph2_form.bottomOffset:             0",


/* title2: XmLabel */
  "*title2.height:         25",
  "*title2.topAttachment:  XmATTACH_FORM",
  "*title2.topOffset:      0",
  "*title2.leftAttachment: XmATTACH_FORM",
  "*title2.leftOffset:     0",
  "*title2.labelString:    Graph2 Title",

/* zoom2_label: XmLabel */
  "*zoom2_label.height:          25",
  "*zoom2_label.topAttachment:   XmATTACH_FORM",
  "*zoom2_label.topOffset:       0",
  "*zoom2_label.rightAttachment: XmATTACH_FORM",
  "*zoom2_label.rightOffset:     115",
  "*zoom2_label.labelString:     Zoom",

/* zoom2_in_button: XmArrowButton */
  "*zoom2_in_button.height:           25",
  "*zoom2_in_button.width:            20",
  "*zoom2_in_button.arrowDirection:   XmARROW_UP",
  "*zoom2_in_button.topAttachment:    XmATTACH_FORM",
  "*zoom2_in_button.topOffset:        0",
  "*zoom2_in_button.rightAttachment:  XmATTACH_FORM",
  "*zoom2_in_button.rightOffset:      95",
  "*zoom2_in_button.shadowThickness:  0",

/* zoom2_out_button: XmArrowButton */
  "*zoom2_out_button.height:           25",
  "*zoom2_out_button.width:            21",
  "*zoom2_out_button.arrowDirection:   XmARROW_DOWN",
  "*zoom2_out_button.topAttachment:    XmATTACH_FORM",
  "*zoom2_out_button.topOffset:        0",
  "*zoom2_out_button.rightAttachment:  XmATTACH_FORM",
  "*zoom2_out_button.rightOffset:      75",
  "*zoom2_out_button.shadowThickness:  0",

/* g2_left_label: XmLabel */
  "*g2_left_label.bottomAttachment: XmATTACH_FORM",
  "*g2_left_label.bottomOffset:     0",
  "*g2_left_label.leftAttachment:   XmATTACH_FORM",
  "*g2_left_label.leftOffset:       0",
  "*g2_left_label.labelString:      0.000",

/* g2_right_label: XmLabel */
  "*g2_right_label.bottomAttachment: XmATTACH_FORM",
  "*g2_right_label.bottomOffset:     0",
  "*g2_right_label.rightAttachment:  XmATTACH_FORM",
  "*g2_right_label.rightOffset:      50",
  "*g2_right_label.labelString:      0.000",

/* g2_label: XmLabel */
  "*g2_label.bottomAttachment: XmATTACH_FORM",
  "*g2_label.bottomOffset:     0",
  "*g2_label.rightAttachment:  XmATTACH_WIDGET",
  "*g2_label.rightWidget:      g2_right_label",
  "*g2_label.leftAttachment:   XmATTACH_WIDGET",
  "*g2_label.leftWidget:       g2_left_label",
  "*g2_label.labelString:      Time[sec]",

/* g2_max_label: XmLabel */
  "*g2_max_label.topAttachment:   XmATTACH_WIDGET",
  "*g2_max_label.topWidget:       zoom2_out_button",
  "*g2_max_label.rightAttachment: XmATTACH_FORM",
  "*g2_max_label.rightOffset:     0",
  "*g2_max_label.width:           70",
  "*g2_max_label.labelString:     000000",
  "*g2_max_label.recomputeSize:   false",

/* g2_min_label: XmLabel */
  "*g2_min_label.bottomAttachment: XmATTACH_FORM",
  "*g2_min_label.bottomOffset:     30",
  "*g2_min_label.rightAttachment:  XmATTACH_FORM",
  "*g2_min_label.rightOffset:      0",
  "*g2_min_label.width:            70",
  "*g2_min_label.labelString:      000000",
  "*g2_min_label.recomputeSize:    false",

/* g2_window: XmScrolledWindow */
/* parent of g2_canvas */
  "*g2_window.bottomAttachment:             XmATTACH_WIDGET",
  "*g2_window.bottomWidget:                 g2_left_label",
  "*g2_window.topAttachment:                XmATTACH_WIDGET",
  "*g2_window.topWidget:                    zoom2_in_button",
  "*g2_window.leftAttachment:               XmATTACH_FORM",
  "*g2_window.leftOffset:                   6",
  "*g2_window.rightAttachment:              XmATTACH_WIDGET",
  "*g2_window.rightWidget:                  g2_min_label",
  "*g2_window.scrollBarPlacement:           XmBOTTOM_LEFT",
  "*g2_window.scrollBarDisplayPolicy:       XmSTATIC",
  "*g2_window.scrollingPolicy:              XmAUTOMATIC",
  "*g2_window.scrolledWindowMarginWidth:    0",
  "*g2_window.scrolledWindowMarginHeight:   0",
  "*g2_window.visualPolicy:                 XmCONSTANT",
  "*g2_window.spacing:                      0",

/* g2_canvas: XmDrawingArea */
  "XCUT*g2_canvas*foreground:               green",
  "XCUT*g2_canvas*background:               black",
  "*g2_canvas.marginHeight:                 0",
  "*g2_canvas.marginWidth:                  0",
  "*g2_canvas.width:                        365",
  "*g2_canvas.height:                       125",
  "*g2_canvas.resizePolicy:                 XmRESIZE_NONE",


/* buffers_form : XmForm */
/* parent of buff_label, sepa3, inpu_label, inpu_select, inpu_dec_button,
   inpu_num, inpu_inc_button, inpu_sepa, outp_label, outp_select, 
   outp_write_format, outp_write_byte, outp_dec_button, outp_num, 
   outp_inc_button, and outp_sepa */
  "*buffers_form.resizable:        false",
  "*buffers_form.width:            200",
  "*buffers_form.rightAttachment:  XmATTACH_FORM",
  "*buffers_form.rightOffset:      0",
  "*buffers_form.topAttachment:    XmATTACH_WIDGET",
  "*buffers_form.topWidget:        menu_buttons",

/* buff_label : XmLabel */
  "*buff_label.leftAttachment:  XmATTACH_FORM",
  "*buff_label.leftOffset:      0",
  "*buff_label.rightAttachment: XmATTACH_FORM",
  "*buff_label.rightOffset:     0",
  "*buff_label.labelString :    Data Files",

/* sepa3 : XmSeparator */
  "*sepa3.topAttachment:        XmATTACH_WIDGET",
  "*sepa3.topWidget:            buff_label",
  "*sepa3.leftAttachment:       XmATTACH_FORM",
  "*sepa3.leftOffset:           0",
  "*sepa3.rightAttachment:      XmATTACH_FORM",
  "*sepa3.rightOffset:          0",

/* inpu_label : XmLabel */
  "*inpu_label.topAttachment:    XmATTACH_WIDGET",
  "*inpu_label.topWidget:        sepa3",
  "*inpu_label.leftAttachment:   XmATTACH_FORM",
  "*inpu_label.leftOffset:       0",
  "*inpu_label.rightAttachment:  XmATTACH_FORM",
  "*inpu_label.rightOffset:      0",
  "*inpu_label.labelString :     INPUTFILE",

/* inpu_select : XmPushButton */
  "*inpu_select.height: 30",
  "*inpu_select.width:  100",
  "*inpu_select.topAttachment:     XmATTACH_WIDGET",
  "*inpu_select.topWidget:         inpu_label",
  "*inpu_select.leftAttachment:    XmATTACH_FORM",
  "*inpu_select.leftOffset:        0",
  "*inpu_select.labelString:       sample.dat",
  "*inpu_select.recomputeSize:     false",

/* inpu_dec_button : XmArrowButton */
  "*inpu_dec_button.height:           30",
  "*inpu_dec_button.width:            25",
  "*inpu_dec_button.arrowDirection:   XmARROW_LEFT",
  "*inpu_dec_button.topAttachment:    XmATTACH_WIDGET",
  "*inpu_dec_button.topWidget:        inpu_label",
  "*inpu_dec_button.rightAttachment:  XmATTACH_FORM",
  "*inpu_dec_button.rightOffset:      75",
  "*inpu_dec_button.shadowThickness:  0",

/* inpu_num : XmTextField */
  "*inpu_num.height:                30",
  "*inpu_num.width:                 50",
  "*inpu_num.marginHeight:          3",
  "*inpu_num.topAttachment:         XmATTACH_WIDGET",
  "*inpu_num.topWidget:             inpu_label",
  "*inpu_num.rightAttachment:       XmATTACH_FORM",
  "*inpu_num.rightOffset:           25",
  "*inpu_num.value:                 0000",

/* inpu_inc_button : XmArrowButton */
  "*inpu_inc_button.height:            30",
  "*inpu_inc_button.width:             25",
  "*inpu_inc_button.arrowDirection:    XmARROW_RIGHT",
  "*inpu_inc_button.topAttachment:     XmATTACH_WIDGET",
  "*inpu_inc_button.topWidget:         inpu_label",
  "*inpu_inc_button.rightAttachment:   XmATTACH_FORM",
  "*inpu_inc_button.rightOffset:       0",
  "*inpu_inc_button.shadowThickness:   0",

/* inpu_sepa : XmSeparator */
  "*inpu_sepa.topAttachment:           XmATTACH_WIDGET",
  "*inpu_sepa.topWidget:               inpu_inc_button",
  "*inpu_sepa.leftAttachment:          XmATTACH_FORM",
  "*inpu_sepa.leftOffset:              0",
  "*inpu_sepa.rightAttachment:         XmATTACH_FORM",
  "*inpu_sepa.rightOffset:             0",

/* outp_label : XmLabel */
  "*outp_label.topAttachment:          XmATTACH_WIDGET",
  "*outp_label.topWidget:              inpu_sepa",
  "*outp_label.leftAttachment:         XmATTACH_FORM",
  "*outp_label.leftOffset:             0",
  "*outp_label.rightAttachment:        XmATTACH_FORM",
  "*outp_label.rightOffset:            0",
  "*outp_label.labelString:            OUTPUTFILE",

/* outp_select : XmPushButton */
  "*outp_select.height: 30",
  "*outp_select.width: 100",
  "*outp_select.topAttachment:     XmATTACH_WIDGET",
  "*outp_select.topWidget:         outp_label",
  "*outp_select.leftAttachment:    XmATTACH_FORM",
  "*outp_select.leftOffset:        0",
  "*outp_select.labelString:       sample.dat",
  "*outp_select.recomputeSize:     false",

/* outp_dec_button : XmArrowButton */
  "*outp_dec_button.height:             30",
  "*outp_dec_button.width:              25",
  "*outp_dec_button.arrowDirection:     XmARROW_LEFT",
  "*outp_dec_button.topAttachment:      XmATTACH_WIDGET",
  "*outp_dec_button.topWidget:          outp_label",
  "*outp_dec_button.rightAttachment:    XmATTACH_FORM",
  "*outp_dec_button.rightOffset:        75",
  "*outp_dec_button.shadowThickness:    0",

/* outp_num : XmTextField */
  "*outp_num.height:           30",
  "*outp_num.width:            50",
  "*outp_num.marginHeight:     3",
  "*outp_num.topAttachment:    XmATTACH_WIDGET",
  "*outp_num.topWidget:        outp_label",
  "*outp_num.rightAttachment:  XmATTACH_FORM",
  "*outp_num.rightOffset:      25",
  "*outp_num.value:            0000",

/* outp_inc_button : XmArrowButton */
  "*outp_inc_button.height:           30",
  "*outp_inc_button.width:            25",
  "*outp_inc_button.arrowDirection:   XmARROW_RIGHT",
  "*outp_inc_button.topAttachment:    XmATTACH_WIDGET",
  "*outp_inc_button.topWidget:        outp_label",
  "*outp_inc_button.rightAttachment:  XmATTACH_FORM",
  "*outp_inc_button.rightOffset:      0",
  "*outp_inc_button.shadowThickness:  0",

/* outp_write_format : XmOptionMenu */
  "*outp_write_format.topAttachment:   XmATTACH_WIDGET",
  "*outp_write_format.topWidget:       outp_select",
  "*outp_write_format.rightAttachment:  XmATTACH_WIDGET",
  "*outp_write_format.rightWidget:     outp_write_byte",
  "*outp_write_format.labelString:     Fmt.",
  "*outp_write_format.orientation:     XmHORIZONTAL",
  "*outp_pulldown1.rowColumnType:      XmMENU_OPTION",
  "*outp_pulldown1.new.labelString:      New",
  "*outp_pulldown1.old.labelString:      Old",

/* outp_write_byte : XmOptionMenu */
  "*outp_write_byte.topAttachment:         XmATTACH_WIDGET",
  "*outp_write_byte.topWidget:             outp_select",
  "*outp_write_byte.rightAttachment:       XmATTACH_FORM",
  "*outp_write_byte.rightOffset:           0",
  "*outp_write_byte.labelString:           Size",
  "*outp_write_byte.orientation:           XmHORIZONTAL",
  "*outp_pulldown2.rowColumnType:          XmMENU_OPTION",
  "*outp_pulldown2.fourByte.labelString:       4",
  "*outp_pulldown2.twoByte.labelString:        2",
  "*outp_pulldown2.eightByte.labelString:      8",

/* outp_sepa : XmSeparator */
  "*outp_sepa.topAttachment:      XmATTACH_WIDGET",
  "*outp_sepa.topWidget :         outp_write_byte",
  "*outp_sepa.leftAttachment:     XmATTACH_FORM",
  "*outp_sepa.leftOffset:         0",
  "*outp_sepa.rightAttachment:    XmATTACH_FORM",
  "*outp_sepa.rightOffset:        0",

/* file_select_window: XmFileSelectionDialog */
  "*XmFileSelectionDialog.dialogTitle:    File Selection Box",


/* cutdt_base_form : XmForm */
/* isopmainλҤɤˤ */
/* parent of cut_write_button, cut_exit_button, cut_sepa, cut_start_label,
   cut_end_label, cut_start, cut_end, cut_s_unit, cut_e_unit, 
   init_cut_button, and cut_ok_button */
  "*cutdt_base_form.topAttachment:      XmATTACH_WIDGET",
  "*cutdt_base_form.topWidget:          buffers_form",
  "*cutdt_base_form.width:              200",
  "*cutdt_base_form.rightAttachment:    XmATTACH_FORM",
  "*cutdt_base_form.rightOffset:        0",
  "*cutdt_base_form.bottomAttachment:   XmATTACH_FORM",
  "*cutdt_base_form.bottomOffset:       0",

/* cut_write_button : XmPushButton */
  "*cut_write_button.width:            100",
  "*cut_write_button.topAttachment:    XmATTACH_FORM",
  "*cut_write_button.topOffset:        0",
  "*cut_write_button.rightAttachment:   XmATTACH_FORM",
  "*cut_write_button.rightOffset:      100",
  "*cut_write_button.labelString:      Write Data",

/* cut_exit_button : XmPushButton */
  "*cut_exit_button.width:             100",
  "*cut_exit_button.topAttachment:     XmATTACH_FORM",
  "*cut_exit_button.topOffset:         0",
  "*cut_exit_button.rightAttachment:   XmATTACH_FORM",
  "*cut_exit_button.rightOffset:       0",
  "*cut_exit_button.labelString:       Exit",

/* cut_sepa : XmSeparator */
  "*cut_sepa.topAttachment:     XmATTACH_WIDGET",
  "*cut_sepa.topWidget:         cut_write_button",
  "*cut_sepa.leftAttachment:    XmATTACH_FORM",
  "*cut_sepa.leftOffset:        0",
  "*cut_sepa.rightAttachment:   XmATTACH_FORM",
  "*cut_sepa.rightOffset:       0",

/* cut_start_label : XmLabel */
  "*cut_start_label.alignment:    XmALIGNMENT_END",
  "*cut_start_label.height:          30",
  "*cut_start_label.topAttachment:   XmATTACH_WIDGET",
  "*cut_start_label.topWidget:       cut_sepa",
  "*cut_start_label.rightAttachment:  XmATTACH_FORM",
  "*cut_start_label.rightOffset:     100",
  "*cut_start_label.labelString:     Start Point",

/* cut_start : XmTextField */
  "*cut_start.height:           30",
  "*cut_start.width:            70",
  "*cut_start.topAttachment:    XmATTACH_WIDGET",
  "*cut_start.topWidget:        cut_sepa",
  "*cut_start.rightAttachment:  XmATTACH_FORM",
  "*cut_start.rightOffset:      30",
  "*cut_start.marginHeight:     3",
  "*cut_start.value:            ",

/* cut_s_unit : XmLabel */
  "*cut_s_unit.width:            30",
  "*cut_s_unit.height:           30",
  "*cut_s_unit.topAttachment:    XmATTACH_WIDGET",
  "*cut_s_unit.topWidget:        cut_sepa",
  "*cut_s_unit.rightAttachment:  XmATTACH_FORM",
  "*cut_s_unit.rightOffset:      0",
  "*cut_s_unit.marginHeight:     5",
  "*cut_s_unit.labelString:      sec",

/* cut_end_label : XmLabel */
  "*cut_end_label.alignment:    XmALIGNMENT_END",
  "*cut_end_label.height:          30",
  "*cut_end_label.topAttachment:   XmATTACH_WIDGET",
  "*cut_end_label.topWidget:       cut_start_label",
  "*cut_end_label.rightAttachment:  XmATTACH_FORM",
  "*cut_end_label.rightOffset:     100",
  "*cut_end_label.labelString:     End Point",

/* cut_end : XmTextField */
  "*cut_end.height:           30",
  "*cut_end.width:            70",
  "*cut_end.topAttachment:    XmATTACH_WIDGET",
  "*cut_end.topWidget :       cut_start",
  "*cut_end.rightAttachment:  XmATTACH_FORM",
  "*cut_end.rightOffset :     30",
  "*cut_end.marginHeight:     3",
  "*cut_end.value:            ",

/* cut_e_unit : XmLabel */
  "*cut_e_unit.width:            30",
  "*cut_e_unit.height:           30",
  "*cut_e_unit.topAttachment:    XmATTACH_WIDGET",
  "*cut_e_unit.topWidget:        cut_start",
  "*cut_e_unit.rightAttachment:  XmATTACH_FORM",
  "*cut_e_unit.rightOffset:      0",
  "*cut_e_unit.marginHeight:     5",
  "*cut_e_unit.labelString:      sec",

/* cut_grid_label : XmLabel */
  "*cut_grid_label.alignment:    XmALIGNMENT_END",
  "*cut_grid_label.height:          30",
  "*cut_grid_label.topAttachment:   XmATTACH_WIDGET",
  "*cut_grid_label.topWidget:       cut_end_label",
  "*cut_grid_label.rightAttachment:  XmATTACH_FORM",
  "*cut_grid_label.rightOffset:     100",
  "*cut_grid_label.labelString:     Grid",

/* cut_grid : XmTextField */
  "*cut_grid.height:           30",
  "*cut_grid.width:            70",
  "*cut_grid.topAttachment:    XmATTACH_WIDGET",
  "*cut_grid.topWidget :       cut_end",
  "*cut_grid.rightAttachment:  XmATTACH_FORM",
  "*cut_grid.rightOffset :     30",
  "*cut_grid.marginHeight:     3",
  "*cut_grid.value:            1",

/* cut_g_unit : XmLabel */
  "*cut_g_unit.width:            30",
  "*cut_g_unit.height:           30",
  "*cut_g_unit.topAttachment:    XmATTACH_WIDGET",
  "*cut_g_unit.topWidget:        cut_end",
  "*cut_g_unit.rightAttachment:  XmATTACH_FORM",
  "*cut_g_unit.rightOffset:      0",
  "*cut_g_unit.marginHeight:     5",
  "*cut_g_unit.labelString:      pts",

/* init_cut_button : XmPushButton */
  "*init_cut_button.width:            100",
  "*init_cut_button.topAttachment:    XmATTACH_WIDGET",
  "*init_cut_button.topWidget :       cut_grid",
  "*init_cut_button.rightAttachment:   XmATTACH_FORM",
  "*init_cut_button.rightOffset:      100",
  "*init_cut_button.labelString:      Init. Selection",

/* cut_ok_button : XmPushButton */
  "*cut_ok_button.width:            100",
  "*cut_ok_button.topAttachment:     XmATTACH_WIDGET",
  "*cut_ok_button.topWidget:         cut_g_unit",
  "*cut_ok_button.rightAttachment:   XmATTACH_FORM",
  "*cut_ok_button.rightOffset:       0",
  "*cut_ok_button.labelString:       Cut Out",

/* left_bar : XmForm */
  "XCUT*g1_canvas.left_bar.foreground: white",
  "XCUT*g1_canvas.left_bar.background: white",
  "*left_bar.width: 1",

/* right_bar: XmForm */
  "XCUT*g1_canvas.right_bar.foreground: white",
  "XCUT*g1_canvas.right_bar.background: white",
  "*right_bar.width: 1",


  NULL};

#endif /* _ISOP_RESOURCE_H_ */
