#pragma once
#include "string_repeat.hpp"
/** This immutable utility is used to format string.
 * \Usage:
	StringAligner center(30, StringAligner::CENTER);
	cout << center.align("Hello") << endl;
	cout << center("Aligned World!") << endl; // can use as function object.
 */
class StringAligner
{
public:
	enum AlignMode{
		RIGHT=0, CENTER, LEFT,
	};
private:
	unsigned m_width;
	AlignMode m_mode;
	char m_filler;
public:
	
	/** default AlignMode is 'RIGHT', for convenience of number string. */
	StringAligner(unsigned width, AlignMode mode=RIGHT, char filler=' ')
			:m_width(width), m_mode(mode), m_filler(filler)
	{
	}
	/** this object can be called by function style.*/
	std::string operator()(std::string str)const
	{
		return align(str);
	}
	/** align given string by set mode.*/
	std::string align(std::string str)const
	{
		int n = m_width - str.length();
		if (n<=0) {
			return str;
		}
		StringRepeat fill(m_filler);
		switch (m_mode){
		case LEFT: return str + fill.repeat(n);
		case CENTER: return fill.repeat(n/2) + str + fill.repeat(n/2+n%2);
		default: return fill.repeat(n) + str;
		}
	}
};


