/*
 * $Id: commons.h,v 1.3 2004/06/24 00:08:35 jklein Exp $
 * $Author: jklein $
 * $Log: commons.h,v $
 * Revision 1.3  2004/06/24 00:08:35  jklein
 * added s_buffer_compare()
 *
 * Revision 1.2  2004/06/22 12:23:39  jklein
 * correcting mistakes.
 *
 * Revision 1.1  2004/06/21 11:28:00  jklein
 * Changed source tree.
 *
 * Revision 1.1.1.1  2004/06/21 09:29:33  jklein
 * import scale
 *
 */

#ifndef _SC_COMMONS_H_
#define _SC_COMMONS_H_

#include "scale/config.h"
#include <stdlib.h>


#if HAVE_STRING_H
#  include <string.h>
#else
#  include <strings.h>
#endif


/** all of primitive types for SC libraries. */
typedef void * spointer;

#if HAVE_STDBOOL_H
enum {
	false = 0,
	true = 1
};

typedef bool sboolean
#else
typedef enum {
	false = 0,
	true = 1
} sboolean;
#endif


#if ! HAVE_STDINT_H

typedef signed char	int8_t;
typedef short int   int16_t;
typedef int         int32_t;

typedef unsigned char      uint8_t;
typedef unsigned short int uint16_t;
typedef unsigned int       uint32_t;

#else
#  include <stdint.h>
#endif

typedef int		sint;
typedef int8_t  sint8;
typedef int16_t sint16;
typedef int32_t sint32;

typedef unsigned int	suint;
typedef uint8_t			suint8;
typedef uint16_t		suint16;
typedef uint32_t		suint32;

typedef char			schar;
typedef unsigned char	suchar;

typedef short			sshort;
typedef unsigned short	sushort;

typedef long			slong;
typedef unsigned		sulong;

typedef float	sfloat;
typedef double  sdouble;


/**
 * Scale$B%i%$%V%i%jCf$G;HMQ$5$l$kHf3S4X?t!#(B
 * $BJV$jCM$O(Bp1$B$NJ}$,Bg$-$$$H$-$O@5$N?t!"Ey$7$$$H$-$O(B0$B!"(Bp2$B$NJ}$,Bg$-$$$H$-$O(B
 * $BIi$N?t$rJV$7$^$9!#(B
 * @see s_string_compare(), s_string_rcompare(), s_buffer_compare(),
 *		s_buffer_rcompare(), s_pointer_compare()
 */
typedef sint8 (*sc_compf_t)(const spointer p1, const spointer p2);


/** (char *)$B$I$&$7$NHf3S$r9T$J$&!#(B */
sint8 s_string_compare(const spointer, const spointer);

/** (char *)$B$I$&$7$NHf3S$r9T$J$&$,!"JV$jCM$ODL>o$N5U$K$J$k!#(B */
sint8 s_string_rcompare(const spointer, const spointer);

/** sbuffer_t$B$I$&$7$NHf3S$r9T$J$&!#(B */
sint8 s_buffer_compare(const spointer, const spointer);

/** sbuffer_t$B$I$&$7$NHf3S$r9T$J$&$,!"JV$jCM$O5U$K$J$k!#(B */
sint8 s_buffer_rcompare(const spointer, const spointer);

/** $B%]%$%s%?$I$&$7$NHf3S$r9T$J$&!#(B */
sint8 s_pointer_compare(const spointer, const spointer);

#endif /* _SC_COMMONS_H_ */
