/*
 * $Id: btree.h,v 1.1 2004/06/23 12:59:01 jklein Exp $
 * $Author: jklein $
 * $Log: btree.h,v $
 * Revision 1.1  2004/06/23 12:59:01  jklein
 * Added scale/btree.h, sc_btree.c.
 *
 */


/**
   <p>$BFsJ,LZ$rI=$9(Bsbtree_t$B$H!"0lO"$N4X?t$rDs6!$7$^$9!#(B</p>
*/


#ifndef _SCALL_BTREE_H_
#define _SCALL_BTREE_H_

#include "scale/commons.h"
#include "scale/iterator.h"


typedef struct _sc_btree sbtree_t;
typedef struct _sc_btree_node sbtree_node_t;


struct _sc_btree {
	size_t count;
	sc_compf_t compare;
	sbtree_node_t *head;
	sbtree_node_t *end;
};

struct _sc_btree_node {
	spointer key;
	spointer contents;
	sbtree_node_t *lnode; /* left node */
	sbtree_node_t *rnode; /* right node */
};


sbtree_t *		s_btree_alloc(sc_compf_t compare);
void			s_btree_free(sbtree_t *btree);
size_t			s_btree_size(const sbtree_t *btree);
void			s_btree_add(sbtree_t *btree, spointer key, spointer conts);
spointer		s_btree_get(sbtree_t *btree, const spointer key);
spointer		s_btree_remove(sbtree_t *btree, const spointer key);
siterator_t *	s_btree_lfs_iterator(sbtree_t *btree);



#endif /* _SCALL_BTREE_H_ */
