/*
 * $Id: xarray.h,v 1.2 2004/06/27 13:35:17 jklein Exp $
 * $Author: jklein $
 * $Log: xarray.h,v $
 * Revision 1.2  2004/06/27 13:35:17  jklein
 * Added few functions for sbuffer_t and few macros for sxarray_t.
 *
 * Revision 1.1  2004/06/24 15:16:50  jklein
 * sxarray_t was added for abstruction of collection structure.
 *
 */

/**
 * $BCj>]2DJQD9G[Ns$rI=$9(Bsxarray_t$B$H0lO"$N4X?t!J<B:]$O%^%/%m!K$rDs6!$9$k!#(B
 * sxarray_t$B$O(Bs_list_xarray()$B$d(Bs_vector_xarray()$B$rDL$7$F:n@.$5$l$k!#(B
 */

#ifndef _SCALE_XARRAY_H_
#define _SCALE_XARRAY_H_

#include "scale/commons.h"
#include "scale/iterator.h"


/** $BCj>]2DJQD9G[Ns%*%V%8%'%/%H(B */
typedef struct _sc_xarray sxarray_t;


#define s_xarray_free(__xarr) (__xarr->free(__xarr))
#define s_xarray_size(__xarr) (__xarr->size(__xarr))
#define s_xarray_add(__xarr, __data) (__xarr->add(__xarr, __data))
#define s_xarray_get(__xarr, __index) (__xarr->get(__xarr, __index))
#define s_xarray_remove(__xarr, __index) (__xarr->remove(__xarr, __index))
#define s_xarray_find(__xarr, __cmpf, __data) \
(__xarr->find(__xarr, __cmpf, __data))
#define s_xarray_iterator(__xarr) (__xarr->iterator(__xarr))
#define s_xarray_sort(__xarr, __cmpf) (_xarr->sort(__xarr))


struct _sc_xarray {
	spointer listdata;

	/* sxarray interfaces */
	
	void		(*free)(sxarray_t *);		
	size_t		(*size)(sxarray_t *);		
	void		(*add)(sxarray_t *, spointer); 
	spointer	(*get)(sxarray_t *, size_t) ;
	spointer	(*remove)(sxarray_t *, size_t);
	sint32		(*find)(sxarray_t *, sc_compf_t, spointer);
	siterator_t * (*iterator)(sxarray_t *);
	void		(*sort)(sxarray_t *, sc_compf_t);

	/* -- CAUTION ---------------------
	   Do never touch thing below here.
	   these are for scale-library.
	---------------------------------- */
	sboolean is_origin;
};


#endif /* _SCALE_XARRAY_H_ */
