
#include <unistd.h>
#include <stdlib.h>
#include <stdarg.h>
#include "scale/scaleio.h"

#define BUFSIZE 1024
#define LARGE_BUFSIZE (BUFSIZE * 2)


int
s_writef(int fd, const char *fmt, ...)
{
	va_list ap;
	size_t len;

	va_start(ap, fmt);
	len = s_vwritef(fd, fmt, ap);
	va_end(ap);

	return len;
}


int
s_vwritef(int fd, const char *fmt, va_list ap)
{
	sbuffer_t *sbuf;
	size_t len;
	char *p;

	sbuf = s_buffer_alloc(strlen(fmt) * 2);
	len = s_buffer_vsprintf(sbuf, fmt, ap);
	
	p = sbuf->string;

	s_fullwrite(fd, sbuf->string, len);

	s_buffer_free(sbuf);

	return len;
}


size_t
s_fullwrite(int fd, const void *buf, size_t count)
{
	size_t total = 0;
	char *p;
	
	p = (char *)buf;

	do {
		size_t writelen;
		writelen = write(fd, p + total, count - total);

		if (writelen <= 0)
			break;

		total += writelen;
	} while (total < count);

	return count;

}


size_t
s_freadline(FILE *in, sbuffer_t *sbuf)
{
	char tmpbuf[BUFSIZE];
	
	s_buffer_clear(sbuf);
	
	while(fgets(tmpbuf, BUFSIZE, in)) {
		s_buffer_strcat(sbuf, tmpbuf);

		if(tmpbuf[strlen(tmpbuf)-1] == '\n')
			break;
	}

	return s_buffer_strlen(sbuf);
}


size_t
s_freadfile(FILE *in, sbuffer_t *sbuf)
{
	char tmpbuf[LARGE_BUFSIZE];
	size_t readsize, totalsize;

	totalsize = 0;
	
	while ((readsize = fread(tmpbuf, sizeof(char), LARGE_BUFSIZE, in)) > 0) {
		s_buffer_strncat(sbuf, tmpbuf, readsize);
		totalsize += readsize;
	}

	return totalsize;
}


