/*
 * $Id: heap.h,v 1.2 2004/06/28 09:51:09 jklein Exp $
 * $Author: jklein $
 * $Log: heap.h,v $
 * Revision 1.2  2004/06/28 09:51:09  jklein
 * interface was changed in scale/iterator.h
 *
 * Revision 1.1  2004/06/22 12:23:39  jklein
 * correcting mistakes.
 *
 */

/**
   <p>$B%R!<%W9=B$$r07$&0Y$N9=B$BN$H4X?t$rDs6!$9$k!#%R!<%W9=B$$H$$$&$N$O(B
   $B0l8+%9%?%C%/$HF1MM$NA`:n$,Ds6!$5$l$F$$$k$h$&$K8+$($k$,!"(Bpop()$B$7$?$H$-$K(B
   $B>o$K0lHVBg$-$$%G!<%?$rJV$9$3$H$rJ]>Z$7$F$$$k!#(B</p>

   <p>$B$D$^$j!"(B{1, 2, 3}$B$H$$$&=gHV$G(Bpush()$B$7$?8e$K=g<!(Bpop()$B$9$k$H(B{3, 2, 1}
   $B$H$$$&=g=x$GJV$5$l$k!#(B</p>
*/

#ifndef _SCALL_HEAP_H_
#define _SCALL_HEAP_H_

#include "scale/commons.h"


typedef struct _sc_heap sheap_t;


struct _sc_heap {
	size_t memsize;
	size_t count;
	size_t next_index;
	sc_compf_t compare;
	spointer *array;
};


sheap_t *		s_heap_alloc(sc_compf_t compare);
sheap_t *		s_heap_allocn(sc_compf_t compare, size_t inisize);
void			s_heap_free(sheap_t *heap);
void			s_heap_push(sheap_t *heap, spointer contents);
spointer		s_heap_pop(sheap_t *heap);
spointer		s_heap_peek(sheap_t *heap);
size_t			s_heap_size(sheap_t *heap);


/* sub actions */
spointer		s_heap_get(sheap_t *, size_t index);


#endif /* _SCALL_HEAP_H_ */
