/*
 * $Id: list.h,v 1.6 2004/07/10 17:04:48 jklein Exp $
 * $Author: jklein $
 * $Log: list.h,v $
 * Revision 1.6  2004/07/10 17:04:48  jklein
 * Added few function to sxarray_t.
 *
 * Revision 1.5  2004/06/28 09:51:09  jklein
 * interface was changed in scale/iterator.h
 *
 * Revision 1.3  2004/06/24 15:16:50  jklein
 * sxarray_t was added for abstruction of collection structure.
 *
 * Revision 1.2  2004/06/21 16:44:17  jklein
 * Added iterator.
 *
 * Revision 1.1  2004/06/21 11:28:00  jklein
 * Changed source tree.
 *
 * Revision 1.1.1.1  2004/06/21 09:29:33  jklein
 * import scale
 *
 */


/**
 * $B%j%s%/%j%9%H9=B$$rI=$99=B$BN(Bslist_t$B$H0lO"$NA`:n4X?t$rDs6!$9$k!#(B
 * $B0J2<!"%5%s%W%k(B
 * <pre>
 * slist_t *list = s_list_alloc();
 * int i;
 * 
 * s_list_add(list, "A");
 * s_list_add(list, "B");
 * printf("list size is %d\n", s_list_size(list));
 * for (i=0; i&lt;s_list_size(list); i++)
 *     printf("data[%d] = %s\n", i, (char *)s_list_get(list, i));
 * </pre>
 */

#ifndef _SCALE_LIST_H_
#define _SCALE_LIST_H_

#include "scale/commons.h"
#include "scale/iterator.h"
#include "scale/xarray.h"

/** $B%j%s%/%j%9%H!&%*%V%8%'%/%H(B*/
typedef struct _sc_linklist slist_t;

/** $B%j%s%/%j%9%H!&%N!<%I!&%*%V%8%'%/%H(B */
typedef struct _sc_linklist_node slist_node_t;


/*
 * A list looks like this at intial state.
 *   head --> tail
 * And it becomes like this after you added a value.
 *   head --> node[0] --> node[1] -->...--> tail
 */
struct _sc_linklist {
	size_t count;
/*	sc_compf_t compare; */
	slist_node_t *head;
	slist_node_t *tail;
};


struct _sc_linklist_node {
	spointer contents;
	slist_node_t *next;
	slist_node_t *prev;
};


slist_t *		s_list_alloc();
void			s_list_free(slist_t *);
size_t			s_list_size(slist_t *);
void			s_list_insert_at(slist_t *, uint, const spointer);
void 			s_list_add(slist_t *, const spointer);
spointer		s_list_get(slist_t *, uint);
spointer		s_list_remove(slist_t *, uint);
sint32			s_list_find(slist_t *, sc_compf_t, spointer);
sboolean		s_list_join(slist_t *, slist_t *);
void			s_list_sort(slist_t *, sc_compf_t);

siterator_t *	s_list_iterator(slist_t *);
sxarray_t *		s_list_xarray(void);
sxarray_t *		s_list_attach_xarray(slist_t *);


/* this is for debbuging.
 * or you can use this any time. */
void _sc_dump_list(const char *, slist_t *);


#endif /* _SCALE_LIST_H_ */
