/**
 * $Id: sc_alloc.c,v 1.3 2004/06/21 16:44:17 jklein Exp $
 * $Author: jklein $
 * $Log: sc_alloc.c,v $
 * Revision 1.3  2004/06/21 16:44:17  jklein
 * Added iterator.
 *
 */


#include <stdio.h>
#include "scale/alloc.h"



#if MEMORY_DEBUG
static size_t total_memory = 0;

#  define DBG_MEMORY_ALLOC(n) {\
	total_memory += n;\
	printf("Used Memory(alloc): %d\n", total_memory);\
}while(0)

#  define DBG_MEMORY_FREE(n) {\
	total_memory -= n;\
	printf("Used Memory(free) : %d\n", total_memory);\
}

#else
#  define DBG_MEMORY_ALLOC(n)
#  define DBG_MEMORY_FREE(n)
#endif


#define _DEF_EXIT_CODE 1


sboolean _exit_err_handler(void);
static merror_handler *errhandler = (merror_handler *)&_exit_err_handler;



sboolean
_exit_err_handler(void) 
{
	exit(_DEF_EXIT_CODE);
	return true;
}


void
s_merror_handler(merror_handler *handler)
{
	if (handler)
		errhandler = handler;
	else
		errhandler = (merror_handler *)&_exit_err_handler;
}


spointer 
s_malloc(size_t size)
{
	spointer p;

	if (size < 1)
		size = 1;
	
	if ((p = malloc(size)) == NULL) {
		if ((*errhandler)())
			p = s_malloc(size);
		else
			exit(_DEF_EXIT_CODE);
	}

	DBG_MEMORY_ALLOC(size);

	return p;
}


spointer 
s_calloc(size_t nmemb, size_t size)
{
	spointer p;

	if (size < 1)
		size = 1;
	
	if ((p = calloc(nmemb, size)) == NULL) {
		if ((*errhandler)())
			p = s_calloc(nmemb, size);
		else
			exit(_DEF_EXIT_CODE);
	}

	DBG_MEMORY_ALLOC(size * nmemb);

	return p;
}



spointer 
s_realloc(spointer p, size_t size)
{
	return s_reallocn(p, 0, size);
}


spointer
s_reallocn(spointer p, size_t oldsize, size_t newsize)
{
	spointer newp;

	if (newsize < 1)
		newsize = 1;

	if ((newp = realloc(p, newsize)) == NULL) {
		if ((*errhandler)())
			newp = s_realloc(p, newsize);
		else
			exit(_DEF_EXIT_CODE);
	}

	DBG_MEMORY_ALLOC(newsize);
	DBG_MEMORY_FREE(oldsize);

	return newp;
}



void
s_free(spointer p)
{
	if (p == NULL)
		return;
	free(p);
}


void
s_freen(spointer p, size_t n)
{
	if (p == NULL)
		return;
	memset(p, '\0', n);
	free(p);

	DBG_MEMORY_FREE(n);
}
