/* $Id: sc_graphviz.c,v 1.2 2004/08/05 13:54:30 jklein Exp $
 * $Author: jklein $
 * $Log: sc_graphviz.c,v $
 * Revision 1.2  2004/08/05 13:54:30  jklein
 * Fixed so that Scale can be compiled on Mac OSX(10.3 or higher).
 *
 * Revision 1.1  2004/07/10 17:04:48  jklein
 * Added few function to sxarray_t.
 *
 */

#include "scale/graphviz.h"
#include "scale/queue.h"


sbuffer_t *
s_heap_graphviz(sheap_t *heap)
{
	sbuffer_t *buf;
	sbuffer_t *tmpbuf;
	int i;

	buf = s_buffer_allocn(256);
	tmpbuf = s_buffer_allocn(64);

	s_buffer_strcpy(buf, "digraph G {\n");

	for (i=1; i<=s_heap_size(heap); ++i) {
		if (HEAP_LCHILD_INDEX(i) > s_heap_size(heap))
			break;
		
		s_buffer_sprintf(tmpbuf, "\t%s -> %s\n", heap->array[i],
						 heap->array[HEAP_LCHILD_INDEX(i)]);
		s_buffer_strcat(buf, tmpbuf->string);

		if (HEAP_RCHILD_INDEX(i) > s_heap_size(heap))
			continue;

		s_buffer_sprintf(tmpbuf, "\t%s -> %s\n", heap->array[i],
						 heap->array[HEAP_RCHILD_INDEX(i)]);

		s_buffer_strcat(buf, tmpbuf->string);
	}

	s_buffer_strcat(buf, "}\n");
	s_buffer_free(tmpbuf);

	return buf;
}


sbuffer_t *
s_btree_graphviz(sbtree_t *bt)
{
	sbuffer_t *buf;
	sbuffer_t *tmpbuf;
	squeue_t *queue;
	sbtree_node_t *node;

	buf = s_buffer_allocn(256);
	tmpbuf = s_buffer_allocn(64);
	queue = s_queue_alloc();

	s_buffer_strcpy(buf, "digraph G {\n");
	bt->end->contents = NULL;

	s_queue_enqueue(queue, bt->head->rnode);
	while (s_queue_size(queue) != 0) {
		node = (sbtree_node_t *)s_queue_dequeue(queue);

		if (node->lnode->contents != NULL) {
			s_buffer_sprintf(tmpbuf, "\t%s -> %s\n", node->contents,
							 node->lnode->contents);
			s_queue_enqueue(queue, node->lnode);
			s_buffer_strcat(buf, tmpbuf->string);
		}
		if(node->rnode->contents != NULL) {
			s_buffer_sprintf(tmpbuf, "\t%s -> %s\n", node->contents,
							 node->rnode->contents);
			s_queue_enqueue(queue, node->rnode);
			s_buffer_strcat(buf, tmpbuf->string);
		}
	}

	s_buffer_strcat(buf, "}\n");
	s_buffer_free(tmpbuf);
	s_queue_free(queue);
	
	return buf;
}
