/*
 * $Id: heap.h,v 1.7 2004/09/04 07:08:01 jklein Exp $
 * $Author: jklein $
 * $Log: heap.h,v $
 * Revision 1.7  2004/09/04 07:08:01  jklein
 * fixed "const spointer" to "sconstpointer".
 *
 * Revision 1.6  2004/08/08 07:14:45  jklein
 * Added 'resize()' function to array objects.
 *
 * Revision 1.5  2004/08/02 16:39:13  jklein
 * Fixed bug in the btree.c
 *
 * Revision 1.4  2004/07/22 17:27:56  jklein
 * few changes in stack.h
 *
 * Revision 1.3  2004/07/10 17:04:48  jklein
 * Added few function to sxarray_t.
 *
 * Revision 1.2  2004/06/28 09:51:09  jklein
 * interface was changed in scale/iterator.h
 *
 * Revision 1.1  2004/06/22 12:23:39  jklein
 * correcting mistakes.
 *
 */

/**
   <p>$B%R!<%W9=B$$r07$&0Y$N9=B$BN$H4X?t$rDs6!$9$k!#%R!<%W9=B$$H$$$&$N$O(B
   $B0l8+%9%?%C%/$HF1MM$NA`:n$,Ds6!$5$l$F$$$k$h$&$K8+$($k$,!"(Bpop()$B$7$?$H$-$K(B
   $B>o$K0lHVBg$-$$%G!<%?$rJV$9$3$H$rJ]>Z$7$F$$$k!#(B</p>

   <p>$B$D$^$j!"(B{1, 2, 3}$B$H$$$&=gHV$G(Bpush()$B$7$?8e$K=g<!(Bpop()$B$9$k$H(B{3, 2, 1}
   $B$H$$$&=g=x$GJV$5$l$k!#(B</p>

   <p>$B%R!<%W9=B$$KBP$7$F!"<jF0$GC5:w$9$kI,MW$O$*$=$i$/L5$$$H;W$&$,!"$b$7(B
   $B$=$NI,MW$,M-$k$H$-$O%R!<%W9=B$$rM}2r$7$?>e$G!"0J2<$N%k!<%k$r<i$k$Y$-$@!#(B
   $B$^$:!"%G!<%?<+BN$OG[Ns>e$KJ]B8$5$l$k$,!"$=$N:G=i$N%$%s%G%C%/%9!J(B = 0$B!K(B
   $B$O;H$o$l$J$$!#$3$l$O?F%N!<%I$H;R%N!<%I$r%7%s%W%k$K5a$a$k$?$a$G$"$k!#(B
   $B$D$^$j!"%k!<%H%N!<%I!J$b$C$H$bBg$-$$%N!<%I!K$O(Bheap->array[1]$B$K3JG<(B
   $B$5$l$k!#$=$7$F!"$=$N;R%N!<%I$X%"%/%;%9$9$k:]$O(BHEAP_LCHILD_INDEX,
   HEAP_RCHILD_INDEX$B!J:8$N;R!"1&$N;R$N=g!K$H$$$&%^%/%m4X?t$r;H$&!#(B</p>
*/

#ifndef _SCALL_HEAP_H_
#define _SCALL_HEAP_H_

#include <scale/commons.h>


/* heap$B$N?F;R$N%N!<%I$r7W;;$9$k%^%/%m(B */
#define HEAP_LCHILD_INDEX(parent) (2 * (parent))
#define HEAP_RCHILD_INDEX(parent) (2 * (parent) + 1)
#define HEAP_PARENT_INDEX(child)  ((size_t)((child) / 2))


typedef struct _sc_heap sheap_t;


struct _sc_heap {
	size_t memsize;
	size_t count;
	size_t next_index;
	sc_compf_t compare;
	spointer *array;
};


sheap_t *		s_heap_alloc(sc_compf_t compare);
sheap_t *		s_heap_allocn(sc_compf_t compare, size_t inisize);
void			s_heap_free(sheap_t *heap);
void			s_heap_push(sheap_t *heap, spointer contents);
spointer		s_heap_pop(sheap_t *heap);
spointer		s_heap_peek(sheap_t *heap);
size_t			s_heap_size(sheap_t *heap);
void			s_heap_resize(sheap_t *heap);

/* sub actions */
spointer		s_heap_get(sheap_t *, size_t ind);


#endif /* _SCALL_HEAP_H_ */
