/*
 * $Id: vector.h,v 1.9 2004/09/04 07:08:01 jklein Exp $
 * $Author: jklein $
 * $Log: vector.h,v $
 * Revision 1.9  2004/09/04 07:08:01  jklein
 * fixed "const spointer" to "sconstpointer".
 *
 * Revision 1.8  2004/08/08 07:14:45  jklein
 * Added 'resize()' function to array objects.
 *
 * Revision 1.7  2004/08/05 13:54:30  jklein
 * Fixed so that Scale can be compiled on Mac OSX(10.3 or higher).
 *
 * Revision 1.6  2004/07/10 17:04:48  jklein
 * Added few function to sxarray_t.
 *
 * Revision 1.5  2004/06/28 09:51:09  jklein
 * interface was changed in scale/iterator.h
 *
 * Revision 1.4  2004/06/26 06:58:13  jklein
 * small fix in each header files.
 *
 * Revision 1.3  2004/06/24 15:16:50  jklein
 * sxarray_t was added for abstruction of collection structure.
 *
 * Revision 1.2  2004/06/21 16:44:17  jklein
 * Added iterator.
 *
 * Revision 1.1  2004/06/21 11:28:00  jklein
 * Changed source tree.
 *
 * Revision 1.1.1.1  2004/06/21 09:29:33  jklein
 * import scale
 */

/**
   <p>$B%Y%/%H%k9=B$$rDs6!$7$^$9!#$3$l$ODL>o$NG[Ns$rMQ$$$F<BAu$5$l$F$$$k$N$G!"(B
   $B%i%s%@%`%"%/%;%9$KBP$7$F$O>o$K(BO(1)$B$G$N%"%/%;%9$,2DG=$G$"$9$,!"(B
   $B%G!<%?$N:o=|$K$O(BO(N)$B$H!"8zN($,NI$/$"$j$^$;$s!#FC$K%-%e!<9=B$$N$h$&$K(B
   $B%G!<%?$N@hF,$+$i:o=|$7$F$$$/=hM}$,:G$bCY$$$N$G!"@'Hs$H$b$5$1$k$Y$-$G$9!#(B
   </p>

   <p>$B%/%i%$%"%s%HB&$N%3!<%I$G$O(Bs_vector_xarray()$B$rMQ$$$k$3$H$b8!F$$7$F$_$F(B
   $B$/$@$5$$!#(B</p>
*/

#ifndef _SCALE_VECTOR_H_
#define _SCALE_VECTOR_H_

#include <scale/commons.h>
#include <scale/iterator.h>
#include <scale/xarray.h>


typedef struct _vector svector_t;


struct _vector {
	spointer *array;
	size_t count;
	size_t memsize;
};


svector_t *		s_vector_alloc(void);
svector_t *		s_vector_allocn(size_t);
void			s_vector_free(svector_t *);
size_t			s_vector_size(svector_t *);
void			s_vector_insert_at(svector_t *, suint, spointer);
void			s_vector_add(svector_t *, spointer);
spointer		s_vector_get(svector_t *, suint);
spointer		s_vector_remove(svector_t *, suint);
sint32			s_vector_find(svector_t *, sc_compf_t, spointer);
sboolean		s_vector_join(svector_t *, svector_t *);
void			s_vector_sort(svector_t *, sc_compf_t);
void			s_vector_resize(svector_t *);

siterator_t *	s_vector_iterator(svector_t *);
sxarray_t *		s_vector_xarray(void);
sxarray_t *		s_vector_xarrayn(size_t);
sxarray_t *		s_vector_attach_xarray(svector_t *);


#endif /* _SCALE_VECTOR_H_ */
