/* $Id: xtable.h,v 1.2 2004/09/04 07:08:01 jklein Exp $
 * $Author: jklein $
 * $Log: xtable.h,v $
 * Revision 1.2  2004/09/04 07:08:01  jklein
 * fixed "const spointer" to "sconstpointer".
 *
 * Revision 1.1  2004/08/03 05:49:50  jklein
 * Add sxtable_t structure.
 *
 */

#ifndef _SCALE_XTABLE_H_
#define _SCALE_XTABLE_H_

#include <scale/commons.h>


#define s_xtable_free(xt) (xt->free(xt))
#define s_xtable_size(xt) (xt->size(xt))
#define s_xtable_put(xt, key, conts) (xt->put(xt, key, conts))
#define s_xtable_get(xt, key) (xt->get(xt, key))
#define s_xtable_remove(xt, key) (xt->remove(xt, key))
#define s_xtable_keys(xt) (xt->keys(xt))


/** ݲơ֥빽¤ */
typedef struct sc_xtable_s sxtable_t;


struct sc_xtable_s {
	/* table interface */
	void		(*free)(sxtable_t *);
	size_t		(*size)(const sxtable_t *);
	void		(*put)(sxtable_t *, spointer key, spointer contents);
	spointer	(*get)(const sxtable_t *, sconstpointer key);
	void		(*remove)(sxtable_t *, sconstpointer key);
	siterator_t *(*keys)(const sxtable_t *);


	/* -- CAUTION ---------------------
	   Do never touch thing below here.
	   these are for scale-library.
	---------------------------------- */
	spointer tabledata;
	sboolean is_origin;
};

#endif /* _SCALE_XTABLE_H_ */
