/**
 * $Id: buffer.h,v 1.2 2004/06/21 16:44:17 jklein Exp $
 * $Author: jklein $
 * $Log: buffer.h,v $
 * Revision 1.2  2004/06/21 16:44:17  jklein
 * Added iterator.
 *
 */


#ifndef _SC_BUFFER_H_
#define _SC_BUFFER_H_


#include <stdarg.h>
#include "scale/commons.h"


typedef struct _sc_buffer sbuffer_t;


struct _sc_buffer {
	char *string;
	size_t memsize;
};


sbuffer_t *		s_buffer_alloc(size_t);
void			s_buffer_free(sbuffer_t *);
void			s_buffer_clear(sbuffer_t *);
size_t			s_buffer_strlen(sbuffer_t *);
sbuffer_t *		s_buffer_strcat(sbuffer_t *, const char *);
sbuffer_t *		s_buffer_strncat(sbuffer_t *, const char *, size_t);
sbuffer_t *		s_buffer_strcpy(sbuffer_t *, const char *);
sbuffer_t *		s_buffer_strncpy(sbuffer_t *, const char *, size_t);
size_t			s_buffer_sprintf(sbuffer_t *, const char *, ...);
size_t			s_buffer_vsprintf(sbuffer_t *, const char *, va_list);
sint			s_buffer_strcmp(const sbuffer_t *, const sbuffer_t *);
sint			s_buffer_strncmp(const sbuffer_t *, const sbuffer_t *, size_t);
void			_s_buffer_grouth(sbuffer_t *, size_t);



#endif /* _SC_BUFFER_H_ */

