/*
 * $Id: hash.h,v 1.3 2004/06/22 12:23:39 jklein Exp $
 * $Author: jklein $
 * $Log: hash.h,v $
 * Revision 1.3  2004/06/22 12:23:39  jklein
 * correcting mistakes.
 *
 */


#ifndef _S_HASH_H_
#define _S_HASH_H_


#include "scale/commons.h"
#include "scale/iterator.h"


/**
 * This must be prime number.
 * Examples: 127, 251, 509, 1021, 2039, 4091, 8191, 16381, ...
*/
#define DEFAULT_HASH_SIZE 1021

/**
 * $B%O%C%7%e4X?t(B
 * @see s_string_hashfunc()
 */
typedef unsigned int (*hashfunc_t)(const spointer, size_t);
typedef struct _sc_hash_table shash_t;


shash_t *		s_hash_alloc(size_t hsize, hashfunc_t hfunc, sc_compf_t cmpf);
void			s_hash_free(shash_t *htable);
spointer		s_hash_get(shash_t *htable, const spointer key);
void			s_hash_put(shash_t *htable, spointer key, spointer contents);
void			s_hash_remove(shash_t *htable, const spointer key);
size_t			s_hash_size(shash_t *htable);
void			s_hash_clear(shash_t *htable);

siterator_t *	s_hash_keys(shash_t *htable);

/* use this function for hashfunc_t. */
unsigned int	s_string_hashfunc(const spointer key, size_t hashsize);


#endif /* _S_HASH_H_ */
