using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using SCFiler2.FileSystem;
using SCFiler2.Action;

namespace SCFiler2 {
	public partial class FileView : UserControl {
		private string current_path = @"c:\";

		public FileView() {
			InitializeComponent();
			setPath(current_path); //TODO Ƃ肠ŏ̓[g\邱ƂɂƂBƂŏC
		}

		/// <summary>
		/// r[̃pXXV܂B
		/// </summary>
		/// <param name="full_name">Vɐݒ肷tH_̃tpX</param>
		private void setPath(string full_name) {
			current_path = full_name;
			drawView();
		}

		/// <summary>
		/// r[̓ẽ݂pXɏ]čŐVɂ܂B
		/// </summary>
		private void drawView() {
			//
			list_view.Clear();

			//̏
			list_view.Columns.Add("O", 300);

			//tH_̕\
			string[] folders = System.IO.Directory.GetDirectories(current_path);
			foreach (string folder in folders) {
				FilerItem filer_item = new Folder(folder);
				ListViewItem item = new ListViewItem(filer_item.Info.Name);
				item.Tag = filer_item;
				list_view.Items.Add(item);
			}

			//t@C̕\
			string[] files = System.IO.Directory.GetFiles(current_path);
			foreach (string file in files) {
				FilerItem filer_item = new File(file);
				ListViewItem item = new ListViewItem(filer_item.Info.Name);
				item.Tag = filer_item;
				list_view.Items.Add(item);
			}

		}

		private void file_list_view_KeyDown(object sender, KeyEventArgs e) {
			if (KeyCommandManager.Instance.executeAction(e.Control, e.Alt, e.Shift, e.KeyCode)) {

			} else  if (e.KeyCode == Keys.Enter) {
				FilerItem item = (FilerItem)list_view.FocusedItem.Tag;

				if (item.Type == FilerItem.ItemType.Folder) {
					//tH_炻̃tH_̒Ɉړ
					setPath(item.Info.FullName);
				} else {
					//t@CAs
					Process.Start(item.Info.FullName);
				}
			} else if (e.KeyCode == Keys.Back) {
				//etH_Ɉړ
				System.IO.DirectoryInfo parent = System.IO.Directory.GetParent(current_path);//etH_擾
				setPath(parent.FullName);
			}
		}
	}
}
