using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using SCFiler2.FileSystem;
using SCFiler2.Action;
using SCFiler2.Util;

namespace SCFiler2 {
	public partial class FileView : UserControl {
		private string current_path = @"c:\";
		private FileViewComparer sorter = new FileViewComparer(0);
		private string view_name = "";

		public FileView() {
			InitializeComponent();
			setPath(current_path); //TODO Ƃ肠ŏ̓[g\邱ƂɂƂBƂŏC
			list_view.ListViewItemSorter = sorter;
		}

		/// <summary>
		/// JnMainFormĂ΂
		/// </summary>
		/// <param name="view_name">r[ɂ閼OBݒt@C̕ۑɎgBCX^X̎ʂ̂</param>
		public void initialize(string view_name) {
			this.view_name = view_name;
			load();
		}

		/// <summary>
		/// IMainFormĂ΂
		/// </summary>
		public void terminate() {
			save();
		}

		/// <summary>
		/// IĂFilerItemList^ŕԂB
		/// </summary>
		public List<FilerItem> SelectedFilerItems {
			get {
				List<FilerItem> list = new List<FilerItem>();
				foreach (ListViewItem item in list_view.SelectedItems) {
					list.Add((FilerItem)item.Tag);
				}
				return list;
			}
		}

		/// <summary>
		/// FilerViewɕ\ĂpXԂ
		/// </summary>
		public string CurrentPath {
			get { return current_path; }
		}

		/// <summary>
		/// r[̃pXXV܂B
		/// </summary>
		/// <param name="full_name">Vɐݒ肷tH_̃tpX</param>
		public void setPath(string full_name) {
			if (!System.IO.Directory.Exists(full_name)) {
				MessageBox.Show(full_name+"݂͑܂");
				return;
			}
			current_path = full_name;
			drawView();
			current_path_label.Text = current_path;
			//ACe΁Aԏ̂̂ɑIĂԂɂ
			if (list_view.Items.Count > 0) {
				list_view.Items[0].Selected = true;
				list_view.Items[0].Focused = true;
			}
		}

		/// <summary>
		/// r[̓ẽ݂pXɏ]čŐVɂ܂B
		/// </summary>
		public void drawView() {
			try {
				//ANZXȂȂ̂ŁAŏ(O)Ɏ擾݂
				string[] folders = System.IO.Directory.GetDirectories(current_path);

				//
				list_view.Clear();

				//̏
				list_view.Columns.Add("O", 250);
				list_view.Columns.Add("gq", 50);
				list_view.Columns.Add("TCY", 80, HorizontalAlignment.Right);
				list_view.Columns.Add("XV", 130);

				//tH_̕\
				foreach (string folder in folders) {
					FilerItem filer_item = new Folder(folder);
					ListViewItem item = new ListViewItem(filer_item.NameWithoutExtension);//O
					item.SubItems.Add("<dir>");//gq
					item.SubItems.Add(filer_item.SizeDisplayString);//TCY
					item.SubItems.Add(filer_item.Info.LastWriteTime.ToString("yyyy/MM/dd hh:mm:ss"));//XV
					item.Tag = filer_item;
					list_view.Items.Add(item);
				}

				//t@C̕\
				string[] files = System.IO.Directory.GetFiles(current_path);
				foreach (string file in files) {
					FilerItem filer_item = new File(file);
					ListViewItem item = new ListViewItem(filer_item.NameWithoutExtension);//O
					item.SubItems.Add(filer_item.Info.Extension);//gq
					item.SubItems.Add(filer_item.SizeDisplayString);//TCY
					item.SubItems.Add(filer_item.Info.LastWriteTime.ToString("yyyy/MM/dd hh:mm:ss"));//XV
					item.Tag = filer_item;
					list_view.Items.Add(item);
				}

				list_view.Sort();
			} catch (UnauthorizedAccessException e) {
				MainForm.Instance.printToStatusbar("[error]"+e.Message);
			}
		}

		private void file_list_view_KeyDown(object sender, KeyEventArgs e) {
			KeyCommandManager.Instance.executeAction(e.Control, e.Alt, e.Shift, e.KeyCode);
		}

		private void FileView_Enter(object sender, EventArgs e) {
			MainForm main_form = MainForm.Instance;
			main_form.notifyFileViewFocused(this);

			folder_info_panel.BackColor = SystemColors.ActiveCaption;
		}

		private void FileView_Leave(object sender, EventArgs e) {
			folder_info_panel.BackColor = SystemColors.InactiveCaption;
		}

		private void list_view_DoubleClick(object sender, EventArgs e) {
			Action.Action.ExecuteFocusedItem.execute();
		}

		private void save() {
			SettingFile file = SettingFile.Instance;
			file.save(view_name, "LastPath", current_path);
		}

		private void load() {
			SettingFile file = SettingFile.Instance;
			string path = file.load(view_name, "LastPath");
			setPath(path);
		}

		private void list_view_ItemDrag(object sender, ItemDragEventArgs e) {
			//IACeFullNameXg
			string[] selected_files = new string[list_view.SelectedItems.Count];
			for (int i = 0; i < list_view.SelectedItems.Count; i++) {
				FilerItem item = (FilerItem)list_view.SelectedItems[i].Tag;
				selected_files[i] = item.Info.FullName;
			}

			//hbO
			DataObject data = new DataObject(DataFormats.FileDrop, selected_files);
			list_view.DoDragDrop(data, DragDropEffects.Copy | DragDropEffects.Move);
			//ړƂ̂߂ɍĕ`悷
			drawView();
		}

		private void list_view_DragEnter(object sender, DragEventArgs e) {
			if (e.Data.GetDataPresent(DataFormats.FileDrop)) {
				e.Effect = DragDropEffects.Copy | DragDropEffects.Move;
			} else {
				e.Effect = DragDropEffects.None;
			}
		}

		private void list_view_DragDrop(object sender, DragEventArgs e) {
			//t@C̎擾
			string[] files = (string[])e.Data.GetData(DataFormats.FileDrop, false);

			//CtrlĂRs[ (8Ctrl\)
			if (((e.KeyState & 8) == 8) && ((e.AllowedEffect & DragDropEffects.Copy) == DragDropEffects.Copy)) {
				foreach (string file in files) {
					if (System.IO.Directory.Exists(file)) { //fBNgǂ𒲂ׂ
						System.IO.DirectoryInfo info = new System.IO.DirectoryInfo(file);
						Microsoft.VisualBasic.FileIO.FileSystem.CopyDirectory(file, current_path + "\\" + info.Name, Microsoft.VisualBasic.FileIO.UIOption.AllDialogs, Microsoft.VisualBasic.FileIO.UICancelOption.ThrowException);
					} else {
						System.IO.FileInfo info = new System.IO.FileInfo(file);
						Microsoft.VisualBasic.FileIO.FileSystem.CopyFile(file, current_path + "\\" + info.Name, Microsoft.VisualBasic.FileIO.UIOption.AllDialogs, Microsoft.VisualBasic.FileIO.UICancelOption.ThrowException);
					}
				}
			} else if ((e.AllowedEffect & DragDropEffects.Move) == DragDropEffects.Move) {
				foreach (string file in files) {
					if (System.IO.Directory.Exists(file)) {
						System.IO.DirectoryInfo info = new System.IO.DirectoryInfo(file);
						Microsoft.VisualBasic.FileIO.FileSystem.MoveDirectory(file, current_path + "\\" + info.Name, Microsoft.VisualBasic.FileIO.UIOption.AllDialogs, Microsoft.VisualBasic.FileIO.UICancelOption.ThrowException);
					} else {
						System.IO.FileInfo info = new System.IO.FileInfo(file);
						Microsoft.VisualBasic.FileIO.FileSystem.MoveFile(file, current_path + "\\" + info.Name, Microsoft.VisualBasic.FileIO.UIOption.AllDialogs, Microsoft.VisualBasic.FileIO.UICancelOption.ThrowException);
					}
				}
			}
			drawView();
		}
	}
}
