using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using SCFiler2.FileSystem;

namespace SCFiler2 {
	public partial class ClipboardView : UserControl {
		public ClipboardView() {
			InitializeComponent();
		}

		public void updateView() {
			item_list.Items.Clear();
			item_list.Columns.Add("",Parent.Width);
			if (Clipboard.ContainsFileDropList()) {
				System.Collections.Specialized.StringCollection files_in_clipboard = Clipboard.GetFileDropList();
				foreach (string file_name in files_in_clipboard) {
					File file = new File(file_name);
					ListViewItem item = new ListViewItem(file.Info.Name);
					item.Tag = file;
					item_list.Items.Add(item);
				}
			}
		}

		private void clear_button_MouseEnter(object sender, EventArgs e) {
			//wNAx{^̓Xy[X̊֌WドxŎĂ̂ŁAx̏ɗFςĂ
			clear_button.ForeColor = Color.Orange;
		}

		private void clear_button_Click(object sender, EventArgs e) {
			Action.Action.ClearClipboard.execute();
			MainForm.Instance.checkUpdateAllView();

		}

		private void clear_button_MouseLeave(object sender, EventArgs e) {
			clear_button.ForeColor = Color.White;
		}
	}
}
