using System;
using System.Collections.Generic;
using System.Text;

namespace SCFiler2.FileSystem {
	public class FolderHistoryManager : HistoryManager {
		public FolderHistoryManager(HistoryView view, string view_name) : base(view, view_name) {
		}

		protected override FilerItem createNewItem(string item_fullname) {
			return new Folder(item_fullname);
		}

		protected override FilerItem createNewItemFromExecutedItem(FilerItem item) {
			if (item.Type == FilerItem.ItemType.File) {
				return new Folder(item.Path);
			} else {
				return new Folder(item.Info.FullName);
			}
		}

		protected override bool isRegister(FilerItem item) {
			//ǂȏꍇło^
			return true;
		}
	}
}
