using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SCFiler2.Action;

namespace SCFiler2 {
	public partial class OptionDialog : Form {
		public OptionDialog() {
			InitializeComponent();
		}

		private void cancel_button_Click(object sender, EventArgs e) {
			Close();
		}

		private void ok_button_Click(object sender, EventArgs e) {
			MainForm main_form = MainForm.Instance;

			//L[蓖āiQj^u
			SCFiler2System.Instance.Option.KeyCommand.ChangeDriveByNumKey = checkbox_change_drive_by_numkey.Checked;
			//F^u
			SCFiler2System.Instance.Option.Color.ActiveViewTitleText = color_active_view_title.ForeColor;
			SCFiler2System.Instance.Option.Color.ActiveViewTitleBack = color_active_view_title.BackColor;
			SCFiler2System.Instance.Option.Color.InactiveViewTitleText = color_inactive_view_title.ForeColor;
			SCFiler2System.Instance.Option.Color.InactiveViewTitleBack = color_inactive_view_title.BackColor;

			SCFiler2System.Instance.Option.save();

			//^u
			main_form.FileHistoryManager1.setValidExtension(historyview1_valid_string.Text);
			main_form.FileHistoryManager1.save();
			main_form.FileHistoryManager2.setValidExtension(historyview2_valid_string.Text);
			main_form.FileHistoryManager2.save();

			Close();
		}

		private void assign_button_Click(object sender, EventArgs e) {
			string command = new_key.Text;

			Action.Action action = KeyCommandManager.Instance.getAssignedAction(command);
			if (action != null) {
				MessageBox.Show("̃L[͂ł"+action.DisplayString+"Ɋ蓖ĂĂ܂");
				return;
			}
			KeyCommandManager.Instance.registAction((Action.Action)action_list.SelectedItems[0].Tag, command);
			KeyCommandManager.Instance.save();
		}

		private void OptionDialog_Load(object sender, EventArgs e) {
			//L[蓖(1)r[
			action_list.Columns.Add("", 220);
			foreach (Action.Action action in Action.Action.All_Action) {
				ListViewItem item = new ListViewItem(action.DisplayString);
				item.Tag = action;
				action_list.Items.Add(item);
			}

			//L[蓖āiQjr[
			checkbox_change_drive_by_numkey.Checked = SCFiler2System.Instance.Option.KeyCommand.ChangeDriveByNumKey;

			//r[
			historyview1_valid_string.Text = MainForm.Instance.FileHistoryManager1.getValidExtension();
			historyview2_valid_string.Text = MainForm.Instance.FileHistoryManager2.getValidExtension();

			//Fr[
			color_active_view_title.ForeColor = SCFiler2System.Instance.Option.Color.ActiveViewTitleText;
			color_active_view_title.BackColor = SCFiler2System.Instance.Option.Color.ActiveViewTitleBack;
			color_inactive_view_title.ForeColor = SCFiler2System.Instance.Option.Color.InactiveViewTitleText;
			color_inactive_view_title.BackColor = SCFiler2System.Instance.Option.Color.InactiveViewTitleBack;
		}

		private void new_key_TextChanged(object sender, EventArgs e) {
		}
		
		private void new_key_KeyDown(object sender, KeyEventArgs e) {
			if (action_list.SelectedItems.Count < 1) {
				new_key.Text = "ŏɃL[蓖Ă@\IĂ";
			} else if (KeyCommandManager.Instance.IsValidCommand(e.Control, e.Alt, e.Shift, e.KeyCode)) {
				new_key.Text = KeyCommandManager.Instance.getCommandString(e.Control, e.Alt, e.Shift, e.KeyCode);
			} else {
				new_key.Text = "";
			}
			e.Handled = true;
		}

		private void new_key_KeyPress(object sender, KeyPressEventArgs e) {
			e.Handled = true;
		}

		private void action_list_SelectedIndexChanged(object sender, EventArgs e) {
			//łɊ蓖čς݂ꍇ̓eLXg{bNXɊ蓖čς݂̃L[\
			if (action_list.SelectedItems.Count > 0) {
				Action.Action action = (Action.Action)action_list.SelectedItems[0].Tag;
				old_key.Text = KeyCommandManager.Instance.getAssignedKeyCommand(action);
			}
		}

		private void color_active_view_title_back_button_Click(object sender, EventArgs e) {
			color_dialog.Color = color_active_view_title.BackColor;
			color_dialog.ShowDialog();
			color_active_view_title.BackColor = color_dialog.Color;
		}

		private void color_active_view_title_text_button_Click(object sender, EventArgs e) {
			color_dialog.Color = color_active_view_title.ForeColor;
			color_dialog.ShowDialog();
			color_active_view_title.ForeColor = color_dialog.Color;
		}

		private void color_inactive_view_title_text_button_Click(object sender, EventArgs e) {
			color_dialog.Color = color_inactive_view_title.ForeColor;
			color_dialog.ShowDialog();
			color_inactive_view_title.ForeColor = color_dialog.Color;
		}

		private void color_inactive_view_title_back_button_Click(object sender, EventArgs e) {
			color_dialog.Color = color_inactive_view_title.BackColor;
			color_dialog.ShowDialog();
			color_inactive_view_title.BackColor = color_dialog.Color;
		}
	}
}