using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.Util;

namespace SCFiler2.Action {
	public abstract class Action {
		public enum ActionType {
			FileOperation,
			View,
			Application,
			Move,
		}

		/// <summary>
		/// type\邽߂̕Ԃ
		/// </summary>
		/// <param name="type"></param>
		/// <returns></returns>
		static public string getTypeString(ActionType type) {
			switch (type) {
				case ActionType.Application:
					return "AvP[V";
				case ActionType.FileOperation:
					return "t@C";
				case ActionType.Move:
					return "ړ";
				case ActionType.View:
					return "\";
				default:
					return "";
			}
		}

		/// <summary>
		/// ݂̃CX^XActionType\Ԃ
		/// </summary>
		public string TypeString {
			get { return getTypeString(this.Type); }
		}

		static public Action ExitApplication = new ExitApplication();
		static public Action CopyToAnotherFileView = new CopyToAnotherFileVIew();
		static public Action MoveToAnothierFileView = new MoveToAnotherFileView();
		static public Action MoveToRecycle = new MoveToRecycle();
		static public Action DeleteSelectedItem = new DeleteSelectedItem();
		static public Action ExecuteFocusedItem = new ExecuteFocusedItem();
		static public Action MoveToParentFolder = new MoveToParentFolder();
		static public Action setFocusToLeftFileView = new setFocusToLeftFileView();
		static public Action setFocusToRightFileView = new setFocusToRightFileView();
		static public Action OpenByExplorer = new OpenByExplorer();
		static public Action MoveToDriveRoot = new MoveToDriveRoot();
		static public Action AddToJumpFolder = new AddToJumpFolder();
		static public Action GoToJumpFolder = new GoToJumpFolder();
		static public Action GoToSameFolderAsAnotherView = new GoToSameFolderAsAnotherView();
		static public Action CreateFolder = new CreateFolder();
		static public Action IncrementalSearch = new IncrementalSearch();
		static public Action SelectAll = new SelectAll();
		static public Action RefleshAll = new RefleshAll();
		static public Action Rename = new Rename();
		static public Action PasteClipboard = new PasteClipboard();
		static public Action CopyToClipboard = new CopyToClipboard();
		static public Action CutToClipboard = new CutToClipboard();
		static public Action ClearClipboard = new ClearClipboard();
		static public Action FileSearch = new FileSearch();

		static public Action[] All_Action = { ExitApplication, CopyToAnotherFileView, MoveToAnothierFileView,
			MoveToRecycle, DeleteSelectedItem, ExecuteFocusedItem, MoveToParentFolder, setFocusToLeftFileView, 
			setFocusToRightFileView, OpenByExplorer, MoveToDriveRoot, AddToJumpFolder, GoToJumpFolder,
			GoToSameFolderAsAnotherView, CreateFolder, IncrementalSearch, SelectAll, RefleshAll, Rename,
			PasteClipboard, CopyToClipboard, CutToClipboard,ClearClipboard, FileSearch};

		abstract public string DisplayString { get;}

		abstract public void execute();

		abstract public ActionType Type { get;}

	}
}
