using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.Util;

namespace SCFiler2.FileSystem {
	public class FileHistoryManager : HistoryManager {
		private string valid_extension_string = ""; //Lgq;łȂ
		private string view_name = "";
		List<string> valid_extension_list = new List<string>();

		public FileHistoryManager(HistoryView view, string view_name) : base(view, view_name) {
			this.view_name = view_name;
		}

		protected override FilerItem createNewItem(string item_fullname) {
			return new File(item_fullname);
		}

		protected override FilerItem createNewItemFromExecutedItem(FilerItem item) {
			return new File(item.Info.FullName);
		}

		protected override bool isRegister(FilerItem item) {
			if (item.Type == FilerItem.ItemType.Folder) {
				return false;
			} else {
				if (valid_extension_list.Count == 0) {
					//ݒ肳ĂȂꍇ́AexeȊOo^
					if (item.Info.Extension != ".exe") {
						return true;
					} else {
						return false;
					}
				} else if (valid_extension_list.Contains(item.Info.Extension) == true) {
					return true;
				} else {
					return false;
				}
			}
		}

		override public void load() {
			base.load();
			SettingFile file = SettingFile.Instance;
			string str = file.load(view_name, "Ώۊgq");
			setValidExtension(str);
		}

		public override void save() {
			base.save();
			SettingFile file = SettingFile.Instance;
			file.save(view_name, "Ώۊgq", valid_extension_string);
		}
		/// <summary>
		/// ΏۊgqOĐݒ肷邽߂̃\bh
		/// </summary>
		/// <param name="valid_extensions">gqZ~Ri;jŘABgqɂ̓hbgi.)܂</param>
		public void setValidExtension(string valid_extensions) {
			valid_extension_string = valid_extensions;

			valid_extension_list.Clear();

			if (valid_extension_string == "") {
				return;
			}

			string[] strs = valid_extension_string.Split(';');
			foreach (string s in strs) {
				valid_extension_list.Add(s);
			}
		}

		/// <summary>
		/// ƂΏۊgqԂ
		/// </summary>
		/// <returns>gqZ~Ri;jŘABgqɂ̓hbgi.)܂</returns>
		public string getValidExtension() {
			return valid_extension_string;
		}
	}
}
