using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using SCFiler2.FileSystem;
using SCFiler2.Action;
using SCFiler2.Util;

namespace SCFiler2 {
	public partial class FileView : UserControl {
		private string current_path = @"c:\";
		private FileViewComparer sorter = new FileViewComparer(0);
		private string view_name = "";
		private enum ViewMode {
			Normal,
			IncrementalSearch
		}
		private ViewMode mode = ViewMode.Normal;

		public FileView() {
			InitializeComponent();
			list_view.ListViewItemSorter = sorter;
			setInactiveViewColor();
		}

		/// <summary>
		/// JnMainFormĂ΂
		/// </summary>
		/// <param name="view_name">r[ɂ閼OBݒt@C̕ۑɎgBCX^X̎ʂ̂</param>
		public void initialize(string view_name) {
			this.view_name = view_name;
			load();
		}

		/// <summary>
		/// IMainFormĂ΂
		/// </summary>
		public void terminate() {
			save();
		}

		/// <summary>
		/// IĂFilerItemList^ŕԂB
		/// </summary>
		public List<FilerItem> SelectedFilerItems {
			get {
				List<FilerItem> list = new List<FilerItem>();
				foreach (ListViewItem item in list_view.SelectedItems) {
					list.Add((FilerItem)item.Tag);
				}
				return list;
			}
		}

		/// <summary>
		/// FilerViewɕ\ĂpXԂ
		/// </summary>
		public string CurrentPath {
			get { return current_path; }
		}

		/// <summary>
		/// r[̃pXXV܂B
		/// </summary>
		/// <param name="full_name">Vɐݒ肷tH_̃tpX</param>
		public void setPath(string full_name) {
			if (!System.IO.Directory.Exists(full_name)) {
				MessageBox.Show(full_name+"݂͑܂");
				return;
			}
			current_path = full_name;
			setViewModeNormal();
			updateView();
		}

		/// <summary>
		/// r[̃pXXVAw̃ACeɃtH[JX킹
		/// </summary>
		/// <param name="full_name"></param>
		/// <param name="focus_item"></param>
		public void setPathAndFocusItem(string new_path_full_name, string focus_item) {
			setPath(new_path_full_name);
			setFocus(focus_item);
		}

		private void setFocus(string item_full_name) {
			foreach (ListViewItem view_item in list_view.Items) {
				FilerItem item = (FilerItem)view_item.Tag;
				if (item.Info.FullName == item_full_name) {
					//Iς݂̑SACẻ
					foreach (ListViewItem list_view_item in list_view.SelectedItems) {
						list_view_item.Selected = false;
					}
					view_item.Selected = true;
					view_item.Focused = true;
				}
			}
		}

		/// <summary>
		/// r[̓ẽ݂pXɏ]čŐVɂ܂B
		/// </summary>
		public void updateView() {
			try {
				//ANZXȂȂ̂ŁAŏ(O)Ɏ擾݂
				string[] folders = System.IO.Directory.GetDirectories(current_path);

				SuspendLayout();

				//
				list_view.Clear();

				//̏
				list_view.Columns.Add("O", 250);
				list_view.Columns.Add("gq", 50);
				list_view.Columns.Add("TCY", 80, HorizontalAlignment.Right);
				list_view.Columns.Add("XV", 130);

				//tH_̕\
				foreach (string folder in folders) {
					FilerItem filer_item = new Folder(folder);
					ListViewItem item = new ListViewItem(filer_item.NameWithoutExtension);//O
					item.SubItems.Add("<dir>");//gq
					item.SubItems.Add(filer_item.SizeDisplayString);//TCY
					item.SubItems.Add(filer_item.Info.LastWriteTime.ToString("yyyy/MM/dd hh:mm:ss"));//XV
					item.Tag = filer_item;
					list_view.Items.Add(item);
				}

				//t@C̕\
				string[] files = System.IO.Directory.GetFiles(current_path);
				foreach (string file in files) {
					FilerItem filer_item = new File(file);
					ListViewItem item = new ListViewItem(filer_item.NameWithoutExtension);//O
					item.SubItems.Add(filer_item.Info.Extension);//gq
					item.SubItems.Add(filer_item.SizeDisplayString);//TCY
					item.SubItems.Add(filer_item.Info.LastWriteTime.ToString("yyyy/MM/dd hh:mm:ss"));//XV
					item.Tag = filer_item;
					list_view.Items.Add(item);
				}

				list_view.Sort();

				//ACe΁Aԏ̂̂ɑIĂԂɂ
				if (list_view.Items.Count > 0) {
					list_view.Items[0].Selected = true;
					list_view.Items[0].Focused = true;
					list_view.Focus();
				}
				
				//pl̕\
				current_path_text.Text = current_path;
				System.IO.DriveInfo drive_info = new System.IO.DriveInfo(current_path.Substring(0,1));
				drive_info_label.Text = "Drive Info:  " + drive_info.VolumeLabel + "(" + drive_info.RootDirectory + ") /"
					+ " Free " + DisplayUtil.sizeToString(drive_info.TotalFreeSpace) + " / Total "
					+ DisplayUtil.sizeToString(drive_info.TotalSize);

				folder_info_label.Text = "Folder Info:  " + folders.Length + " folders / " + files.Length + " files";

				ResumeLayout();
			} catch (UnauthorizedAccessException e) {
				MainForm.Instance.printToStatusbar("[error]"+e.Message);
			}
		}

		private void file_list_view_KeyDown(object sender, KeyEventArgs e) {
			if (mode == ViewMode.IncrementalSearch) { //CN^T[`
				if (e.KeyCode == Keys.Escape) {
					exitIncrementalSearchMode();
					e.Handled = true;
					return;
				} else if ((!e.Control) && (!e.Shift) && (!e.Alt)) {
					if (addSearchChar(e.KeyCode.ToString()) == true) {
						e.Handled = true;
						return;
					}
				}
			}

			if (SCFiler2System.Instance.Option.KeyCommand.ChangeDriveByNumKey == true) {
				if (changeDriveByNumKey(e.KeyCode) == true) { //L[ŃhCuړ
					e.Handled = true;
					return;
				}
			}

			//CN^T[`ȊO
			if (KeyCommandManager.Instance.executeAction(e.Control, e.Alt, e.Shift, e.KeyCode) == true) {
				e.Handled = true;
				return;
			}

		}

		/// <summary>
		/// lXȃ[hAr[ԃm[}ȏԂɖ߂
		/// </summary>
		private void setViewModeNormal() {
			if (mode == ViewMode.IncrementalSearch) {
				exitIncrementalSearchMode();
			}
			mode = ViewMode.Normal;
		}

		/// <summary>
		/// r[ANeBuɂȂƂ̐Fɐ؂ւ
		/// </summary>
		private void setActiveViewColor() {
			current_path_text.BackColor = SCFiler2System.Instance.Option.Color.ActiveViewTitleBack;
			current_path_text.ForeColor = SCFiler2System.Instance.Option.Color.ActiveViewTitleText;
		}

		/// <summary>
		/// r[ANeBûƂ̐Fɂ
		/// </summary>
		private void setInactiveViewColor() {
			current_path_text.BackColor = SCFiler2System.Instance.Option.Color.InactiveViewTitleBack;
			current_path_text.ForeColor = SCFiler2System.Instance.Option.Color.InactiveViewTitleText;
		}


		private void FileView_Enter(object sender, EventArgs e) {
			MainForm main_form = MainForm.Instance;
			main_form.notifyFileViewFocused(this);

			setActiveViewColor();

		}

		private void FileView_Leave(object sender, EventArgs e) {
			setInactiveViewColor();
			exitIncrementalSearchMode();
		}

		private void list_view_DoubleClick(object sender, EventArgs e) {
			Action.Action.ExecuteFocusedItem.execute();
		}

		private void save() {
			SettingFile file = SettingFile.Instance;
			file.save(view_name, "LastPath", current_path);
		}

		private void load() {
			SettingFile file = SettingFile.Instance;
			string path = file.load(view_name, "LastPath");
			setPath(path);
		}

		/// <summary>
		/// Xgr[̃ACeSĂIBSđIԂSĉBtH[JX̂ACe̐Ԃɖ߂
		/// </summary>
		public void selectAll() {
			if (list_view.SelectedItems.Count == list_view.Items.Count) {
				foreach (ListViewItem item in list_view.Items) {
					if (item.Focused != true) {
						item.Selected = false;
					}
				}
			} else {
				foreach (ListViewItem item in list_view.Items) {
					item.Selected = true;
				}
			}
		}

		#region hbO&hbv֌W
		private enum ClickedMouseButton {
			Right,
			Left,
			None
		}
		private ClickedMouseButton mouse_click = ClickedMouseButton.None;

		private void list_view_ItemDrag(object sender, ItemDragEventArgs e) {
			//IACeFullNameXg
			string[] selected_files = FilerItem.getStringArrayFromFileList(this.SelectedFilerItems);

			//hbO
			DataObject data = new DataObject(DataFormats.FileDrop, selected_files);
			list_view.DoDragDrop(data, DragDropEffects.Copy | DragDropEffects.Move | DragDropEffects.Link);
			//ړƂ̂߂ɍĕ`悷
			updateView();
		}

		private void list_view_DragEnter(object sender, DragEventArgs e) {
			if (e.Data.GetDataPresent(DataFormats.FileDrop)) {
				e.Effect = DragDropEffects.Copy | DragDropEffects.Move;
			} else {
				e.Effect = DragDropEffects.None;
			}
			//NbNꂽ}EXoĂiDragDropŔłȂ߁j
			if ((e.KeyState & 2) == 2) {
				mouse_click = ClickedMouseButton.Right;
			} else {
				mouse_click = ClickedMouseButton.Left;
			}
		}

		/// <summary>
		/// ENbNhbv̎̃|bvAbvj[쐬
		/// </summary>
		/// <param name="files">hbvt@C̃t@C̔zBMenuItemTagɂăCxgnhɓn</param>
		/// <param name="e">hbv̎DragEventArg</param>
		/// <returns>ContextMenu</returns>
		private ContextMenu constructDropContextMenu(string[] files, DragEventArgs e) {
			ContextMenu context_menu = new ContextMenu();
			if ((e.AllowedEffect & DragDropEffects.Copy) == DragDropEffects.Copy) {
				MenuItem item = new MenuItem("ɃRs[", copyFilesEventHander);
				item.Tag = files;
				context_menu.MenuItems.Add(item);
			}
			if ((e.AllowedEffect & DragDropEffects.Move) == DragDropEffects.Move) {
				MenuItem item = new MenuItem("Ɉړ", moveFilesEventHander);
				item.Tag = files;
				context_menu.MenuItems.Add(item);
			}
			context_menu.MenuItems.Add("LZ",cancelEventHander);
			return context_menu;
		}

		private void copyFilesEventHander(Object sender, EventArgs e) {
			MenuItem item = (MenuItem)sender;
			string[] files = (string[])item.Tag;
			FilerItem.copy(files, current_path);
			updateView();
		}

		
		private void moveFilesEventHander(Object sender, EventArgs e) {
			MenuItem item = (MenuItem)sender;
			string[] files = (string[])item.Tag;
			FilerItem.move(files, current_path);
			updateView();
		}

		private void cancelEventHander(Object sender, EventArgs e) {
		}

		private void list_view_DragDrop(object sender, DragEventArgs e) {
			//hbvꂽt@C̎擾
			string[] files = (string[])e.Data.GetData(DataFormats.FileDrop, false);

			if (mouse_click == ClickedMouseButton.Right) { //ENbN烁j[o
				ContextMenu menu = constructDropContextMenu(files, e);
				menu.Show(this, PointToClient(new Point(e.X, e.Y)));
			} else if (((e.KeyState & 8) == 8) && ((e.AllowedEffect & DragDropEffects.Copy) == DragDropEffects.Copy)) {
				//CtrlĂRs[ (8Ctrl\)
				FilerItem.copy(files, current_path);
				updateView();
			} else if ((e.AllowedEffect & DragDropEffects.Move) == DragDropEffects.Move) {
				FilerItem.move(files, current_path);
				updateView();
			}
			mouse_click = ClickedMouseButton.None;
		}
		#endregion

		private bool changeDriveByNumKey(Keys key) {
			Dictionary<Keys, string> valid_keys = new Dictionary<Keys, string>();
			valid_keys.Add(Keys.D1, @"A:\");
			valid_keys.Add(Keys.D2, @"B:\");
			valid_keys.Add(Keys.D3, @"C:\");
			valid_keys.Add(Keys.D4, @"D:\");
			valid_keys.Add(Keys.D5, @"E:\");
			valid_keys.Add(Keys.D6, @"F:\");
			valid_keys.Add(Keys.D7, @"G:\");
			valid_keys.Add(Keys.D8, @"H:\");
			valid_keys.Add(Keys.D9, @"I:\");
			if (valid_keys.ContainsKey(key)) {
				setPath(valid_keys[key]);
				return true;
			} else {
				return false;
			}
		}

		#region CN^T[`
		private string search_string = ""; //
		/// <summary>
		/// ANV֌JCN^T[`Jn\bh
		/// </summary>
		public void incrementalSearch() {
			if (mode == ViewMode.Normal) {
				enterIncrementalSearchMode();
				return;
			} else {
				searchNext(false);
			}
		}

		/// <summary>
		/// CN^T[`̕ǉ
		/// </summary>
		/// <param name="s">ǉ镶</param>
		/// <returns>true/Ȃfalse</returns>
		public bool addSearchChar(string s) {
			//L͕񒷂PƂŎBƂłƎ悢
			if (s.Length != 1) {
				if (s == Keys.Back.ToString()) {
					try {
						search_string = search_string.Remove(search_string.Length - 1);
					} catch (ArgumentException) {
						return true; //""̏ԂBackSpaceĂȂBA͒lƂĂ͗LȂ̂trueԂ
					}
				} else {
					return false;
				}
			} else {
				search_string += s.ToLower(); //ɓꂵĔr
			}
			searchNext(true);
			return true;
		}

		/// <summary>
		/// ACě
		/// </summary>
		/// <param name="start_from_selected_item">ݑI𒆂̃ACen߂邩ǂBfalsȅꍇ͑IACe̎</param>
		private void searchNext(bool start_from_selected_item) {
			int start_index = 0;
			string print_string = "Incremental Search: " + search_string;
			//ǂn߂邩߂
			if (list_view.SelectedItems.Count > 0) {
				if (start_from_selected_item == true) {
					start_index = list_view.SelectedItems[0].Index;
				} else {
					start_index = list_view.SelectedItems[0].Index + 1;
				}
			}
			//
			int index = start_index;
			while (true) {
				FilerItem item = (FilerItem)list_view.Items[index].Tag;
				string name = item.NameWithoutExtension.ToLower();
				if (name.IndexOf(search_string) >= 0) {
					//SĂ̑I
					foreach (ListViewItem old_selected_item in list_view.SelectedItems) {
						old_selected_item.Selected = false;
					}
					//ACeI
					list_view.Items[index].Focused = true;
					list_view.Items[index].Selected = true;
					list_view.EnsureVisible(index);
					break;
				}

				index++;
				if (index == list_view.Items.Count) {
					index = 0;
				}
				if (index == start_index) {
					print_string += " (Not Found)";
					break;
				}
			}
			MainForm.Instance.printToStatusbar(print_string);
		}

		/// <summary>
		/// CN^T[`[hJn
		/// </summary>
		private void enterIncrementalSearchMode() {
			mode = ViewMode.IncrementalSearch;
			search_string = "";
			MainForm.Instance.printToStatusbar("Incremental Search: (Enter Search String)");
		}

		/// <summary>
		/// CN^T[`[hI
		/// </summary>
		private void exitIncrementalSearchMode() {
			if (mode == ViewMode.IncrementalSearch) {
				mode = ViewMode.Normal;
				MainForm.Instance.printToStatusbar("");
			}
		}
		#endregion CN^T[`

		private void list_view_KeyPress(object sender, KeyPressEventArgs e) {
			//CN^T[`[h疳悤ɂ
			//ȂƃftHg̃L[ŁAꂽL[̃ACeɈړ邩
			if (mode == ViewMode.IncrementalSearch) {
				e.Handled = true;
			}
		}

		private void list_view_MouseUp(object sender, MouseEventArgs e) {
			if (e.Button == MouseButtons.Right && list_view.SelectedItems.Count > 0) {
				FilerItem item = (FilerItem)list_view.SelectedItems[0].Tag;
				list_view.ContextMenu = ViewContextMenu.Instance.getContextMenu(item);
			}
		}

		private void current_path_text_KeyDown(object sender, KeyEventArgs e) {
			if (e.KeyData == Keys.Enter) {
				setPath(current_path_text.Text);
			}
		}

		private void current_path_text_MouseClick(object sender, MouseEventArgs e) {

		}

		private void current_path_text_MouseUp(object sender, MouseEventArgs e) {
		}

		private void current_path_text_MouseMove(object sender, MouseEventArgs e) {
		}

		private void list_view_ColumnClick(object sender, ColumnClickEventArgs e) {
			sorter.setColumn(e.Column);
			list_view.Sort();
		}

		private void list_view_SizeChanged(object sender, EventArgs e) {
		}

	}
}
