using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.Util;

namespace SCFiler2.FileSystem {
	abstract public class HistoryManager {
		private List<FilerItem> history_list = new List<FilerItem>();
		private HistoryView view;
		private string view_name;
		private const int max_list_num = 30;
		private int loaded_item_num; //loadƂACeĂƂinit@C߂ɓǂݍݐۑĂ

		/// <summary>
		/// HistoryManagerɓo^ĂACeꗗ
		/// </summary>
		public List<FilerItem> ItemList {
			get { return history_list; }
		}

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="view">HistoryManagerΉHistoryView</param>
		/// <param name="view_name">HistoryMangerɑΉr[̖OBt@Cւ̐ݒۑƁAtH[̕\Ɏg</param>
		public HistoryManager(HistoryView view, string view_name) {
			this.view = view;
			this.view_name = view_name;
		}

		/// <summary>
		/// FullNameFilerItem(HistoryManagerɉAFileFolder)̃CX^X쐬Bݒt@C痚ǂݍޗp
		/// </summary>
		/// <param name="item_fullname">肽ACeFullName</param>
		/// <returns>쐬CX^X</returns>
		abstract protected FilerItem createNewItem(string item_fullname);

		/// <summary>
		/// sꂽACeo^Ώۂ̃ACeǂԂ
		/// </summary>
		/// <param name="item">sꂽACe</param>
		/// <returns>o^Ώۂ̃ACetrue</returns>
		abstract protected bool isRegister(FilerItem item);

		/// <summary>
		/// o^IFilerItemԂ\bh
		/// sꂽt@Co^t@C̎̂
		/// </summary>
		/// <param name="item">sꂽACe</param>
		/// <returns>Historyɓo^邽߂Item</returns>
		abstract protected FilerItem createNewItemFromExecutedItem(FilerItem item);

		/// <summary>
		/// itemsꂽƂʒm
		/// </summary>
		/// <param name="item">sꂽACe</param>
		public void notifyItemExecuted(FilerItem item) {
			if (isRegister(item) == false) {
				return;
			}
			FilerItem regist_item = createNewItemFromExecutedItem(item);

			//łɂ폜iԏɒǉ邽߁j
			foreach (FilerItem one in history_list) {
				if (one.Info.FullName == regist_item.Info.FullName) {
					history_list.Remove(one);
					break;
				}
			}
			
			history_list.Insert(0, regist_item);
			if (history_list.Count > max_list_num) {
				history_list.RemoveAt(history_list.Count-1);
			}
			view.updateView();
		}

		/// <summary>
		/// ݒt@C痚Ɛݒǂݍ
		/// </summary>
		virtual public void load() {
			SettingFile file = SettingFile.Instance;
			try {
				int num = file.loadInt(view_name, "Num", 0);
				for (int i = 0; i < num; i++) {
					string str = file.load(view_name, "History" + i);
					history_list.Add(createNewItem(str));
				}
				loaded_item_num = num;
			} catch (Exception) {
				SCFiler2System.showHistoryMessage("[HistoryManager]̓ǂݍ݂Ɏs܂");
				//sƍsȂ̂őSăNA
				history_list.Clear();
				loaded_item_num = 0;
			}
		}

		/// <summary>
		/// ݒt@CɗƐݒ
		/// </summary>
		virtual public void save() {
			SettingFile file = SettingFile.Instance;
			int index = 0;

			file.save(view_name, "Num", history_list.Count.ToString());
			for (index = 0; index < history_list.Count; index++) {
				file.save(view_name, "History" + index, history_list[index].Info.FullName);
			}
			//ǂݍ񂾐菭Ȃꍇ͏
			for (; index < loaded_item_num; index++) {
				file.save(view_name, "History" + index, null);
			}
		}
	}
}
