using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SCFiler2.FileSystem;

namespace SCFiler2 {
	public partial class JumpFolderForm : Form {
		private JumpFolder selected_jumpfolder = null;
		private JumpFolderManager manager = null;

		public JumpFolderForm() {
			InitializeComponent();
		}

		public JumpFolder SelectedJumpFolder {
			get { return selected_jumpfolder; }
		}

		private void JumpFolderForm_Load(object sender, EventArgs e) {
			manager = JumpFolderManager.Instance;
			refleshJumpFolderList();
		}

		/// <summary>
		/// WvtH_̃Xg`悷
		/// </summary>
		private void refleshJumpFolderList() {
			jump_folders_listview.Items.Clear();
			List<JumpFolder> list = JumpFolderManager.Instance.JumpFolders;
			for (int i = 0; i < list.Count; i++) {
				ListViewItem item = new ListViewItem(list[i].Folder.Info.Name);
				item.Tag = list[i];
				jump_folders_listview.Items.Add(item);
			}
			//֗Ȃ悤ɍŏ̃ACeɃtH[JX𓖂ĂĂ
			if (jump_folders_listview.Items.Count > 0) {
				jump_folders_listview.Items[0].Focused = true;
				jump_folders_listview.Items[0].Selected = true;
			}
		}

		private void ok_button_Click(object sender, EventArgs e) {
			this.DialogResult = DialogResult.OK;
			if (jump_folders_listview.SelectedItems.Count > 0) {
				ListViewItem item = jump_folders_listview.SelectedItems[0];
				selected_jumpfolder = (JumpFolder)item.Tag;
			} 
			Close();
		}

		private void cancel_button_Click(object sender, EventArgs e) {
			Close();
		}

		private void item_up_button_Click(object sender, EventArgs e) {
			JumpFolderManager.Instance.itemOrderUp((JumpFolder)jump_folders_listview.SelectedItems[0].Tag);
			refleshJumpFolderList();
		}

		private void item_down_button_Click(object sender, EventArgs e) {
			JumpFolderManager.Instance.itemOrderDown((JumpFolder)jump_folders_listview.SelectedItems[0].Tag);
			refleshJumpFolderList();
		}
	}
}