package Scheduler::Data::base;

use strict;
use warnings;
use Carp;

use DynamicHTTP;
use Encode qw|decode|;
use Scheduler::Data::XML::Feed;

sub reload{
  my $oS = shift;
  my $oSche = shift;
  return if !defined $oSche;
  my $sLatestURI = $oSche->uris->[0];
  my @asURIs = @{$oSche->uris};
  $oS->loadScheFromURI($asURIs[1],$sLatestURI);
}
sub loadScheFromURI($$){
  my $oS = shift;
  my $sURI = shift;
  my $sLatestURI = shift;
  my $oDH = new DynamicHTTP(temp_dir=>$oS->{path});
  my $sFeed = $oDH->get($sURI);
  $sFeed = decode('utf-8',$sFeed);
  my $oFeed = Scheduler::Data::XML::Feed->objFromDocstring($sFeed);
  $oFeed->sche->[0]->addURIToTop($sLatestURI);
  $oS->updateSche($oFeed->sche->[0]->id,$oFeed->sche->[0]);
}

1;
