package Scheduler::Data::XML::Sche::Changeable;
@ISA = qw|Scheduler::Data::XML::base|;

use strict;
use warnings;
use Carp;

use Scheduler::Data::XML::base;
use Scheduler::Sche::Changeable;
use Scheduler::Sche::Time::Optimized;
use Scheduler::Data::XML::Sche::Changeable;
use Scheduler::Data::XML::Sche::Time;
use Scheduler::Data::XML::Sche::Author;
use Scheduler::Data::XML::Sche::Location;
use Scheduler::Data::XML::Sche::Changeable::Content;

sub obj($$){
  shift;
  my $oChangeable = new Scheduler::Sche::Changeable;
  my $oRoot = shift;
  my $oDocument = shift;
  my @a = $oRoot->getChildNodes;
  foreach(@a){
    if($_->nodeName eq 'modified'){
      $oChangeable->setModified(new Scheduler::Sche::Time::Optimized($_->firstChild->nodeValue));
    }elsif($_->nodeName eq 'title'){
      $oChangeable->setTitle($_->firstChild->nodeValue);
    }elsif($_->nodeName eq 'subtitle'){
      $oChangeable->setSubtitle($_->firstChild->nodeValue);
    }elsif($_->nodeName eq 'summary'){
      $oChangeable->setSummary($_->firstChild->nodeValue);
    }elsif($_->nodeName eq 'class'){
      $oChangeable->setClass($_->firstChild->nodeValue);
    }elsif($_->nodeName eq 'time'){
      $oChangeable->setTime(Scheduler::Data::XML::Sche::Time->obj($_,$oDocument));
    }elsif($_->nodeName eq 'author'){
      $oChangeable->addAuthor(Scheduler::Data::XML::Sche::Author->obj($_,$oDocument));
    }elsif($_->nodeName eq 'location'){
      $oChangeable->addLocation(Scheduler::Data::XML::Sche::Location->obj($_,$oDocument));
    }elsif($_->nodeName eq 'content'){
      $oChangeable->setContent(Scheduler::Data::XML::Sche::Changeable::Content->obj($_,$oDocument));
    }
  }
  return $oChangeable;
}
sub element($$){
  shift;
  my $oChangeable = shift;
  my $oDocument = shift;
  my $oRoot = $oDocument->createElement('changeable');
  if(defined $oChangeable->type){
    $oRoot->setAttribute('type',$oChangeable->type);
  }else{
    $oRoot->setAttribute('type','full');
  }
  $oRoot->appendTextChild('modified',$oChangeable->modified->ISO8601);
  $oRoot->appendTextChild('title',$oChangeable->title);
  if(defined $oChangeable->subtitle and $oChangeable->subtitle ne ''){
    $oRoot->appendTextChild('subtitle',$oChangeable->subtitle); }
  if(defined $oChangeable->summary and $oChangeable->summary ne ''){
    $oRoot->appendTextChild('summary',$oChangeable->summary); }
  $oRoot->appendChild(Scheduler::Data::XML::Sche::Time->element($oChangeable->time,$oDocument));
  $oRoot->appendTextChild('class',$oChangeable->class);
  my $oContent = Scheduler::Data::XML::Sche::Changeable::Content->element($oChangeable->content,$oDocument);
  $oRoot->appendChild($oContent) if defined $oContent;
  foreach(@{$oChangeable->locations}){
    $oRoot->addChild(Scheduler::Data::XML::Sche::Location->element($_,$oDocument));
  }
  foreach(@{$_->authors}){
    $oRoot->addChild(Scheduler::Data::XML::Sche::Author->element($_,$oDocument));
  }
  return $oRoot;
}

1;
