package Scheduler::Data::XML::Sche::Location::GPX;
@ISA = qw|Scheduler::Data::XML::base|;

use strict;
use warnings;
use Carp;

use Scheduler::Data::XML::base;
use Scheduler::Sche::Location::GPX;

sub obj($){
  shift;
  my $oGPX = new Scheduler::Sche::Location::GPX;
  my $oRoot = shift;
  my $oDocument = shift;
  my @a = $oRoot->getChildNodes;
  foreach(@a){
    if($_->nodeName eq 'wpt'){
      $oGPX->setLat($_->getAttribute('lat'));
      $oGPX->setLon($_->getAttribute('lon'));
      my @b = $_->getChildNodes;
      foreach(@b){
	if($_->nodeName eq 'name'){
	  $oGPX->setName($_->firstChild->nodeValue);
	}
      }
      last;
    }
  }
  return $oGPX;
}
sub element($){
  shift;
  my $oGPX = shift;
  my $oDocument = shift;
  my $oRoot = $oDocument->createElement('gpx');
  $oRoot->setNamespace('http://www.topografix.com/GPX/1/1','p');
  my $oWPT = $oDocument->createElement('wpt');
  $oWPT->setAttribute('lat',$oGPX->lat);
  $oWPT->setAttribute('lon',$oGPX->lon);
  $oWPT->appendTextChild('name',$oGPX->name);
  $oRoot->appendChild($oWPT);
  return $oRoot;
}

1;
