package Main;

use strict;
use warnings;
use Carp;

my $oConfigure;

# INCREDIBLE HACK!!!
# doing 'use lib' dynamically
BEGIN{
  use Configure;
  $oConfigure = new Configure;
  my @asLib = $oConfigure->get('LIB');
  foreach(@asLib){
    eval{push(@INC,$_);};
    print $@ if defined $@;
  }
}
use CGI qw|:standard|;

use Login;
use Langpack;
use Output;
use Section;
use Environment;
use Scheduler::Data::PlainText;
use Scheduler::LData::PlainText;
use Module::DynamicSubModule;

use constant SCRIPT_VERSION => '0.24';
use constant GENERATOR_NAME => 'storage.sche.xor';

sub run(){
    $Module::DynamicSubModule::isDebugMode = $oConfigure->get('DEBUG_MODE') || 0;
    
    my $oDat = new Scheduler::Data::PlainText(
					      path => $oConfigure->get('FILESYSTEM_PLAINTEXT_DAT_PATH'),
					      encoding => $oConfigure->get('PLAINTEXT_DAT_ENCODING'),
					      identifier => $oConfigure->get('DAT_IDENTIFIER'),
					      refresh_interval => $oConfigure->get('REFRESH_SECONDS'),
					      );
    my $oLDat = new Scheduler::LData::PlainText(
						path => $oConfigure->get('FILESYSTEM_PLAINTEXT_LOCATION_DAT_PATH'),
						);
    my $oLng = new Langpack(
			    $oConfigure->get('LANGUAGE'),
			    type => $oConfigure->get('LANGUAGE_PACK_TYPE'),
			    );
    my $oEnv = new Environment(
			       path          => $oConfigure->get('FILESYSTEM_PLAINTEXT_DAT_PATH'),
			       storageURI    => $oConfigure->get('STORAGE_URI'),
			       proxyProtocol => $oConfigure->get('PROXY_PROTOCOL'),
			       proxyURI      => $oConfigure->get('PROXY_URI'),
			       googleMapID   => $oConfigure->get('GOOGLE_MAP_ID'),
			       timeZone      => $oConfigure->get('TIME_ZONE'),
			       generatorName => GENERATOR_NAME,
			       scriptVersion => SCRIPT_VERSION,
			       );
    my $oCGI = new CGI;
    my $oLgi = new Login(
			 sessionIDDir  => $oConfigure->get('FILESYSTEM_PLAINTEXT_DAT_PATH').'/session/',
			 oCGI => $oCGI,
			 userName => $oConfigure->get('USER_NAME'),
			 userPass => $oConfigure->get('USER_PASS'),
			 userPassDigest => $oConfigure->get('USER_PASS_DIGEST'),
			 userPassDigestAlgo => $oConfigure->get('USER_PASS_DIGEST_ALGO'),
			 identifier => $oConfigure->get('DAT_IDENTIFIER'),
			 );
    my $oOut = new Output(
			  oLng => $oLng,
			  oEnv => $oEnv,
			  oLgi => $oLgi,
			  oCGI => $oCGI,
			  encoding => $oConfigure->get('OUTPUT_ENCODING'),
			  dataDirUri => $oConfigure->get('DATA_DIR_URI'),
			  );
    
    my %hEnv = (
		oCGI=>$oCGI,
		oOut=>$oOut,
		oDat=>$oDat,
		oEnv=>$oEnv,
		oLng=>$oLng,
		oLgi=>$oLgi,
		oLDat=>$oLDat,
		oConfigure => $oConfigure,
		);
    my $sMode = $oCGI->param('mode');
    if(!$oConfigure->isAllNeededInfoInside){
	Section->Setting(%hEnv)->outHTML;
    }else{
	if($oLgi->isLoggedIn){
	    if(defined $sMode){
		if($sMode eq 'edit'){
		    Section->Edit(%hEnv)->outHTML;
		}elsif($sMode eq 'preview'){
		    Section->Preview(%hEnv)->outHTML;
		}elsif($sMode eq 'update'){
		    Section->Update(%hEnv)->outHTML;
		}elsif($sMode eq 'detail'){
		    Section->Detail(%hEnv)->outHTML;
		}elsif($sMode eq 'xsche'){
		    Section->Xsche(%hEnv)->out;
		}elsif($sMode eq 'schedul'){
		    Section->Schedul(%hEnv)->out;
		}elsif($sMode eq 'duplicate'){
		    Section->Duplicate(%hEnv)->outHTML;
		}elsif($sMode eq 'delete'){
		    Section->Delete(%hEnv)->outHTML;
		}elsif($sMode eq 'execute'){
		    Section->Execute(%hEnv)->outHTML;
		}elsif($sMode eq 'import'){
		    Section->Import(%hEnv)->outHTML;
		}elsif($sMode eq 'search'){
		    Section->SearchBox(%hEnv)->outHTML;
		}elsif($sMode eq 'locationlib'){
		    Section->LocationLib(%hEnv)->out;
		}elsif($sMode eq 'channel'){
		    Section->Channel(%hEnv)->outHTML;
		}elsif($sMode eq 'setting'){
		    Section->Setting(%hEnv)->outHTML;
		}elsif($sMode eq 'logout'){
		    Section->Logout(%hEnv)->outHTML;
		}elsif($sMode eq 'linkgen'){
		    Section->LinkGen(%hEnv)->outHTML;
		}else{
		  Section->List(%hEnv)->outHTML;
		}
	    }else{
		Section->List(%hEnv)->outHTML;
	    }
	}else{
	    if(defined $sMode){
		if($sMode eq 'detail'){
		    Section->Detail(%hEnv)->outHTML;
		}elsif($sMode eq 'login'){
		    Section->Login(%hEnv)->out;
		}elsif($sMode eq 'xsche'){
		    Section->Xsche(%hEnv)->out;
		}elsif($sMode eq 'schedul'){
		    Section->Schedul(%hEnv)->out;
		}elsif($sMode eq 'search'){
		    Section->SearchBox(%hEnv)->outHTML;
		}elsif($sMode eq 'linkgen'){
		    Section->LinkGen(%hEnv)->outHTML;
		}else{
		  Section->List(%hEnv)->outHTML;
		}
	    }else{
		Section->List(%hEnv)->outHTML;
	    }
	}
    }
}
1;
