package Scheduler::Data::XML::Sche::Changeable::Content;
@ISA = qw|Scheduler::Data::XML::base|;

use strict;
use warnings;
use Carp;

use Scheduler::Data::XML::base;
use Scheduler::Data::XML::Sche::Changeable::Content::PlainText;
use Scheduler::Data::XML::Sche::Changeable::Content::HyperLink;
use Scheduler::Data::XML::Sche::Changeable::Content::XHTML;

sub obj($$){
  shift;
  my $oRoot = shift;
  my $oDocument = shift;
  my $oContent;
  if($oRoot->getAttribute('type') eq 'link'){
    $oContent = Scheduler::Data::XML::Sche::Changeable::Content::HyperLink->obj($oRoot,$oDocument);
  }elsif($oRoot->getAttribute('type') eq 'xhtml'){
    $oContent = Scheduler::Data::XML::Sche::Changeable::Content::XHTML->obj($oRoot,$oDocument);
  }else{
    $oContent = Scheduler::Data::XML::Sche::Changeable::Content::PlainText->obj($oRoot,$oDocument);
  }
  return $oContent;
}
sub element($$){
  shift;
  my $oContent = shift;
  my $oDocument = shift;
  return if !defined $oContent or $oContent->isEmpty;
  if($oContent->type eq 'link'){
    return Scheduler::Data::XML::Sche::Changeable::Content::HyperLink->element($oContent,$oDocument);
  }elsif($oContent->type eq 'xhtml'){
    return Scheduler::Data::XML::Sche::Changeable::Content::XHTML->element($oContent,$oDocument);
  }else{
    return Scheduler::Data::XML::Sche::Changeable::Content::PlainText->element($oContent,$oDocument);
  }
}

1;
