package Scheduler::Sche::Changeable;

use strict;
use warnings;
use Carp;

use Scheduler::Sche::Author;
use Scheduler::Sche::Time;
use Scheduler::Sche::Location;
use Scheduler::Sche::Changeable::Content;
use Scheduler::Sche::Time::Optimized;

sub new(){
  shift;
  return bless {
		modified => undef,
		title => undef,
		subtitle => undef,
		summary => undef,
		contents => undef,
		time => undef,
		location => [],
		class => undef,
		author => [],
		reloadinterval => 600,
	       };
}
sub type{'full';}

sub modified{$_[0]->{modified};}
sub title{$_[0]->{title};}
sub subtitle{$_[0]->{subtitle};}
sub summary{$_[0]->{summary};}
sub content{$_[0]->{content};}
sub locations{$_[0]->{location};}
sub time{$_[0]->{time};}
sub class{$_[0]->{class};}
sub authors{$_[0]->{author};}
sub reloadinterval{$_[0]->{reloadinterval};}

sub setModified{$_[0]->{modified} = $_[1];}
sub setTitle{$_[0]->{title} = $_[1];}
sub setSubtitle{$_[0]->{subtitle} = $_[1];}
sub setSummary{$_[0]->{summary} = $_[1];}
sub setContent{$_[0]->{content} = $_[1];}
sub addLocation{push(@{$_[0]->{location}},$_[1]);}
sub setTime{$_[0]->{time} = $_[1];}
sub setClass{$_[0]->{class} = $_[1];}
sub addAuthor{push(@{$_[0]->{author}},$_[1]);}
sub setReloadinterval{$_[0]->{reloadinterval} = $_[1];}

sub clone{
  my $oS = shift;
  my $oSNew = new Scheduler::Sche::Changeable;
  $oSNew->setModified($oS->modified->clone);
  $oSNew->setTitle($oS->title);
  $oSNew->setSubtitle($oS->subtitle);
  $oSNew->setSummary($oS->summary);
  $oSNew->setContent($oS->content->clone) if defined $oS->content;
  $oSNew->addLocation($_->clone) for @{$oS->locations};
  $oSNew->setTime($oS->time->clone);
  $oSNew->setClass($oS->class);
  $oSNew->addAuthor($_->clone) for @{$oS->authors};
  $oSNew->setReloadinterval($oS->reloadinterval);
  return $oSNew;
}

1;
