package Langpack::PlainTextLoader;

use strict;
use warnings;
use Carp;

use IO::File;
use File::Find;
use Encode qw|decode|;

sub new(%){
  shift;
  my %hE = @_;
  return bless{
	       isLoaded => 0,
	       rhasMap => undef,
	       language => $hE{language},
	       encoding => undef,
	      };
}
sub load(){
  my $oS = shift;
  return if !-e './Langpack/'.$oS->{language};
  my $sFileName;
  find(sub{
	 return if $_ !~ m|^map\.(.+)$|;
	 return if index($1,'.') != -1;
	 $oS->{encoding} = $1;
	 $sFileName = $File::Find::name if !$sFileName;
       },'./Langpack/'.$oS->{language});
  my $oI = new IO::File($sFileName);
  while(<$oI>){
    next if substr($_,0,1) eq '#';
    chomp;
    next if $_ eq '';
    my ($sKey,@asValue) = split(m|[\s\t]+|,$_);
    my $sValue = join(' ',@asValue);
    $sValue = decode($oS->{encoding},$sValue) if defined $oS->{encoding};
    $oS->{rhasMap}->{$sKey} = $sValue;
  }
  undef $oI;
  $oS->{isLoaded} = 1;
}
sub get($){
  my $oS = shift;
  my $sKey = shift;
  $oS->load unless $oS->{isLoaded};
  return $sKey if !exists $oS->{rhasMap}->{$sKey};
  return $oS->{rhasMap}->{$sKey};
}

1;
