package Section::Import;
@ISA = qw|Section::base|;

use strict;
use warnings;
use Carp;

use Section::base;
use Encode qw|decode|;
use DynamicHTTP;
use Scheduler::Parser::Feed;
use Scheduler::Schema::Feed;
use Scheduler::Schema::Time;

sub new{
  shift;
  return bless Section::base->new(@_);
}
sub out($){
  my $oS = shift;
  $oS->oOut->setSubtitle('Import');
  my $sStat = $oS->oCGI->param('import');
  my $sRes = $oS->oOut->sectionBegin('IMPORT','import');
  if(!defined $sStat){
    $sRes .= $oS->outTop;
  }elsif($sStat eq 'findURI'){
    $sRes .= $oS->outFindURI;
  }elsif($sStat eq 'PlainXSCHE'){
    $sRes .= $oS->outPlainXSCHE;
  }elsif($sStat eq 'uploadFile'){
    $sRes .= $oS->outUploadFile;
  }elsif($sStat eq 'regist'){
    $sRes .= $oS->outRegist;
  }
  return $sRes.$oS->oOut->sectionEnd;
}
sub outFindURI{
  my $oS = shift;
  $oS->setHistoryStack('import:finduri');
  my $oDH = new DynamicHTTP(temp_dir => $oS->oEnv->path,
			    loader => $oS->oEnv->loader);
  my $sFeed = $oDH->get($oS->oCGI->param('uri'));
  return '<p>An error occured. Log is shown below.</p><pre>'.$oDH->log.'</pre>' if !defined $sFeed or $sFeed eq '';
  $sFeed = decode('utf-8',$sFeed);
  my $oFeed = Scheduler::Parser::Feed->objFromDocstring($sFeed);
  my $sRes = '<form method="post" action="index.cgi">';
  $sRes .= '<input type="hidden" name="uri" value="'.$oS->oCGI->param('uri').'" />';
  $sRes .= '<table><thead><tr><th></th><th>ID</th><th>'.$oS->getEncLng('MODIFIED').'</th><th>'.$oS->getEncLng('TITLE').'</th><th>'.$oS->getEncLng('IMPORT_STATUS').'</th></tr></thead><tbody>';
  foreach(@{$oFeed->sche}){
    my $oSche = $oS->oDat->getScheByID($_->id);
    my $sStatus = '';
    my $isNeeded = 1;
    if(!defined $oSche){
      $sStatus = $oS->getEncLng('IMPORT_STATUS_NEW');
    }else{
      my $oT = new Scheduler::Schema::Time;
      my $nImportedTime = $_->changeables->[0]->modified->time;
      my $nRemainedTime = $oSche->changeables->[0]->modified->time;
      if($nImportedTime > $nRemainedTime){
	$sStatus = $oS->getEncLng('IMPORT_STATUS_UPDATE');
      }elsif($nImportedTime < $nRemainedTime){
	$isNeeded = 0;
	$sStatus = $oS->getEncLng('IMPORT_STATUS_OLD');
      }else{
	$isNeeded = 0;
	$sStatus = $oS->getEncLng('IMPORT_STATUS_SAME');
      }
    }
    $sRes .= '<tr><td>';
    $sRes .= '<input type="checkbox" name="needed_id" value="'.$_->id.'" '.($isNeeded?'checked="checked"':'').'/>';
    my $sModifiedTime = $oS->timeDisp($_->changeables->[0]->modified);
    $sRes .= '</td><td>'.$_->id.'</td><td>'.$sModifiedTime.'</td><td>'.$oS->oOut->encoded($_->changeables->[0]->title).'</td><td>'.$sStatus.'</td></tr>';
  }
  $sRes .= '</tbody></table>';
  $sRes .= '<p>'.$oS->getEncLng('IMPORT_ADDING_THIS_SCHE').'</p><input type="submit" value="'.$oS->getEncLng('IMPORT_ADD_THIS_SCHE').'" />';
  $sRes .= '<input type="hidden" name="hstack" value="'.$oS->getHistoryStack.'" /><input type="hidden" name="mode" value="import" /><input type="hidden" name="import" value="regist" />';
  $sRes .= '<h1>'.$oS->getEncLng('IMPORT_LOG').'</h1><pre>'.$oDH->log.'</pre>';
  return $sRes;
}
sub outPlainXSCHE{
  my $oS = shift;
  my $sPlainText = $oS->oOut->decoded($oS->oCGI->param('xsche'));
  my $oFeed = new Scheduler::Schema::Feed;
  $oFeed->setString($sPlainText);
  my $aoSche = $oFeed->sche;
}
sub outUploadFile{
  my $oS = shift;
  my $oFileHandle = $oS->oCGI->param('filename');
  my ($sBuffer,$sSche);
  while(read($oFileHandle,$sBuffer,$1024)){
    $sSche .= $sBuffer;
  }
  return $sSche;
}
sub outRegist{
  my $oS = shift;
  $oS->setHistoryStack('import:imported');
  my $sRes = '<p>'.$oS->getEncLng('IMPORT_SUCCESSFULLY').'</p><a href="index.cgi">'.$oS->getEncLng('BACK_TO_LIST').'</a>';
  my $oDH = new DynamicHTTP(temp_dir=>$oS->oEnv->path);
  my %hRIDs;
  foreach($oS->oCGI->param('needed_id')){
    $hRIDs{$_} = 1;
  }
  foreach($oS->oCGI->param('uri')){
    my $sFeed = $oDH->get($_);
    $sFeed = decode('utf-8',$sFeed);
    my $oFeed = new Scheduler::Schema::Feed;
    $oFeed = Scheduler::Parser::Feed->objFromDocstring($sFeed);
    foreach(@{$oFeed->sche}){
      next if !exists $hRIDs{$_->id};
      $_->addNewURI($oS->oEnv->storageURI.'?mode=xsche&id='.$_->id);
      $oS->oDat->setSche($_,1);
    }
  }
  $oS->oDat->optimize;
  return $sRes;
}
sub outTop{
  my $oS = shift;
  $oS->setHistoryStack('import:top');
  return '<fieldset><legend>'.$oS->getEncLng('IMPORT_BY_URI')
    .'</legend><form method="post" action="index.cgi"><input type="hidden" name="hstack" value="'.$oS->getHistoryStack.'" />URI:<input type="text" name="uri" /><input type="hidden" name="mode" value="import" /><input type="hidden" name="import" value="findURI" /><input type="submit" value="'.$oS->getEncLng('IMPORT_BY_URI_LOAD').'" /></form></fieldset><!--<fieldset><legend>'
      .$oS->getEncLng('IMPORT_BY_DIRECT_XML').'</legend><form method="post" action="index.cgi"><textarea name="xsche"></textarea><input type="hidden" name="mode" value="import" /><input type="hidden" name="import" value="registPlainXSCHE" /><input type="submit" value="'.$oS->getEncLng('IMPORT_BY_DIRECT_XML_REGIST').'" /></form></fieldset><fieldset><legend>'
	.$oS->getEncLng('IMPORT_BY_UPLOADING_SCHE').'</legend><form method="post" action="index.cgi"><input type="file" name="filename"><input type="hidden" name="mode" value="import" /><input type="hidden" name="import" value="uploadFile" /><input type="submit" value="'.$oS->getEncLng('IMPORT_BY_UPLOADING_SCHE_UPLOAD').'" /></form></fieldset>-->';
}

1;
