package Section::Setting;
@ISA = qw|Section::base|;

use strict;
use warnings;
use Carp;

use Section::base;
use IO::File;

sub new{
  shift;
  return bless Section::base->new(@_);
}
sub out($){
  my $oS = shift;
  $oS->oOut->setSubtitle('Setting');
  my $sRes = $oS->oOut->sectionBegin('SETTING','setting');
  if($oS->oCGI->param('setting') eq 'update'){
    $sRes .= $oS->updateSetting;
  }elsif($oS->oCGI->param('setting') eq 'preview'){
    $sRes .= $oS->previewSetting;
  }else{
    $sRes .= $oS->outSettingForm;
  }
  return $sRes.$oS->oOut->sectionEnd;
}
sub outSettingForm($$){
  my $oS = shift;
  my (@asErrors,%hsDefault);
  if(defined $_[0] and defined $_[1]){
    @asErrors = @{$_[0]};
    %hsDefault = %{$_[1]};
  }
  $oS->oOut->isUsingPrototypeJS;
  my $sHeader = '<script type="text/javascript">
//<![CDATA[
';
  $sHeader .= $_ while <DATA>;
  $sHeader .= '//]]></script>';
  $oS->oOut->addHeaderEx($sHeader);undef $sHeader;
  my %hEl;
  foreach(qw|USER LIB FILESYSTEM_PLAINTEXT_DAT_PATH FILESYSTEM_PLAINTEXT_LOCATION_DAT_PATH DAT_IDENTIFIER LOCATION_DAT_PATH STORAGE_URI DATA_DIR_URI OUTPUT_ENCODING LANGUAGE USER_NAME GOOGLE_MAP_ID TIME_ZONE REFRESH_SECONDS|){
    if(defined $hsDefault{lc($_)}){
      $hEl{$_} = $hsDefault{lc($_)};
    }else{
      $hEl{$_} = $oS->oConfigure->get($_);
    }
  }
  $hEl{USER} = 'checked="checked" 'if defined $hEl{USER} or !defined $hEl{USER_NAME};
  $oS->oOut->setBodyTagAttribute('onload','setUserEditForm('.$hEl{USER}.');');
  my $sRes = '';
  if(defined $asErrors[0]){
    $sRes .= '<ul>';
    $sRes .= '<li>'.$_.'</li>' foreach @asErrors;
    $sRes .= '</ul>';
  }
  $sRes .= '<p>'.$oS->getEncLng('ASTERISK_FIELDS_ARE_REQUIRED').'</p>
<form action="index.cgi" method="POST">
<fieldset><legend>'.$oS->getEncLng('SETTING_USER_INFO').'</legend>
<p>'.$oS->getEncLng('SETTING_USER').'<input type="checkbox" name="setting_user" '.$hEl{USER}.' onclick="setUserEditForm();" /></p>
<div id="div_form_user">
<p>'.$oS->getEncLng('SETTING_USER_NAME').'<input type="text" name="setting_user_name" value="'.$hEl{USER_NAME}.'" /></p>
<p>'.$oS->getEncLng('SETTING_USER_PASSWORD').'<input type="password" name="setting_user_pass_primary" /></p>
<p>'.$oS->getEncLng('SETTING_USER_PASSWORD_AGAIN').'<input type="password" name="setting_user_pass_secondary" /></p>
</div></fieldset>
<fieldset><legend>'.$oS->getEncLng('SETTING_FILESYSTEM_INFO').'</legend>
<input type="radio" name="setting_filesystem_type" value="PlainText" onclick="setFilesystemEditForm(\'PlainText\');" checked="checked" />'.$oS->getEncLng('SETTING_PLAINTEXT').'
<input type="radio" name="setting_filesystem_type" value="BerkeleyDB" onclick="setFilesystemEditForm(\'BerkeleyDB\');" disabled="disabled" />'.$oS->getEncLng('SETTING_BERKELEYDB').'
<input type="radio" name="setting_filesystem_type" value="RDBMS" onclick="setFilesystemEditForm(\'RDBMS\');" disabled="disabled" />'.$oS->getEncLng('SETTING_RDBMS').'
<hr />
<div id="div_form_filesystem_PlainText">
<p>'.$oS->getEncLng('SETTING_PLAINTEXT_DAT_PATH').'*<input type="text" name="setting_filesystem_PlainText_dat_path" value="'.$hEl{FILESYSTEM_PLAINTEXT_DAT_PATH}.'" /></p>
<p>'.$oS->getEncLng('SETTING_PLAINTEXT_LOCATION_DAT_PATH').'*<input type="text" name="setting_filesystem_PlainText_location_dat_path" value="'.$hEl{FILESYSTEM_PLAINTEXT_LOCATION_DAT_PATH}.'" /></p>
</div>
</fieldset>
<fieldset><legend>'.$oS->getEncLng('SETTING_URI_INFO').'</legend>
<p>'.$oS->getEncLng('SETTING_STORAGE_URI').'*<input type="text" name="setting_storage_uri"  value="'.$hEl{STORAGE_URI}.'" /></p>
<p>'.$oS->getEncLng('SETTING_DATA_DIR_URI').'*<input type="text" name="setting_data_dir_uri" value="'.$hEl{DATA_DIR_URI}.'"  /></p>
</fieldset>
<fieldset><legend>'.$oS->getEncLng('SETTING_SERVER_INFO').'</legend>
<p>'.$oS->getEncLng('SETTING_TIMEZONE').'<input type="text" name="setting_timezone"  value="'.$hEl{TIME_ZONE}.'" disabled="disabled" /></p>
<p>'.$oS->getEncLng('SETTING_REFRESH_SECONDS').'*<input type="text" name="setting_refresh_seconds"  value="'.$hEl{REFRESH_SECONDS}.'" /></p>
<p>'.$oS->getEncLng('SETTING_DAT_IDENTIFIER').'*<input type="text" name="setting_dat_identifier"  value="'.$hEl{DAT_IDENTIFIER}.'" /></p>
</fieldset>
<fieldset><legend>'.$oS->getEncLng('SETTING_LANGUAGE_INFO').'</legend>
<p>'.$oS->getEncLng('SETTING_LANGUAGE').'<input type="text" name="setting_language"  value="'.$hEl{LANGUAGE}.'" /></p>
<p>'.$oS->getEncLng('SETTING_OUTPUT_ENCODING').'<input type="text" name="setting_output_encoding"  value="'.$hEl{OUTPUT_ENCODING}.'" disabled="disabled" /></p>
</fieldset>
<!--<fieldset><legend>'.$oS->getEncLng('SETTING_HTTP_AGENT_INFO').'</legend>
</fieldset>-->
<fieldset><legend>'.$oS->getEncLng('SETTING_GOOGLE_MAP_INFO').'</legend>
<p>'.$oS->getEncLng('SETTING_GOOGLE_MAP_ID').'*<input type="text" name="setting_google_map_id"  value="'.$hEl{GOOGLE_MAP_ID}.'" /></p>
</fieldset>'
;
  return $sRes.'<input type="hidden" name="mode" value="setting" /><input type="hidden" name="setting" value="preview" /><input type="submit" value="'.$oS->getEncLng('SETTING_UPDATE').'" /></form>';
}
sub previewSetting($$){
  my $oS = shift;
  my $sRes = '';
  $sRes = '<form action="index.cgi" method="POST" />
<input type="hidden" name="mode" value="setting" />
<input type="hidden" name="setting" value="update" />';
  my %hsParams;
  foreach(@{[$oS->oCGI->param]}){
    next if $_ eq 'mode' or $_ eq 'setting';
    $_ = substr($_,8);
    $hsParams{$_} = $oS->oCGI->param('setting_'.$_);
   }
  if(!defined $hsParams{user}){
    delete $hsParams{$_} foreach qw|user_name user_pass_primary user_pass_secondary|;
  }else{
    if($hsParams{user_pass_primary} ne $hsParams{user_pass_secondary}){
      return $oS->outSettingForm(['SETTING_WRONG_PASSWORD'],\%hsParams);
    }else{
      $hsParams{user_pass} = $hsParams{user_pass_primary};
      delete $hsParams{user_pass_primary};
      delete $hsParams{user_pass_secondary};
    }
  }
  foreach(sort keys %hsParams){
    $sRes .= '<input type="hidden" name="setting_'.$_.'" value="'.$hsParams{$_}.'" />';
  }
  $sRes .= '<table><thead></thead><tbody>';
  foreach(sort keys %hsParams){
    next if $_ eq 'user_pass_primary' or $_ eq 'user_pass_secondary';
    $hsParams{$_} = '(PASSWORD)' if $_ eq 'user_pass';
    $sRes .= '<tr><th>'.$_.'</th><td>'.$hsParams{$_}.'</td></tr>';
  }
  return $sRes.'</tbody></table><p>'.$oS->getEncLng('SETTING_IS_THIS_SETTING_OK').'</p><input type="submit" value="'.$oS->getEncLng('SETTING_IS_OK').'" /></form>';
}
sub updateSetting(){
  my $oS = shift;
  my $sRes = '';
  my %hsParams;
  foreach(@{[$oS->oCGI->param]}){
    next if $_ eq 'mode' or $_ eq 'setting';
    $_ = substr($_,8);
    $hsParams{$_} = $oS->oCGI->param('setting_'.$_);
  }
  if(!defined $hsParams{user}){
    delete $hsParams{$_} foreach qw|user_name user_pass_primary user_pass_secondary|;
  }else{
    if($hsParams{user_pass_primary} eq $hsParams{user_pass_secondary}){
      $oS->oConfigure->set('USER_NAME',$hsParams{user_name});
      if($oS->oConfigure->get('USER_PASS_DIGEST_ALGO') ne ''){
	my $sPassDigest = $oS->oLgi->digest($hsParams{user_pass});
	$oS->oConfigure->set('USER_PASS_DIGEST',$sPassDigest);
	$oS->oConfigure->delete('USER_PASS');
      }else{
	$oS->oConfigure->set('USER_PASS',$hsParams{user_pass});
      }
    }
  }
  foreach(keys %hsParams){
    next if $_ eq 'user';
    $oS->oConfigure->set(uc($_),$hsParams{$_});
  }
  $oS->oConfigure->update;
  return $sRes.'<p>'.$oS->getEncLng('SETTING_UPDATED').'</p><a href="index.cgi">'.$oS->getEncLng('BACK_TO_LIST').'</a>';
}

1;

__DATA__
var isUserOn;

function setFilesystemEditForm(_sType){
  var asTypes = new Array('PlainText','BerkeleyDB','RDBMS');
  var _i;
for(_i=0;_i<asTypes.length;_i++){
  var _div = $("div_form_filesystem_"+asTypes[_i]);
  if(asTypes[_i] == _sType){
    _div.show();
  }else{
    _div.hide();
  }
}
}
function setUserEditForm(_sName){
  if(_sName == undefined || _sName != ""){
    if(isUserOn != undefined){
      isUserOn = !isUserOn;
    }else{
      isUserOn = false;
    }
  }
  var _div = $("div_form_user");
  if(isUserOn){
    _div.show();
  }else{
    _div.hide();
  }
}
