package Section::base;

use strict;
use warnings;
use Carp;

use Date::Calc qw|Delta_Days Today|;
use Encode qw|encode|;
use Scheduler::Schema::Sche;
use Scheduler::Schema::Location;
use Scheduler::Schema::Generator;

sub new{
  shift;
  my %hE = @_;
  return bless {
		oCGI => $hE{oCGI},
		oOut => $hE{oOut},
		oDat => $hE{oDat},
		oEnv => $hE{oEnv},
		oLng => $hE{oLng},
		oLgi => $hE{oLgi},
		oLDat => $hE{oLDat},
		oConfigure => $hE{oConfigure},
		oCookie => undef,
	       };
}
sub out;
sub outHTML{
  my $oS = shift;
  my $sOut = $oS->out;
  print $oS->oOut->httpHeader(cookie => $oS->{oCookie}).$oS->oOut->htmlHeader.$sOut.$oS->oOut->htmlFooter;
}

sub oCGI{$_[0]->{oCGI};}
sub oOut{$_[0]->{oOut};}
sub oDat{$_[0]->{oDat};}
sub oEnv{$_[0]->{oEnv};}
sub oLng{$_[0]->{oLng};}
sub oLgi{$_[0]->{oLgi};}
sub oLDat{$_[0]->{oLDat};}
sub oConfigure{$_[0]->{oConfigure};}

sub env{
  my $oS = shift;
  my %hS = (oCGI => $oS->{oCGI},
	    oOut => $oS->{oOut},
	    oDat => $oS->{oDat},
	    oEnv => $oS->{oEnv},
	    oLng => $oS->{oLng},
	    oLgi => $oS->{oLgi},
	    oLDat => $oS->{oLDat},
	    oConfigure => $oS->{oConfigure},
	   );
  return %hS;
}
sub getEncLng($){
  my $oS = shift;
  my $sKey = shift;
  return '' if !defined $sKey;
  return $oS->oOut->encoded($oS->oLng->get($sKey));
}
sub submittedChangeables(){
  my $oS = shift;
  my %hsUniqNumID;
  my %hAuthor;
  foreach($oS->oCGI->param){
    if($_ =~ m|^n_(\d+)_([^.]+)$|){
      $hsUniqNumID{$1} = {} if !defined $hsUniqNumID{$1};
      my @asParams = $oS->oCGI->param($_);
      foreach(@asParams){
	$_ = $oS->oOut->decoded($_);
      }
      $hsUniqNumID{$1}->{$2} = defined $asParams[1]?\@asParams:$asParams[0];
    }
  }
  foreach(qw|name email uri|){
    $hAuthor{$_} = $oS->oCGI->param('n_author_'.$_);
    $hAuthor{$_} = $oS->oOut->decoded($hAuthor{$_});
  }
  my %hoChangeables = ();
  my $nNewScheUniqNum = 0;
  my $oAu = new Scheduler::Schema::Author;
  $oAu->setName($hAuthor{name});
  $oAu->setEmail($hAuthor{email});
  $oAu->setUri($hAuthor{uri});
  if(defined $oS->oCGI->param('n_author_use_cookie')){
    my $oC = $oS->oCGI->cookie(
			       -name => 'SCHE_STORAGE_AUTHOR',
			       -value => {
					  name  => $hAuthor{name},
					  email => $hAuthor{email},
					  uri   => $hAuthor{uri},
					 },
			       -expires => '+7d',
			      );
    $oS->{oCookie} = $oC;
  }
  foreach(keys %hsUniqNumID){
    my %hLocations = ();
    $_ = $hsUniqNumID{$_};
    my $oCh = new Scheduler::Schema::Changeable;
    my $sID;
    if($_->{uniq_num} eq 'new'){
      $sID = '#'.$nNewScheUniqNum;
      $nNewScheUniqNum++;
    }else{
      $sID = $_->{uniq_num};
    }
    if($_->{'location_type'} eq 'location_library'){
      if($_->{location_id} eq '#'){
	my $oSche = $oS->oDat->getScheByID($sID);
	my $oLo = $oSche->changeables->[0]->locations->[0];
	$oCh->addLocation($oLo);
      }elsif($_->{location_id} ne ''){
      	my $oLo = $oS->oLDat->getLByHash($_->{location_id});
	$oCh->addLocation($oLo);
      }
    }elsif($_->{'location_type'} eq 'name' and $_->{'location_name'} ne ''){
      my $oLo = new Scheduler::Schema::Location('Name');
      $oLo->setName($_->{'location_name'});
      $oCh->addLocation($oLo);
    }
    my $sContentType;
    my $oCo = new Scheduler::Schema::Content($_->{content_type});
    $oCo->set($_->{'content_'.$_->{content_type}});
    $oCh->setContent($oCo);
    $oCh->setTitle($_->{title});
    $oCh->setSubtitle($_->{subtitle});
    $oCh->setSummary($_->{summary});
    $oCh->setClass($_->{class});
    $oCh->addAuthor($oAu);
    $oCh->setReloadinterval($_->{reload_interval});
    my $oTi = new Scheduler::Schema::Time;
    if($_->{time_begin_use}){
      $oTi->setBegin();
      $oTi->begin->setYMDHMS(
			     $_->{time_begin_year},
			     $_->{time_begin_month},
			     $_->{time_begin_day},
			     $_->{time_begin_hour},
			     $_->{time_begin_minute},
			     $_->{time_begin_second},
			    );
    }
    if($_->{time_end_use}){
      $oTi->setEnd();
      $oTi->end->setYMDHMS($_->{time_end_year},
			   $_->{time_end_month},
			   $_->{time_end_day},
			   $_->{time_end_hour},
			   $_->{time_end_minute},
			   $_->{time_end_second},
			  );
    }
    $oCh->setTime($oTi);
    $hoChangeables{$sID} = $oCh;
  }
  return %hoChangeables;
}
sub timeDisp($){
  shift;
  my $sTargetTimeObj = shift;
  return '-' if !defined $sTargetTimeObj;
  my ($y,$m,$d,$h,$mi,$s) = $sTargetTimeObj->YMDHMS;
  my $nDeltaDays = &Delta_Days(&Today,$y,$m,$d);
  $nDeltaDays = '+'.$nDeltaDays if $nDeltaDays > 0;
  return sprintf("%d/%d %d:%02d[%sd]",$m,$d,$h,$mi,$nDeltaDays);
}
sub getGenerator(){
  my $oS = shift;
  my $oGen = new Scheduler::Schema::Generator;
  $oGen->setName($oS->oEnv->generatorName);
  $oGen->setVersion($oS->oEnv->scriptVersion);
  return $oGen;
}
{
  my @asHistoryStack;

  sub setHistoryStack($){
    my $oS = shift;
    my $sMe = shift;
    my $sLoaded = $oS->oCGI->param('hstack');
    @asHistoryStack = split(m|/|,$sLoaded);
    if(defined $sMe){
      $oS->addHistoryStack($sMe);
    }
  }
  sub addHistoryStack($){
    my $oS = shift;
    push(@asHistoryStack,$_[0]);
  }
  sub removeHistoryStack($){
    my $oS = shift;
    pop @asHistoryStack;
  }
  sub getHistoryStackByEnv{
    my $oS = shift;
    return '&hstack='.$oS->getHistoryStack;
  }
  sub getHistoryStack{
    my $oS = shift;
    if($asHistoryStack[0] ne ''){
      unshift(@asHistoryStack,'');
    }
    return join('/',@asHistoryStack);
  }
  sub resetHistoryStack{
    my $oS = shift;
    @asHistoryStack = ();
  }
  sub getIndexOfHistoryStack($){
    my $oS = shift;
    return $asHistoryStack[$_[0]];
  }
}

1;
