package Scheduler::Parser::Sche;
@ISA = qw|Scheduler::Parser::base|;

use strict;
use warnings;
use Carp;

use Scheduler::Schema::Sche;
use Scheduler::Parser::base;
use Scheduler::Parser::Generator;
use Scheduler::Parser::Changeable;

sub obj($$){
  shift;
  my $oSche = new Scheduler::Schema::Sche;
  my $oRoot = shift;
  my $oDocument = shift;
  my @a = $oRoot->getChildNodes;
  foreach(@a){
    if($_->nodeName eq 'id'){
      $oSche->setId($_->firstChild->nodeValue);
    }elsif($_->nodeName eq 'generator'){
      $oSche->setGenerator(Scheduler::Parser::Generator->obj($_,$oDocument));
    }elsif($_->nodeName eq 'mainstreamid'){
      $oSche->setMainstreamid($_->firstChild->nodeValue);
    }
  }
  my @aoURIs = $oRoot->getChildrenByTagName('link');
  foreach(@aoURIs){
    $oSche->addURI($_->getAttribute('href'));
  }
  my @aoChangeables = $oRoot->getChildrenByTagName('changeable');
  foreach(@aoChangeables){
    $oSche->addChangeable(Scheduler::Parser::Changeable->obj($_,$oDocument));
  }
  return $oSche;
}
sub element($$){
  shift;
  my $oSche = shift;
  my $oDocument = shift;
  my $oRoot = $oDocument->createElement("sche");
  $oRoot->setAttribute('version','2');
  if(defined $oSche->mainstreamid){
    my $oMSID = $oDocument->createElement("mainstreamid");
    my $oMSIDN = $oDocument->createTextNode($oSche->mainstreamid);
    $oMSID->appendChild($oMSIDN);
    $oRoot->appendChild($oMSID);
  }else{
    my $oID = $oDocument->createElement("id");
    $oID->appendText($oSche->id);
    $oRoot->appendChild($oID);
    $oRoot->appendChild(Scheduler::Parser::Generator->element($oSche->generator,$oDocument));
    foreach(@{$oSche->uris}){
      my $oURI = $oDocument->createElement("link");
      $oURI->setAttribute("href",$_);
      $oRoot->appendChild($oURI);
    }
    foreach(@{$oSche->changeables}){
      $oRoot->addChild(Scheduler::Parser::Changeable->element($_,$oDocument));
    }
  }
  $oRoot->setNamespace('http://www.w3.org/2007/sche');
  return $oRoot;
}

1;
