package Section::List;
@ISA = qw|Section::base|;

use Section::base;
use Section::SearchBox;
use Scheduler::Filter;
use Date::Calc qw|Delta_Days Today|;

sub new{
    shift;
    return bless new Section::base(@_);
}
sub out{
  my $oS = shift;
  $oS->resetHistoryStack();
  $oS->oOut->isUsingPrototypeJS;
  my $sHeader = '<script type="text/javascript">
//<![CDATA[
';
  $sHeader .= $_ while <DATA>;
  $sHeader .= '//]]></script>';
  $oS->oOut->addHeaderEx($sHeader);undef $sHeader;
  $oS->oOut->appendBodyTagAttribute('onload','load();');  $oS->oOut->setSubtitle('LIST');
  my $sRes = $oS->oOut->sectionBegin('LIST','list');
  $sRes .= '<form name="form" method="post" action="index.cgi" /><input type="checkbox" name="show_done_halt" onclick="showDoneHalt();" />'.$oS->getEncLng('LIST_SHOW_DONE_HALT');
  my @asNeededStats = $oS->{oCGI}->param('needed_stats');
  @asNeededStats = qw|progress coming done halt|;
  my %hsStatusName;
  @hsStatusName{qw|progress coming done halt|} = ($oS->oLng->get('STATUS_PROGRESS'),
						  $oS->oLng->get('STATUS_COMING'),
						  $oS->oLng->get('STATUS_DONE'),
						  $oS->oLng->get('STATUS_HALT'),
						 );
  my $oFilter = new Scheduler::Filter;
  if(!$oS->oLgi->isLoggedIn){
    $oFilter->addFilter('changeable','class','equals','public');
  }
  my $sQuery = $oS->oCGI->param('q_query');
  if(defined $sQuery && $sQuery ne ''){
    $sRes .= '<p>SEARCHING FOR QUERY ';
    my $sQueryDec = $oS->oOut->decoded($sQuery);
    my @asQueries = split(m| |,$sQueryDec);
    foreach(@asQueries){
      $oFilter->addFilter('changeable','title','includes',$_);
    }
    $sRes .= $oS->oOut->encoded(join(' and ',@asQueries)).'</p>';
  }
  $sRes .= '<table><thead><tr><th><input type="checkbox" name="show_all" onclick="checkInAll()"/></th><th>'
    .$oS->getEncLng('STATUS').'</th><th>'
      .$oS->getEncLng('TITLE').'</th><th>'
	.$oS->getEncLng('CONTENT').'</th><th>'
	  .$oS->getEncLng('LOCATION').'</th><th>'
	    .$oS->getEncLng('TIME_BEGIN').'</th><th>'
	      .$oS->getEncLng('TIME_END').'</th></tr></thead><tbody>';
  my (%hoSches,%hoIDs,%hoStat);
  my %hoSTimeKeys = ();
  my (@aoDoneSches,@aoHaltedSches);
  foreach my $sStat(@asNeededStats){
    foreach my $sID($oS->{oDat}->getIDList('status',$sStat)){
      my $oSche = $oS->{oDat}->getScheByID($sID);
      next if !defined $oSche or !defined $oSche->changeables->[0];
      next if !$oFilter->passes($oSche);
      $hoSches{$sID} = $oSche;
      $hoStat{$sID} = $sStat;
      if($sStat eq 'done'){
	push(@aoDoneSches,[$oSche,'done']);
	next;
      }elsif($sStat eq 'halt'){
	push(@aoHaltedSches,[$oSche,'halt']);
	next;
      }
      my $sTime = $sStat eq 'coming'
	?$oSche->changeables->[0]->time->begin
	  :$oSche->changeables->[0]->time->end;
      if(!defined $sTime){
	$sTime = $sStat eq 'coming'
	  ?$oSche->changeables->[0]->time->end
	    :$oSche->changeables->[0]->time->begin;
      }
      $sTime = $sTime->time if defined $sTime;
      if(!exists($hoSTimeKeys{$sTime})){
	$hoSTimeKeys{$sTime} = 0;
      }else{
	$hoSTimeKeys{$sTime}++;
      }
      $sTime .= $hoSTimeKeys{$sTime};
      $hoIDs{$sTime} = $sID;
    }
  }
  my @aoSortedSches = ();
  for(sort keys %hoIDs){
    my $sID = $hoIDs{$_};
    my $oSche = $hoSches{$sID};
    my $sStat = $hoStat{$sID};
    push(@aoSortedSches,[$oSche,$sStat]);
  }
  my $nHideableRowNumber = 0;
  foreach(@aoDoneSches,@aoHaltedSches,@aoSortedSches){
    my ($oSche,$sStat) = @$_;
    my $sID = $oSche->id;
    if($sStat eq 'done' or $sStat eq 'halt'){
      $sRes .= qq|<tr class="status_$sStat" id="hideable_$nHideableRowNumber" name="hideable_$nHideableRowNumber">|;
      $nHideableRowNumber++;
    }else{
      $sRes .= qq|<tr class="status_$sStat">|;
    }
    my %hsShowing;
    @hsShowing{qw|title time_begin time_end|} = (
						 $oSche->changeables->[0]->title,
						 $oSche->changeables->[0]->time->begin,
						 $oSche->changeables->[0]->time->end,
						);
    if(defined $oSche->changeables->[0]->content){
      $hsShowing{content} = $oSche->changeables->[0]->content->plainText;
    }
    my @aoLocations = @{$oSche->changeables->[0]->locations};
    $hsShowing{location} = '';
    foreach(@aoLocations){
      $hsShowing{location} .= $_->name;
    }
    foreach(qw|time_begin time_end|){
      next if !defined $hsShowing{$_};
      my ($y,$m,$d,$h,$mi,$s) = $hsShowing{$_}->YMDHMS;
      my $nDeltaDays = &Delta_Days(&Today,$y,$m,$d);
      $nDeltaDays = '+'.$nDeltaDays if $nDeltaDays > 0;
      $hsShowing{$_} = sprintf("%d/%d %d:%02d[%sd]",$m,$d,$h,$mi,$nDeltaDays);
    }
    $sRes .= qq|<td><input type="checkbox" name="id" value="$sID" /></td>|.
      qq|<th>|.$oS->oOut->encoded($hsStatusName{$sStat}).q|</th>|;
    foreach(qw|title content location time_begin time_end|){
      $hsShowing{$_} = '' if !defined $hsShowing{$_};
      if($_ ne 'time_begin' and $_ ne 'time_end'){
	$hsShowing{$_} =~ s|\n||g;
	$hsShowing{$_} =~ s|&|&amp;|g;
	$hsShowing{$_} =~ s|<|&lt;|g;
	$hsShowing{$_} =~ s|>|&gt;|g;
	my $isTooLong = length($hsShowing{$_}) > 10;
	$hsShowing{$_} = substr($hsShowing{$_},0,10);
	$hsShowing{$_} .= '...' if $isTooLong;
	$hsShowing{$_} = $oS->{oOut}->encoded($hsShowing{$_});
      }
      $hsShowing{$_} = '<span class="undefined">'.$oS->getEncLng('UNDEFINED').'</span>' if $hsShowing{$_} eq '';
      $sRes .= qq|<td>$hsShowing{$_}</td>|;
    }
    $sRes .=
      qq|<td><a href="index.cgi?mode=detail&id=$sID|.$oS->getHistoryStackByEnv.q|">|.'<span class="detail">['.$oS->getEncLng('DETAIL').']</span></a></td>';
    if($oS->oLgi->isLoggedIn){
      if(!defined $oS->oDat->getScheByIDFrom($sID,'imported')){
	$sRes .= qq|<td><a href="index.cgi?mode=edit&id=$sID|.$oS->getHistoryStackByEnv.q|">|.'<span class="change">['.$oS->getEncLng('CHANGE').']</span></a></td><td></td>';
      }else{
	$sRes .= qq|<td></td><td><a href="index.cgi?mode=delete&id=$sID|.$oS->getHistoryStackByEnv.q|">|.'<span class="delete">['.$oS->getEncLng('DELETE').']</span></a></td>';
      }
      $sRes .= qq|<td><a href="index.cgi?mode=duplicate&id=$sID|.$oS->getHistoryStackByEnv.q|">|.'<span class="duplicate">['.$oS->getEncLng('DUPLICATE').']</span></a></td>';
    }
    $sRes .= qq|<td class="sche2"><a href="index.cgi?mode=xsche&id=$sID">|.'<span class="xsche">['.$oS->getEncLng('XSCHE').']</span>'.q|</a></td>|;
    $sRes .= qq|<td><a href="index.cgi?mode=linkgen&id=$sID">[|.$oS->getEncLng('LINKGEN').q|]</a></td></tr>|;
  }
  $sRes .= qq|<script type="text/javascript">\n//<![CDATA[\nvar _nHideableRowNumber = $nHideableRowNumber;\n//]]></script>|;
  $sRes .= '</tbody></table><select name="mode">';
  $sRes .= '<option value="detail">'.$oS->getEncLng('DETAIL');
  if($oS->oLgi->isLoggedIn){
    $sRes .= '</option><option value="edit">'.$oS->getEncLng('EDIT');
  }
  $sRes .= '</option><option value="xsche">'.$oS->getEncLng('XSCHE');
  $sRes .= '</option><option value="linkgen">'.$oS->getEncLng('LINKGEN');
#  $sRes .= '</option><option value="schedul">'.$oS->getEncLng('SCHEDUL');
  $sRes .= '</option>';
  $sRes .= '</select><input type="hidden" name="hstack" value="'.$oS->getHistoryStack.'" /><input type="submit" value="'.$oS->getEncLng('LIST_DO_AT_ONCE').'"></form>';
  $sRes .= $oS->oOut->sectionEnd.Section::SearchBox->new($oS->env)->out;
  return $sRes;
}

1;

__DATA__
function load(){
  showDoneHalt();
}
function showDoneHalt(){
  var _sVisibility;
  var _sDisplay;
  var _isIE = false;
  if(navigator.userAgent.indexOf("MSIE") != -1){
    _isIE = true;
  }
  if(document.form.show_done_halt.checked){
    _sVisibility = "";
    if(_isIE){
      _sDisplay = "inline";
    }else{
      _sDisplay = "table-row";
    }
  }else{
    _sVisibility = "hidden";
    _sDisplay = "none";
  }
  var _nIt;
  for(_nIt = 0;_nIt < _nHideableRowNumber;_nIt++){
    if(_isIE){
      document.getElementById("hideable_"+_nIt).style.visibility = _sVisibility;
    }
    document.getElementById("hideable_"+_nIt).style.display = _sDisplay;
  }
}
function checkInAll(){
  var _nIt;
  for(_nIt = 0;_nIt < document.form.id.length;_nIt++){
    document.form.id[_nIt].checked = document.form.show_all.checked;
  }
}
