package Section::Update;
@ISA = qw|Section::base|;

use strict;
use warnings;
use Carp;

use Section::base;
use Scheduler::Schema::Sche;

sub new{
  shift;
  return bless Section::base->new(@_);
}
sub out{
  my $oS = shift;
  $oS->setHistoryStack('update');
  $oS->oOut->setSubtitle('Updated');
  my $sRes = $oS->oOut->sectionBegin('UPDATE','update');
  $sRes .= '<p>'.$oS->getEncLng('UPDATE_SUCCESSFULLY').'</p>';
  my %hoChangeables = $oS->submittedChangeables;
  foreach(keys %hoChangeables){
    my $oSche = new Scheduler::Schema::Sche;
    $oSche->addChangeable($hoChangeables{$_});
    if($_ !~ m|^#|){
      $oSche->setId($_);
      $oSche->addURI($oS->oEnv->storageURI.'?mode=xsche&id='.$_);
    }else{
      next if defined $oS->oDat->getScheByIDFrom($_,'imported');
    }
    $oSche->setGenerator($oS->getGenerator);
    $oS->oDat->setSche($oSche);
  }
  $oS->oDat->optimize;
  return $sRes.'<a href="javascript:history.go(-'.$oS->distanceToList.')">'.$oS->getEncLng('BACK_TO_LIST').'</a>'.$oS->oOut->sectionEnd;
}

1;
