package Scheduler::LData::PlainText;

use strict;
use warnings;
use Carp;

use Scheduler::Parser::LocationGPX;

use IO::File;
use Encode qw|encode decode|;
use File::Find;
use Digest::MD5;

sub new(%){
  shift;
  my %hE = @_;
  return bless {
		path => $hE{path},
		list => undef,
		hashes => undef,
	       };
}
sub loadLList(){
  my $oS = shift;
  if(!defined $oS->{list}){
    $oS->optimizePath;
    $oS->{list} = [];
    $oS->{hashes} = {};
    find(sub{
	   return if $_ eq '.';
	   push(@{$oS->{list}},$_);
	   $oS->{hashes}->{$_} = undef;
	 },$oS->{path}.'whole/');
  }
}
sub loadLByHash($){
  my $oS = shift;
  my $sHash = shift;
  if(!defined $oS->{hashes}->{$sHash}){
     $oS->optimizePath;
    my $oIO = new IO::File($oS->{path}.'whole/'.$sHash);
    return if !defined $oIO;
    my @asRess = $oIO->getlines;
    my $sRes = join('',@asRess);
    $sRes = decode('utf8',$sRes);
    $oS->{hashes}->{$sHash} = Scheduler::Parser::LocationGPX->objFromDocstring($sRes);
  }
}
sub findIfThisLocationExists($){
  my $oS = shift;
  my $oLoc = shift;
  return $oS->findIfThisTypeExists($oLoc->name,$oLoc->lat,$oLoc->lon);
}
sub findIfThisTypeExists($$$){
  my $oS = shift;
  my ($sName,$nLat,$nLon) = @_;
  $oS->loadLList;
  foreach(@{$oS->{list}}){
    next if defined $oS->{hashes}->{$_};
    $oS->loadLByHash($_);
  }
  foreach(values %{$oS->{hashes}}){
    if($_->name eq $sName &&
       $_->lat == $nLat &&
       $_->lon == $nLon
      ){
      return 1;
    }
  }
  return 0;
}
sub getLList(){
  my $oS = shift;
  $oS->loadLList;
  return @{$oS->{list}};
}
sub getLByHash($){
  my $oS = shift;
  my $sHash = shift;
  $oS->loadLByHash($sHash);
  return $oS->{hashes}->{$sHash};
}
sub setL($$){
  my $oS = shift;
  my $oGPX = shift;
  my $sID = shift;
  $oS->optimizePath;
  my $sGPX = Scheduler::Parser::LocationGPX->docstringFromObj($oGPX);
  if(!defined $sID){
    $sGPX = encode('UTF-8',$sGPX) if Encode::is_utf8($sGPX);
    $sID = Digest::MD5->new->add($sGPX)->hexdigest;
  }
  my $oIO = new IO::File('> '.$oS->{path}.'whole/'.$sID);
  croak('Cannot open '.$oS->{path}.'whole/'.$sID) if !defined $oIO;
  print $oIO $sGPX;
  undef $oIO;
  chmod(0666,$oS->{path}.'whole/'.$sID);
  return $sID;
}
sub delL($){
  my $oS = shift;
  my $sHash = shift;
  unlink($oS->{path}.'whole/'.$sHash);
}
sub optimizePath{
  my $oS = shift;
  $oS->{path} .= '/' unless $oS->{path} =~ m|/$|;
  mkdir($oS->{path}) if !-e $oS->{path};
  croak('Cannot make hidden counter file for plaintext location database in directory '.$oS->{path}.' : is not writable for user id '.$>) if !-w $oS->{path};
  chmod(0755,$oS->{path});
  mkdir($oS->{path}.'whole/') if !-e $oS->{path}.'whole/';
  croak('Cannot make hidden counter file for plaintext location database in directory '.$oS->{path}.'whole/'.' : is not writable for user id '.$>) if !-w $oS->{path}.'whole/';
  chmod(0755,$oS->{path}.'whole/');
}

1;
