package Scheduler::Parser::Feed;
@ISA = qw|Scheduler::Parser::base|;

use strict;
use warnings;
use Carp;

use Scheduler::Parser::base;
use Scheduler::Parser::Sche;
use Scheduler::Parser::Generator;
use Scheduler::Schema::Feed;

sub obj($){
  shift;
  my $oFeed = new Scheduler::Schema::Feed;
  my $oRoot = shift;
  my $oDocument = shift;
  my @a = $oRoot->getChildNodes;
  foreach(@a){
    if($_->nodeName eq 'sche'){
      $oFeed->addSche(Scheduler::Parser::Sche->obj($_,$oDocument));
    }elsif($_->nodeName eq 'generator'){
      $oFeed->setGenerator(Scheduler::Parser::Generator->obj($_,$oDocument));
    }
  }
  return $oFeed;
}
sub element($){
  shift;
  my $oFeed = shift;
  my $oDocument = shift;
  my $oRoot = $oDocument->createElement('feed');
  $oRoot->setAttribute('version','2');
  $oRoot->addChild(Scheduler::Parser::Generator->element($oFeed->generator,$oDocument));
  foreach(@{$oFeed->sches}){
    $oRoot->addChild(Scheduler::Parser::Sche->element($_,$oDocument));
  }
  return $oRoot;
}

1;
